/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.edit.commands;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.sirius.diagram.ui.internal.operation.CenterEdgeEndModelChangeOperation;

public class CenterEditPartEdgesCommand
extends AbstractTransactionalCommand {
    IGraphicalEditPart editPart;

    public CenterEditPartEdgesCommand(IGraphicalEditPart graphicalEditPart) {
        super(graphicalEditPart.getEditingDomain(), "Center Edges", null);
        this.editPart = graphicalEditPart;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        ArrayList edges = new ArrayList();
        edges.addAll(this.editPart.getSourceConnections());
        edges.addAll(this.editPart.getTargetConnections());
        for (ConnectionEditPart connection : Iterables.filter(edges, ConnectionEditPart.class)) {
            Object model = connection.getModel();
            if (!(model instanceof Edge)) continue;
            CenterEdgeEndModelChangeOperation centerEdgeEndModelChangeOperation = new CenterEdgeEndModelChangeOperation((Edge)model, false);
            centerEdgeEndModelChangeOperation.execute();
        }
        return CommandResult.newOKCommandResult();
    }

    public void dispose() {
        this.editPart = null;
        super.dispose();
    }
}

