/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.layout.ordering;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gmf.runtime.notation.View;

public final class GridView {
    private List<Column> columns;

    private GridView() {
    }

    public static GridView create(View[][] views) {
        GridView gridView = new GridView();
        int maxLength = -1;
        View[][] viewArray = views;
        int n = views.length;
        int n2 = 0;
        while (n2 < n) {
            View[] view = viewArray[n2];
            if (view.length > maxLength) {
                maxLength = view.length;
            }
            ++n2;
        }
        View[][] copyView = new View[views.length][];
        System.arraycopy(views, 0, copyView, 0, views.length);
        int i = 0;
        while (i < views.length) {
            copyView[i] = new View[maxLength];
            System.arraycopy(views[i], 0, copyView[i], 0, views[i].length);
            ++i;
        }
        gridView.columns = new ArrayList<Column>(copyView.length);
        i = 0;
        while (i < views.length) {
            GridView gridView2 = gridView;
            gridView2.getClass();
            Column column = gridView2.new Column(views[i], i);
            gridView.columns.add(column);
            ++i;
        }
        gridView.columns = Collections.unmodifiableList(gridView.columns);
        return gridView;
    }

    public int getColumnsCount() {
        return this.columns.size();
    }

    public int getLinesCount() {
        return this.getColumnsCount() > 0 ? this.getColumnAt(0).getViewsCount() : 0;
    }

    public Column getColumnAt(int index) throws IndexOutOfBoundsException {
        return this.columns.get(index);
    }

    public View getViewAt(int columnIndex, int lineIndex) throws IndexOutOfBoundsException {
        return this.getColumnAt(columnIndex).getViewAt(lineIndex);
    }

    public Iterator<Column> iteratorColumns() {
        return this.columns.iterator();
    }

    public class Column {
        private List<View> views;
        private int index;

        Column(View[] views, int index) throws IllegalArgumentException {
            this.views = new ArrayList<View>(Arrays.asList(views));
            this.views = Collections.unmodifiableList(this.views);
            this.index = index;
        }

        public View getLeftSibling(View view) throws IllegalArgumentException {
            if (!this.views.contains(view)) {
                throw new IllegalArgumentException("The view is not in the column");
            }
            if (this.index == 0) {
                return null;
            }
            return GridView.this.getViewAt(this.index - 1, this.views.indexOf(view));
        }

        public View getRightSibling(View view) throws IllegalArgumentException {
            if (!this.views.contains(view)) {
                throw new IllegalArgumentException("The view is not in the column");
            }
            if (this.index + 1 == GridView.this.getColumnsCount()) {
                return null;
            }
            return GridView.this.getViewAt(this.index + 1, this.views.indexOf(view));
        }

        public View getViewAt(int viewIndex) throws IndexOutOfBoundsException {
            return this.views.get(viewIndex);
        }

        public int indexOf(View view) {
            return this.views.indexOf(view);
        }

        public int getViewsCount() {
            return this.views.size();
        }

        public Column getLeftSibling() {
            if (this.index != 0) {
                return (Column)GridView.this.columns.get(this.index - 1);
            }
            return null;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

