/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.commands;

import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.ConnectorStyle;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.sirius.diagram.EdgeRouting;
import org.eclipse.sirius.diagram.EdgeStyle;

public class UpdateGMFEdgeStyleCommand
extends RecordingCommand {
    private Edge edge;
    private EdgeStyle style;

    public UpdateGMFEdgeStyleCommand(TransactionalEditingDomain domain, Edge edge, EdgeStyle style) {
        super(domain, "Update GMF Edge Style");
        this.edge = edge;
        this.style = style;
    }

    protected void doExecute() {
        if (this.edge != null && this.edge.getStyles() != null) {
            for (Object notationStyle : this.edge.getStyles()) {
                if (!(notationStyle instanceof ConnectorStyle)) continue;
                ConnectorStyle connectorStyle = (ConnectorStyle)notationStyle;
                if (EdgeRouting.MANHATTAN_LITERAL == this.style.getRoutingStyle()) {
                    connectorStyle.setRouting(Routing.RECTILINEAR_LITERAL);
                    continue;
                }
                if (EdgeRouting.STRAIGHT_LITERAL == this.style.getRoutingStyle()) {
                    connectorStyle.setRouting(Routing.MANUAL_LITERAL);
                    continue;
                }
                if (EdgeRouting.TREE_LITERAL != this.style.getRoutingStyle()) continue;
                connectorStyle.setRouting(Routing.TREE_LITERAL);
            }
        }
    }
}

