/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.handler;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramCommandStack;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramContainerEditPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class ResetOriginHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IWorkbenchPart workbenchPart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (selection instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)selection;
            if (structuredSelection.getFirstElement() instanceof DiagramEditPart) {
                this.getAndExecuteCmd(workbenchPart, new GraphicalEditPart[]{(DiagramEditPart)structuredSelection.getFirstElement()});
            } else {
                ArrayList selectedAbstractDiagramContainerEditParts = Lists.newArrayList((Iterator)Iterators.filter((Iterator)structuredSelection.iterator(), AbstractDiagramContainerEditPart.class));
                if (!selectedAbstractDiagramContainerEditParts.isEmpty()) {
                    this.getAndExecuteCmd(workbenchPart, (GraphicalEditPart[])selectedAbstractDiagramContainerEditParts.toArray(new AbstractDiagramContainerEditPart[0]));
                }
            }
        }
        return null;
    }

    private void getAndExecuteCmd(IWorkbenchPart workbenchPart, GraphicalEditPart ... selection) {
        Command command;
        if (selection.length == 1) {
            command = selection[0].getCommand(new Request((Object)"resetOrigin"));
        } else {
            CompoundCommand compoundCommand = new CompoundCommand();
            int i = 0;
            while (i < selection.length) {
                compoundCommand.add(selection[i].getCommand(new Request((Object)"resetOrigin")));
                ++i;
            }
            command = compoundCommand;
        }
        DiagramCommandStack commandStack = this.getDiagramCommandStack(workbenchPart);
        if (commandStack != null) {
            commandStack.execute(command);
        }
    }

    private DiagramCommandStack getDiagramCommandStack(IWorkbenchPart workbenchPart) {
        Object stack = workbenchPart.getAdapter(CommandStack.class);
        return stack instanceof DiagramCommandStack ? (DiagramCommandStack)stack : null;
    }
}

