/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.api.diagramtype;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.sirius.diagram.business.api.diagramtype.IDiagramDescriptionProvider;
import org.eclipse.sirius.diagram.business.api.diagramtype.IDiagramTypeDescriptor;
import org.eclipse.sirius.viewpoint.SiriusPlugin;

public final class DiagramTypeDescriptorRegistry {
    private static final String DIAGRAM_TYPE_EP_ID = "org.eclipse.sirius.diagram.diagramTypeProvider";
    private static final String DIAGRAM_DESCRIPTION_PROVIDER_ATTR = "descriptionProvider";
    private static final String LABEL_ATTRIBUTE = "label";
    private static DiagramTypeDescriptorRegistry instance;
    private Collection<IDiagramTypeDescriptor> allProviders;

    private DiagramTypeDescriptorRegistry() {
    }

    public static DiagramTypeDescriptorRegistry getInstance() {
        if (instance == null) {
            instance = new DiagramTypeDescriptorRegistry();
        }
        return instance;
    }

    public Collection<IDiagramTypeDescriptor> getAllDiagramTypeDescriptors() {
        return Collections.unmodifiableCollection(this.internalGetAllDiagramTypeDescriptors());
    }

    public void registerDiagramTypeDescriptor(IDiagramTypeDescriptor diagramTypeDescriptor) {
        this.internalGetAllDiagramTypeDescriptors().add(diagramTypeDescriptor);
    }

    public void unregisterDiagramTypeDescriptor(IDiagramTypeDescriptor diagramTypeDescriptor) {
        this.internalGetAllDiagramTypeDescriptors().remove(diagramTypeDescriptor);
    }

    private Collection<IDiagramTypeDescriptor> internalGetAllDiagramTypeDescriptors() {
        if (this.allProviders == null) {
            this.allProviders = new HashSet<IDiagramTypeDescriptor>();
            this.loadDescriptors();
        }
        return this.allProviders;
    }

    private void loadDescriptors() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint ep = extensionRegistry.getExtensionPoint(DIAGRAM_TYPE_EP_ID);
        IExtension[] iExtensionArray = ep.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] ces;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = ces = extension.getConfigurationElements();
            int n3 = ces.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement ce = iConfigurationElementArray[n4];
                try {
                    Object provider = ce.createExecutableExtension(DIAGRAM_DESCRIPTION_PROVIDER_ATTR);
                    if (provider instanceof IDiagramDescriptionProvider) {
                        String label = ce.getAttribute(LABEL_ATTRIBUTE);
                        PluginDiagramTypeDescriptor descriptor = new PluginDiagramTypeDescriptor(label, (IDiagramDescriptionProvider)provider);
                        this.allProviders.add(descriptor);
                    } else {
                        SiriusPlugin.getDefault().error("Error while loading the extension : " + extension.getLabel(), (Throwable)new ClassCastException());
                    }
                }
                catch (CoreException e) {
                    SiriusPlugin.getDefault().error("Error while loading the extension " + extension.getLabel(), (Throwable)e);
                    SiriusPlugin.getDefault().getLog().log(e.getStatus());
                }
                ++n4;
            }
            ++n2;
        }
    }

    private static class PluginDiagramTypeDescriptor
    implements IDiagramTypeDescriptor {
        private String label;
        private IDiagramDescriptionProvider diagramDescriptionProvider;

        public PluginDiagramTypeDescriptor(String label, IDiagramDescriptionProvider diagramDescriptionProvider) throws IllegalArgumentException {
            this.label = label;
            this.diagramDescriptionProvider = diagramDescriptionProvider;
        }

        @Override
        public IDiagramDescriptionProvider getDiagramDescriptionProvider() {
            return this.diagramDescriptionProvider;
        }

        @Override
        public String getLabel() {
            return this.label;
        }
    }
}

