/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.support.api;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.junit.Assert;

public abstract class AbstractInterpretedExpressionTestCase
extends TestCase {
    private static final String RETURN_TYPE = "http://www.eclipse.org/sirius/interpreted/expression/returnType";
    private static final String VARIABLES = "http://www.eclipse.org/sirius/interpreted/expression/variables";
    private Collection<EAttribute> interpretedExpressions;
    private EPackage basePackage;
    private final Predicate<EAttribute> isInterpretedExpression = new Predicate<EAttribute>(){

        public boolean apply(EAttribute input) {
            return DescriptionPackage.eINSTANCE.getInterpretedExpression().equals(input.getEAttributeType());
        }
    };

    public EPackage getBasePackage() {
        return this.basePackage;
    }

    public void setBasePackage(EPackage basePackage) {
        this.basePackage = basePackage;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.interpretedExpressions = Sets.newLinkedHashSet();
        Assert.assertNotNull((String)"Base package should not be null.", (Object)this.basePackage);
        this.handleEPackage(this.basePackage);
    }

    private void handleEPackage(EPackage pkg) {
        for (EClass eclass : Iterables.filter((Iterable)pkg.getEClassifiers(), EClass.class)) {
            this.handleEClass(eclass);
        }
        for (EPackage subPkg : pkg.getESubpackages()) {
            this.handleEPackage(subPkg);
        }
    }

    private void handleEClass(EClass eclass) {
        Iterables.addAll(this.interpretedExpressions, (Iterable)Iterables.filter((Iterable)eclass.getEAttributes(), this.isInterpretedExpression));
    }

    public void testVariablesInterpretedExpressionEAnnotation() {
        ArrayList nonDocumented = Lists.newArrayList();
        Predicate<EAttribute> needsDocumentation = new Predicate<EAttribute>(){

            public boolean apply(EAttribute input) {
                EAnnotation eAnnotation = input.getEAnnotation(AbstractInterpretedExpressionTestCase.VARIABLES);
                return eAnnotation == null;
            }
        };
        Iterables.addAll((Collection)nonDocumented, (Iterable)Iterables.filter(this.interpretedExpressions, (Predicate)needsDocumentation));
        Assert.assertTrue((String)this.getMessage(nonDocumented, VARIABLES), (boolean)nonDocumented.isEmpty());
    }

    public void testReturnTypeInterpretedExpressionEAnnotation() {
        ArrayList nonDocumented = Lists.newArrayList();
        Predicate<EAttribute> needsReturnType = new Predicate<EAttribute>(){

            public boolean apply(EAttribute input) {
                EAnnotation eAnnotation = input.getEAnnotation(AbstractInterpretedExpressionTestCase.RETURN_TYPE);
                return eAnnotation == null || eAnnotation.getDetails().isEmpty();
            }
        };
        Iterables.addAll((Collection)nonDocumented, (Iterable)Iterables.filter(this.interpretedExpressions, (Predicate)needsReturnType));
        Assert.assertTrue((String)this.getMessage(nonDocumented, RETURN_TYPE), (boolean)nonDocumented.isEmpty());
    }

    private String getMessage(List<EAttribute> nonDocumented, String source) {
        StringBuilder sb = new StringBuilder();
        sb.append(nonDocumented.size());
        sb.append(" interpreted expression(s) needs variable EAnnotation ");
        sb.append(source);
        sb.append(": ");
        for (EAttribute attr : nonDocumented) {
            sb.append("\n . ");
            sb.append(attr.eResource().getURIFragment((EObject)attr));
        }
        return sb.toString();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.interpretedExpressions.clear();
    }
}

