/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.swtbot.support.api.business;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.SessionManagerListener;
import org.eclipse.sirius.tests.swtbot.support.api.business.UILocalSession;
import org.eclipse.sirius.tests.swtbot.support.api.business.UIProject;
import org.eclipse.sirius.tests.swtbot.support.api.business.UIResource;
import org.eclipse.sirius.tests.swtbot.support.api.business.UISessionCreationWizardFlow;
import org.eclipse.sirius.tests.swtbot.support.api.condition.OpenedSessionCondition;
import org.eclipse.sirius.tests.swtbot.support.api.condition.TreeItemAvailableCondition;
import org.eclipse.sirius.tests.swtbot.support.internal.business.UISessionCreationWizard;
import org.eclipse.sirius.tests.swtbot.support.utils.SWTBotUtils;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.waits.Conditions;
import org.eclipse.swtbot.swt.finder.waits.DefaultCondition;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class UIPerspective {
    private static final String VIEWPOINT = "Sirius";
    private static final String WIZARDS_LIST_TITLE = "New";
    private static final String REPRESENTATIONS_FILE_LABEL = "Representations File";
    private final SWTWorkbenchBot bot;

    public UIPerspective(SWTWorkbenchBot bot) {
        this.bot = bot;
    }

    public UIProject createProject(String projectName) {
        IProjectDescription projectDescription = ResourcesPlugin.getWorkspace().newProjectDescription(projectName);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        try {
            if (!project.exists()) {
                project.create(projectDescription, (IProgressMonitor)new NullProgressMonitor());
            }
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        return new UIProject(projectName);
    }

    public void deleteProject(UIProject project) {
        this.deleteProject(project.getName());
    }

    public void deleteProject(String projectName) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        try {
            if (project.exists()) {
                project.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    public UISessionCreationWizardFlow.SessionChoice openSessionCreationWizard() {
        this.openRepresentationsFileWizard();
        return new UISessionCreationWizard();
    }

    public UISessionCreationWizardFlow.SessionChoice openSessionCreationWizardFromSemanticResource(UIResource uiResource) {
        uiResource.getProject().selectResource(uiResource);
        this.openRepresentationsFileWizard();
        return new UISessionCreationWizard(uiResource);
    }

    private void openRepresentationsFileWizard() {
        this.bot.menu("File").menu(WIZARDS_LIST_TITLE).menu("Other...").click();
        SWTBot wizardListBot = this.bot.activeShell().bot();
        wizardListBot.waitUntil(Conditions.shellIsActive((String)WIZARDS_LIST_TITLE));
        wizardListBot.text().setText(REPRESENTATIONS_FILE_LABEL);
        SWTBotTree wizardsTree = wizardListBot.tree();
        wizardsTree.setFocus();
        SWTBotTreeItem viewpointCategory = null;
        try {
            viewpointCategory = wizardsTree.getTreeItem(VIEWPOINT);
        }
        catch (WidgetNotFoundException widgetNotFoundException) {
            this.bot.waitUntil((ICondition)new TreeItemAvailableCondition(wizardsTree, VIEWPOINT, true));
            viewpointCategory = wizardsTree.getTreeItem(VIEWPOINT);
        }
        viewpointCategory.expand();
        SWTBotTreeItem representationsFileNode = viewpointCategory.getNode(REPRESENTATIONS_FILE_LABEL);
        representationsFileNode.select();
        wizardListBot.button("Next >").click();
        this.bot.waitUntil(Conditions.shellIsActive((String)"New Representations File"));
    }

    public UILocalSession openSessionFromFile(UIResource uiLocalSessionResource) {
        return this.openSessionFromFile(uiLocalSessionResource, false);
    }

    public UILocalSession openSessionFromFile(UIResource uiLocalSessionResource, boolean useMoreThanOneSemanticFiles) {
        OpenedSessionListener openedSessionListener = new OpenedSessionListener();
        SessionManager.INSTANCE.addSessionsListener((SessionManagerListener)openedSessionListener);
        OpenedSessionCondition addedToSessionManager = new OpenedSessionCondition(SessionManager.INSTANCE.getSessions().size() + 1);
        uiLocalSessionResource.openSession();
        SWTBotUtils.waitProgressMonitorClose("Loading models", "Loading models", SWTBotUtils.CLOSE_PROGRESS_MONITOR_TIMEOUT, TimeUnit.SECONDS, false);
        this.bot.waitUntil((ICondition)addedToSessionManager);
        this.bot.waitUntil((ICondition)openedSessionListener);
        SessionManager.INSTANCE.removeSessionsListener((SessionManagerListener)openedSessionListener);
        Session openedSession = openedSessionListener.getOpenedSession();
        if (openedSession == null) {
            Assert.assertTrue((String)"No session is opened!", (SessionManager.INSTANCE.getSessions().size() > 0 ? 1 : 0) != 0);
        }
        Collection semanticResources = openedSession.getSemanticResources();
        if (useMoreThanOneSemanticFiles) {
            MatcherAssert.assertThat((String)"Semantic resource not found", (Object)semanticResources.size(), (Matcher)Matchers.not((Matcher)Matchers.is((Object)0)));
        } else if (semanticResources.size() > 1) {
            StringBuffer names = new StringBuffer();
            for (Resource resource : semanticResources) {
                names.append(resource.getURI().toPlatformString(true));
                names.append(", ");
            }
            names.delete(names.length() - 2, names.length());
            Assert.fail((String)("Too many semantic resources, only one semantic resource is expected. List of semantic resources: " + names));
        }
        Resource semanticResource = (Resource)semanticResources.iterator().next();
        return new UILocalSession(UIResource.createFromResource(semanticResource), uiLocalSessionResource, openedSession);
    }

    public UILocalSession getOpenedSession(UIResource uiResource) {
        final SessionManager sessionManager = SessionManager.INSTANCE;
        this.bot.waitUntil((ICondition)new DefaultCondition(){

            public boolean test() throws Exception {
                return !sessionManager.getSessions().isEmpty();
            }

            public String getFailureMessage() {
                return "no session have been created";
            }
        });
        Session session = (Session)sessionManager.getSessions().iterator().next();
        Collection semanticResources = session.getSemanticResources();
        Resource semanticResource = (Resource)semanticResources.iterator().next();
        UIResource uiSemanticResource = UIResource.createFromResource(semanticResource);
        return new UILocalSession(uiSemanticResource, uiResource, session);
    }

    private final class OpenedSessionListener
    extends SessionManagerListener.Stub
    implements ICondition {
        private Session openedSession;

        private OpenedSessionListener() {
        }

        public Session getOpenedSession() {
            return this.openedSession;
        }

        public void notify(Session updated, int notification) {
            switch (notification) {
                case 7: {
                    this.openedSession = updated;
                    break;
                }
            }
        }

        public boolean test() throws Exception {
            return this.openedSession != null;
        }

        public void init(SWTBot botInit) {
        }

        public String getFailureMessage() {
            return "No received OPENED notification.";
        }
    }
}

