/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.session;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.helper.SiriusResourceHelper;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.util.EqualityHelper;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class ViewpointSelector {
    private final Session session;

    public ViewpointSelector(Session session) {
        this.session = (Session)Preconditions.checkNotNull((Object)session);
    }

    public void selectViewpoint(Viewpoint viewpoint, boolean createNewRepresentations, IProgressMonitor monitor) {
        Viewpoint editingDomainViewpoint = SiriusResourceHelper.getCorrespondingViewpoint(this.session, viewpoint);
        boolean newView = false;
        if (editingDomainViewpoint != null && !SiriusResourceHelper.isViewExistForSirius(this.session, editingDomainViewpoint) && !this.session.getSemanticResources().isEmpty()) {
            ArrayList roots = Lists.newArrayList();
            for (Resource resource : this.session.getSemanticResources()) {
                if (resource == null) continue;
                roots.addAll(resource.getContents());
            }
            this.session.createView(editingDomainViewpoint, roots, createNewRepresentations, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            DialectManager.INSTANCE.updateRepresentationsExtendedBy(this.session, editingDomainViewpoint, true);
            newView = true;
        }
        for (DView view : this.session.getOwnedViews()) {
            if (view.getViewpoint() != null && view.getViewpoint().eResource() != null) continue;
            this.session.removeSelectedView(view, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            DialectManager.INSTANCE.updateRepresentationsExtendedBy(this.session, editingDomainViewpoint, false);
        }
        if (!newView) {
            for (DView view : this.session.getOwnedViews()) {
                if (view.getViewpoint() == null || !EqualityHelper.areEquals((EObject)view.getViewpoint(), (EObject)viewpoint) || this.session.getSelectedViewpoints(false).contains(view.getViewpoint())) continue;
                this.session.addSelectedView(view, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                DialectManager.INSTANCE.updateRepresentationsExtendedBy(this.session, editingDomainViewpoint, true);
            }
        }
    }

    public void deselectViewpoint(Viewpoint deselectedViewpoint, IProgressMonitor monitor) {
        for (DView view : this.session.getSelectedViews()) {
            if (view.getViewpoint() == null || !EqualityHelper.areEquals((EObject)view.getViewpoint(), (EObject)deselectedViewpoint)) continue;
            this.session.removeSelectedView(view, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            Viewpoint editingDomainViewpoint = SiriusResourceHelper.getCorrespondingViewpoint(this.session, deselectedViewpoint);
            DialectManager.INSTANCE.updateRepresentationsExtendedBy(this.session, editingDomainViewpoint, false);
        }
    }
}

