/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.edit.internal.part;

import java.util.Collections;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.tools.api.command.GMFCommandWrapper;
import org.eclipse.sirius.diagram.ui.tools.api.layout.PinHelper;
import org.eclipse.sirius.diagram.ui.tools.internal.commands.emf.PinElementsCommand;
import org.eclipse.sirius.diagram.ui.tools.internal.preferences.SiriusDiagramUiInternalPreferencesKeys;

public final class CommonEditPartOperation {
    private CommonEditPartOperation() {
    }

    public static org.eclipse.gef.commands.Command handleAutoPinOnInteractiveMove(IDiagramElementEditPart self, Request request, org.eclipse.gef.commands.Command cmd) {
        org.eclipse.gef.commands.Command result = cmd;
        EObject semanticElement = self.resolveSemanticElement();
        if (semanticElement instanceof DDiagramElement) {
            DDiagramElement dDiagramElement = (DDiagramElement)semanticElement;
            if ("move".equals(request.getType()) && !new PinHelper().isPinned(dDiagramElement) && CommonEditPartOperation.autoPinOnMoveEnabled() && CommonEditPartOperation.isInteractiveMove() && PinHelper.allowsPinUnpin(dDiagramElement)) {
                CompoundCommand cc = new CompoundCommand();
                cc.add(cmd);
                PinElementsCommand emfCommand = new PinElementsCommand(Collections.singleton(dDiagramElement));
                ICommandProxy pinCmd = new ICommandProxy((ICommand)new GMFCommandWrapper(self.getEditingDomain(), (Command)emfCommand));
                cc.add((org.eclipse.gef.commands.Command)pinCmd);
                result = cc.unwrap();
            }
        }
        return result;
    }

    private static boolean autoPinOnMoveEnabled() {
        return DiagramUIPlugin.getPlugin().getPreferenceStore().getBoolean(SiriusDiagramUiInternalPreferencesKeys.PREF_AUTO_PIN_ON_MOVE.name());
    }

    private static boolean isInteractiveMove() {
        RuntimeException re = new RuntimeException();
        StackTraceElement[] stack = re.getStackTrace();
        int i = 3;
        while (i < 6 && i < stack.length) {
            try {
                if (DragTracker.class.isAssignableFrom(Class.forName(stack[i].getClassName()))) {
                    return true;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                break;
            }
            ++i;
        }
        return false;
    }
}

