/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.graphical.edit.policies;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.AlignmentRequest;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.business.internal.query.DDiagramElementContainerExperimentalQuery;
import org.eclipse.sirius.diagram.business.internal.query.DNodeContainerExperimentalQuery;
import org.eclipse.sirius.diagram.ui.business.internal.query.RequestQuery;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramElementContainerEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.AirResizableEditPolicy;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.AbstractDNodeContainerCompartmentEditPart;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public class RegionResizableEditPolicy
extends AirResizableEditPolicy {
    public void setHost(EditPart host) {
        super.setHost(host);
        if (this.concernRegion()) {
            this.setResizeDirections(this.getStackDirection());
            this.setDragAllowed(false);
        }
    }

    @Override
    protected Command getMoveCommand(ChangeBoundsRequest request) {
        if (this.concernRegion()) {
            return UnexecutableCommand.INSTANCE;
        }
        return super.getMoveCommand(request);
    }

    @Override
    protected Command getResizeCommand(ChangeBoundsRequest request) {
        Command resizeCommand = super.getResizeCommand(request);
        if (this.concernRegion()) {
            resizeCommand = this.getRegionResizeCommand(request, resizeCommand);
        }
        return resizeCommand;
    }

    @Override
    protected Command getAlignCommand(AlignmentRequest request) {
        if (this.concernRegion()) {
            return UnexecutableCommand.INSTANCE;
        }
        return super.getAlignCommand(request);
    }

    @Override
    protected Command getAutoSizeCommand(Request request) {
        Command autoSizeCommand = super.getAutoSizeCommand(request);
        if (this.concernRegion()) {
            EditPart regionContainerPart = this.getRegionContainerPart();
            Object object = request.getExtendedData().get("region_auto-size_propagator");
            if (object == this.getHost()) {
                autoSizeCommand = null;
            } else if (object != regionContainerPart) {
                Request req = new Request();
                req.setType(request.getType());
                req.getExtendedData().put("region_auto-size_propagator", this.getHost());
                CompoundCommand cc = new CompoundCommand();
                cc.add(autoSizeCommand);
                cc.add(regionContainerPart.getCommand(req));
                autoSizeCommand = cc;
            }
        }
        return autoSizeCommand;
    }

    protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
        Option<ChangeBoundsRequest> siblingRequest;
        super.showChangeBoundsFeedback(request);
        if (this.concernRegion() && (siblingRequest = this.getConstrainedSiblingRequest(request)).some() && ((ChangeBoundsRequest)siblingRequest.get()).getEditParts() != null && ((ChangeBoundsRequest)siblingRequest.get()).getEditParts().size() == 1) {
            EditPart siblingPart = (EditPart)((ChangeBoundsRequest)siblingRequest.get()).getEditParts().get(0);
            siblingPart.showSourceFeedback((Request)siblingRequest.get());
        }
    }

    protected void eraseChangeBoundsFeedback(ChangeBoundsRequest request) {
        Option<ChangeBoundsRequest> siblingRequest;
        super.eraseChangeBoundsFeedback(request);
        if (this.concernRegion() && (siblingRequest = this.getConstrainedSiblingRequest(request)).some() && ((ChangeBoundsRequest)siblingRequest.get()).getEditParts() != null && ((ChangeBoundsRequest)siblingRequest.get()).getEditParts().size() == 1) {
            EditPart siblingPart = (EditPart)((ChangeBoundsRequest)siblingRequest.get()).getEditParts().get(0);
            siblingPart.eraseSourceFeedback((Request)siblingRequest.get());
        }
    }

    private Command getRegionResizeCommand(ChangeBoundsRequest request, Command command) {
        boolean invalidRequest;
        boolean bl = invalidRequest = request.getEditParts().size() > 1 && !request.isConstrainedResize() || request.isCenteredResize();
        if (invalidRequest || !this.validateResize(request)) {
            return UnexecutableCommand.INSTANCE;
        }
        Command regionResizeCommand = command;
        Option<ChangeBoundsRequest> siblingRequest = this.getConstrainedSiblingRequest(request);
        if (siblingRequest.some() && ((ChangeBoundsRequest)siblingRequest.get()).getEditParts() != null && ((ChangeBoundsRequest)siblingRequest.get()).getEditParts().size() == 1) {
            EditPart siblingPart = (EditPart)((ChangeBoundsRequest)siblingRequest.get()).getEditParts().get(0);
            regionResizeCommand = this.composeCommands(command, siblingPart.getCommand((Request)siblingRequest.get()));
        } else if (!request.isConstrainedMove() && !request.isConstrainedResize()) {
            regionResizeCommand = UnexecutableCommand.INSTANCE;
        }
        return regionResizeCommand;
    }

    private boolean validateResize(ChangeBoundsRequest request) {
        IFigure hostFigure = this.getHostFigure();
        if (hostFigure != null) {
            Dimension minimumSize = hostFigure.getMinimumSize().getCopy();
            Rectangle resultingBounds = new RequestQuery((Request)request).getLogicalTransformedRectangle(hostFigure.getBounds().getCopy());
            return resultingBounds.width >= minimumSize.width && resultingBounds.height >= minimumSize.height;
        }
        return false;
    }

    private Option<ChangeBoundsRequest> getConstrainedSiblingRequest(ChangeBoundsRequest request) {
        ChangeBoundsRequest constrainedRequest = null;
        RequestQuery query = new RequestQuery((Request)request);
        Dimension sizeDelta = request.getSizeDelta().getCopy();
        ChangeBoundsRequest req = new ChangeBoundsRequest();
        req.setConstrainedResize(true);
        req.setConstrainedMove(true);
        req.setType(request.getType());
        int stackDirection = this.getStackDirection();
        if (stackDirection == 5) {
            if (query.isResizeFromTop()) {
                Option<AbstractDiagramElementContainerEditPart> pred;
                if (!this.isFirstRegionPart() && !request.isConstrainedResize() && (pred = this.getPrecedingRegion()).some()) {
                    req.setEditParts((EditPart)pred.get());
                    req.setResizeDirection(4);
                    req.setSizeDelta(new Dimension(0, sizeDelta.getNegated().height));
                    constrainedRequest = req;
                }
            } else if (query.isResizeFromBottom()) {
                Option<AbstractDiagramElementContainerEditPart> follo;
                if (this.isLastRegionPart() && !request.isConstrainedResize()) {
                    EditPart regionContainer = this.getRegionContainerPart();
                    req.setEditParts(regionContainer);
                    req.setResizeDirection(request.getResizeDirection());
                    req.setSizeDelta(new Dimension(0, sizeDelta.height));
                    constrainedRequest = req;
                } else if (!request.isConstrainedResize() && (follo = this.getFollowingRegion()) != null) {
                    Point moveDelta = new Point(sizeDelta.width, sizeDelta.height);
                    req.setEditParts((EditPart)follo.get());
                    req.setResizeDirection(1);
                    req.setSizeDelta(new Dimension(0, sizeDelta.getNegated().height));
                    req.setMoveDelta(new Point(0, moveDelta.y));
                    constrainedRequest = req;
                }
            }
        } else if (stackDirection == 24) {
            if (query.isResizeFromLeft()) {
                Option<AbstractDiagramElementContainerEditPart> pred;
                if (!this.isFirstRegionPart() && !request.isConstrainedResize() && (pred = this.getPrecedingRegion()).some()) {
                    req.setEditParts((EditPart)pred.get());
                    req.setResizeDirection(16);
                    req.setSizeDelta(new Dimension(sizeDelta.getNegated().width, 0));
                    constrainedRequest = req;
                }
            } else if (query.isResizeFromRight()) {
                Option<AbstractDiagramElementContainerEditPart> follo;
                if (this.isLastRegionPart() && !request.isConstrainedResize()) {
                    EditPart regionContainer = this.getRegionContainerPart();
                    req.setEditParts(regionContainer);
                    req.setResizeDirection(request.getResizeDirection());
                    req.setSizeDelta(new Dimension(sizeDelta.width, 0));
                    constrainedRequest = req;
                } else if (!request.isConstrainedResize() && (follo = this.getFollowingRegion()) != null) {
                    Point moveDelta = new Point(sizeDelta.width, sizeDelta.height);
                    req.setEditParts((EditPart)follo.get());
                    req.setResizeDirection(1);
                    req.setSizeDelta(new Dimension(sizeDelta.getNegated().width, 0));
                    req.setMoveDelta(new Point(moveDelta.x, 0));
                    constrainedRequest = req;
                }
            }
        }
        return Options.newSome(constrainedRequest);
    }

    private EditPart getRegionContainerPart() {
        EditPart regionContainer = this.getHost().getParent();
        if (regionContainer != null) {
            regionContainer = regionContainer.getParent();
        }
        return regionContainer;
    }

    private Command composeCommands(Command initialcommand, Command constrainedCommand) {
        UnexecutableCommand regionResizeCommand = UnexecutableCommand.INSTANCE;
        if (this.getHost() instanceof IDiagramElementEditPart && constrainedCommand != null) {
            CompositeTransactionalCommand ctc = new CompositeTransactionalCommand(((IDiagramElementEditPart)this.getHost()).getEditingDomain(), "Region Resize Composite Command");
            ctc.add((IUndoableOperation)new CommandProxy(initialcommand));
            ctc.add((IUndoableOperation)new CommandProxy(constrainedCommand));
            regionResizeCommand = new ICommandProxy((ICommand)ctc);
        }
        return regionResizeCommand;
    }

    private Option<AbstractDiagramElementContainerEditPart> getPrecedingRegion() {
        List<AbstractDiagramElementContainerEditPart> siblingRegions = this.getSiblingRegionPart();
        int precedingIndex = siblingRegions.indexOf(this.getHost()) - 1;
        if (precedingIndex >= 0 && siblingRegions.size() >= precedingIndex) {
            return Options.newSome((Object)siblingRegions.get(precedingIndex));
        }
        return Options.newNone();
    }

    private Option<AbstractDiagramElementContainerEditPart> getFollowingRegion() {
        List<AbstractDiagramElementContainerEditPart> siblingRegions = this.getSiblingRegionPart();
        int followingIndex = siblingRegions.indexOf(this.getHost()) + 1;
        if (followingIndex > 0 && siblingRegions.size() > followingIndex) {
            return Options.newSome((Object)siblingRegions.get(followingIndex));
        }
        return Options.newNone();
    }

    private boolean concernRegion() {
        boolean regionImpacted = false;
        EditPart hostPart = this.getHost();
        if (hostPart instanceof AbstractDiagramElementContainerEditPart) {
            IDiagramElementEditPart ideep = (IDiagramElementEditPart)hostPart;
            DDiagramElement dde = ideep.resolveDiagramElement();
            regionImpacted = dde instanceof DDiagramElementContainer && new DDiagramElementContainerExperimentalQuery((DDiagramElementContainer)dde).isRegion();
        }
        return regionImpacted;
    }

    private int getStackDirection() {
        IDiagramElementEditPart ideep;
        DDiagramElement dde;
        int direction = 0;
        EditPart hostPart = this.getHost();
        if (hostPart instanceof AbstractDiagramElementContainerEditPart && (dde = (ideep = (IDiagramElementEditPart)hostPart).resolveDiagramElement()) != null && dde.eContainer() instanceof DNodeContainer) {
            DNodeContainerExperimentalQuery query = new DNodeContainerExperimentalQuery((DNodeContainer)dde.eContainer());
            if (query.isVerticalStackContainer()) {
                direction = 5;
            } else if (query.isHorizontaltackContainer()) {
                direction = 24;
            }
        }
        return direction;
    }

    private List<AbstractDiagramElementContainerEditPart> getSiblingRegionPart() {
        EditPart parent;
        EditPart editPart = parent = this.getHost() != null ? this.getHost().getParent() : null;
        if (parent instanceof AbstractDNodeContainerCompartmentEditPart) {
            return Lists.newArrayList((Iterable)Iterables.filter((Iterable)parent.getChildren(), AbstractDiagramElementContainerEditPart.class));
        }
        return Collections.emptyList();
    }

    private boolean isFirstRegionPart() {
        List<AbstractDiagramElementContainerEditPart> regionParts = this.getSiblingRegionPart();
        return !Iterables.isEmpty(regionParts) && Iterables.getFirst(regionParts, null) == this.getHost();
    }

    private boolean isLastRegionPart() {
        List<AbstractDiagramElementContainerEditPart> regionParts = this.getSiblingRegionPart();
        return !Iterables.isEmpty(regionParts) && Iterables.getLast(regionParts, null) == this.getHost();
    }
}

