/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.refresh.listeners;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.viewpoint.ViewpointPackage;

public class RefreshEdgeLayoutNotificationFilter
extends NotificationFilter.Custom {
    private DDiagram dDiagram;

    public RefreshEdgeLayoutNotificationFilter(DDiagram dDiagram) {
        this.dDiagram = dDiagram;
    }

    public boolean matches(Notification notification) {
        if (!notification.isTouch() && notification.getNewValue() != null) {
            Object notifier = notification.getNotifier();
            return notifier instanceof EObject && this.isPartOfTheSameDiagram((EObject)notifier);
        }
        return false;
    }

    public static boolean isNotificationForRefreshEdgeLayout(Notification notification) {
        switch (notification.getEventType()) {
            case 1: 
            case 3: {
                LinkedHashSet featureToContainDDiagramElements = Sets.newLinkedHashSet();
                featureToContainDDiagramElements.add(DiagramPackage.eINSTANCE.getDEdge_OwnedStyle());
                featureToContainDDiagramElements.add(DiagramPackage.eINSTANCE.getEdgeStyle_Centered());
                featureToContainDDiagramElements.add(NotationPackage.eINSTANCE.getRoutingStyle_Routing());
                return featureToContainDDiagramElements.contains(notification.getFeature());
            }
        }
        return false;
    }

    public static boolean otherNotificationsAreIndirectlyConcerned(Notification notification, Collection<Notification> notifications) {
        if (NotationPackage.eINSTANCE.getRoutingStyle_Routing().equals(notification.getFeature()) || DiagramPackage.eINSTANCE.getEdgeStyle_Centered().equals(notification.getFeature())) {
            LinkedHashSet concernedFeature = Sets.newLinkedHashSet();
            concernedFeature.add(ViewpointPackage.eINSTANCE.getCustomizable_CustomFeatures());
            concernedFeature.add(DiagramPackage.eINSTANCE.getEdgeStyle_RoutingStyle());
            for (Notification currentNotification : notifications) {
                if (currentNotification == notification || concernedFeature.contains(currentNotification.getFeature())) continue;
                return false;
            }
            return true;
        }
        return notifications.size() == 1;
    }

    private boolean isPartOfTheSameDiagram(EObject eObject) {
        DDiagram currentDDiagram = this.getParentDDiagram(eObject);
        return currentDDiagram == this.dDiagram;
    }

    private DDiagram getParentDDiagram(EObject eObject) {
        DDiagram parent = null;
        if (eObject instanceof DDiagram) {
            parent = (DDiagram)eObject;
        } else if (eObject instanceof Diagram) {
            parent = (DDiagram)((Diagram)eObject).getElement();
        } else if (eObject != null) {
            parent = this.getParentDDiagram(eObject.eContainer());
        }
        return parent;
    }
}

