/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.tools.api.menu;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.ui.action.CreateChildAction;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.sirius.editor.tools.internal.editor.EditorCustomizationManager;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.ui.IEditorPart;

public abstract class AbstractMenuBuilder {
    private static final String EDIT = "edit";
    protected Collection advancedChildActions;
    protected Collection descriptors = new LinkedHashSet();
    protected IMenuManager myMenuManager;

    public AbstractMenuBuilder() {
        this.getMenu();
    }

    public Collection getMyDescriptors() {
        return this.descriptors;
    }

    protected Option<IMenuManager> getMenu() {
        return Options.newSome((Object)this.myMenuManager);
    }

    private void createMenuManager() {
        this.myMenuManager = new MenuManager(this.getLabel());
        this.myMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                menuManager.updateAll(true);
            }
        });
    }

    public abstract String getLabel();

    public void attach(IMenuManager parent) {
    }

    public void update(Collection newChildDescriptors, ISelection selection, IEditorPart editor) {
        this.depopulate();
        this.advancedChildActions = this.generateCreateChildActions(this.filter(newChildDescriptors), selection, editor);
    }

    private Collection filter(Collection newChildDescriptors) {
        for (Object object : newChildDescriptors) {
            if (object instanceof CommandParameter) {
                if (this.isDeprecated((CommandParameter)object) || !this.isMine((CommandParameter)object)) continue;
                this.descriptors.add(object);
                continue;
            }
            this.descriptors.add(object);
        }
        return this.descriptors;
    }

    protected abstract boolean isMine(CommandParameter var1);

    protected boolean isDeprecated(CommandParameter param) {
        return param.getEStructuralFeature() != null && this.isDeprecated((EModelElement)param.getEStructuralFeature()) || param.getValue() instanceof EObject && this.isDeprecated((EModelElement)((EObject)param.getValue()).eClass());
    }

    private boolean isDeprecated(EModelElement owner) {
        return this.isGlobalyDisabled(owner) || EditorCustomizationManager.getInstance().isHidden(owner);
    }

    private boolean isGlobalyDisabled(EModelElement owner) {
        return owner == DescriptionPackage.eINSTANCE.getRepresentationTemplate_OwnedRepresentations();
    }

    protected void depopulate() {
        this.descriptors = new LinkedHashSet();
        if (this.myMenuManager != null) {
            this.depopulateManager((IContributionManager)this.myMenuManager, this.advancedChildActions);
        }
    }

    protected void depopulateManager(IContributionManager manager, Collection actions) {
        if (actions != null) {
            IContributionItem[] items;
            IContributionItem[] iContributionItemArray = items = manager.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                IAction action;
                IContributionItem item;
                IContributionItem contributionItem = item = iContributionItemArray[n2];
                while (contributionItem instanceof SubContributionItem) {
                    contributionItem = ((SubContributionItem)contributionItem).getInnerItem();
                }
                if (contributionItem instanceof ActionContributionItem && actions.contains(action = ((ActionContributionItem)contributionItem).getAction())) {
                    manager.remove(contributionItem);
                }
                ++n2;
            }
        }
    }

    protected Collection generateCreateChildActions(Collection actionDescriptors, ISelection selection, IEditorPart editor) {
        ArrayList<CreateChildAction> actions = new ArrayList<CreateChildAction>();
        if (actionDescriptors != null) {
            for (Object actionDescriptor : actionDescriptors) {
                actions.add(new CreateChildAction(editor, selection, actionDescriptor));
            }
        }
        return actions;
    }

    public void populateMenu() {
        if (this.getMenu().some()) {
            this.populateManager((IContributionManager)this.getMenu().get(), this.advancedChildActions, null);
        }
    }

    public void depopulateMenu() {
        if (this.getMenu().some()) {
            this.depopulateManager((IContributionManager)this.getMenu().get(), this.advancedChildActions);
        }
    }

    protected void populateManager(IContributionManager manager, Collection actions, String contributionID) {
        if (actions != null) {
            ArrayList sortedActions = Lists.newArrayList((Iterable)Iterables.filter((Iterable)actions, IAction.class));
            Comparator<IAction> comparator = new Comparator<IAction>(){

                @Override
                public int compare(IAction a1, IAction a2) {
                    return Collator.getInstance().compare(a1.getText(), a2.getText());
                }
            };
            Collections.sort(sortedActions, comparator);
            for (IAction action : sortedActions) {
                if (contributionID != null) {
                    manager.insertBefore(contributionID, action);
                    continue;
                }
                manager.add(action);
            }
        }
        manager.update(true);
    }

    public void insertBeforeInContainer(IMenuManager parent) {
        this.createMenuManager();
        this.populateMenu();
        parent.insertBefore(EDIT, (IContributionItem)this.myMenuManager);
    }

    public void insertAfterInContainer(IMenuManager parent) {
        this.createMenuManager();
        this.populateMenu();
        parent.insertAfter(EDIT, (IContributionItem)this.myMenuManager);
    }
}

