/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ext.gmf.runtime.editparts;

import com.google.common.base.Preconditions;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.FreeformViewport;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.BaseSlidableAnchor;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.ext.draw2d.figure.FigureUtilities;

public final class GraphicalHelper {
    private GraphicalHelper() {
    }

    public static double getZoom(EditPart part) {
        Preconditions.checkNotNull((Object)part);
        double scale = 1.0;
        if (part.getRoot() instanceof DiagramRootEditPart) {
            DiagramRootEditPart rootEditPart = (DiagramRootEditPart)part.getRoot();
            scale = rootEditPart.getZoomManager().getZoom();
        }
        return scale;
    }

    @Deprecated
    public static void appliedZoomOnRelativePoint(IGraphicalEditPart part, Point relativePoint) {
        double zoom = GraphicalHelper.getZoom((EditPart)part);
        if (relativePoint instanceof PrecisionPoint) {
            ((PrecisionPoint)relativePoint).setPreciseLocation(relativePoint.preciseX() / zoom, relativePoint.preciseY() / zoom);
        } else {
            relativePoint.setLocation((int)((double)relativePoint.x * zoom), (int)((double)relativePoint.y * zoom));
        }
    }

    public static Point applyZoomOnPoint(IGraphicalEditPart part, Point point) {
        double zoom = GraphicalHelper.getZoom((EditPart)part);
        if (point instanceof PrecisionPoint) {
            ((PrecisionPoint)point).setPreciseLocation(point.preciseX() * zoom, point.preciseY() * zoom);
        } else {
            point.setLocation((int)((double)point.x * zoom), (int)((double)point.y * zoom));
        }
        return point;
    }

    public static Point applyInverseZoomOnPoint(IGraphicalEditPart part, Point point) {
        double zoom = GraphicalHelper.getZoom((EditPart)part);
        if (point instanceof PrecisionPoint) {
            ((PrecisionPoint)point).setPreciseLocation(point.preciseX() / zoom, point.preciseY() / zoom);
        } else {
            point.setLocation((int)((double)point.x / zoom), (int)((double)point.y / zoom));
        }
        return point;
    }

    public static void setZoom(IGraphicalEditPart part, double scale) {
        Preconditions.checkNotNull((Object)part);
        if (part.getRoot() instanceof DiagramRootEditPart) {
            DiagramRootEditPart rootEditPart = (DiagramRootEditPart)part.getRoot();
            rootEditPart.getZoomManager().setZoom(scale);
        }
    }

    public static Point getScrollSize(GraphicalEditPart part) {
        Preconditions.checkNotNull((Object)part);
        FreeformViewport viewport = FigureUtilities.getRootFreeformViewport((IFigure)part.getFigure());
        if (viewport != null) {
            return viewport.getViewLocation();
        }
        return new Point(0, 0);
    }

    public static void setScrollSize(IGraphicalEditPart part, Point scrollPosition) {
        Preconditions.checkNotNull((Object)part);
        if (part.getViewer().getControl() instanceof FigureCanvas) {
            ((FigureCanvas)part.getViewer().getControl()).scrollTo(scrollPosition.x, scrollPosition.y);
        }
    }

    public static void screen2logical(Point point, IGraphicalEditPart part) {
        point.translate(GraphicalHelper.getScrollSize((GraphicalEditPart)part));
        point.performScale(1.0 / GraphicalHelper.getZoom((EditPart)part));
    }

    public static void screen2logical(Rectangle rect, GraphicalEditPart part) {
        rect.translate(GraphicalHelper.getScrollSize(part));
        rect.performScale(1.0 / GraphicalHelper.getZoom((EditPart)part));
    }

    public static void screen2logical(Dimension dim, IGraphicalEditPart part) {
        dim.performScale(1.0 / GraphicalHelper.getZoom((EditPart)part));
    }

    public static void logical2screen(Point point, IGraphicalEditPart part) {
        point.performScale(GraphicalHelper.getZoom((EditPart)part));
        point.translate(GraphicalHelper.getScrollSize((GraphicalEditPart)part).negate());
    }

    public static void logical2screen(Rectangle rect, IGraphicalEditPart part) {
        rect.performScale(GraphicalHelper.getZoom((EditPart)part));
        rect.translate(GraphicalHelper.getScrollSize((GraphicalEditPart)part).negate());
    }

    public static void logical2Screen(Dimension dim, IGraphicalEditPart part) {
        dim.performScale(GraphicalHelper.getZoom((EditPart)part));
    }

    public static Point getAnchorPoint(IGraphicalEditPart parent, Anchor anchor) {
        if (anchor instanceof IdentityAnchor) {
            return GraphicalHelper.getAnchorPoint(parent, (IdentityAnchor)anchor);
        }
        return GraphicalHelper.getAnchorPoint(parent, null);
    }

    public static Point getAnchorPoint(IGraphicalEditPart parent, IdentityAnchor anchor) {
        Rectangle bounds = parent.getFigure() instanceof HandleBounds ? ((HandleBounds)parent.getFigure()).getHandleBounds() : parent.getFigure().getBounds();
        parent.getFigure().translateToAbsolute((Translatable)bounds);
        PrecisionPoint rel = anchor != null ? BaseSlidableAnchor.parseTerminalString((String)anchor.getId()) : new PrecisionPoint(0.5, 0.5);
        PrecisionPoint location = new PrecisionPoint((double)bounds.getLocation().x + (double)bounds.width * rel.preciseX(), (double)bounds.getLocation().y + (double)bounds.height * rel.preciseY());
        return location;
    }

    public static Option<Point> getIntersection(Point lineOrigin, Point lineTerminus, IGraphicalEditPart part, boolean minimalDistancefromLineOrigin) {
        Rectangle bounds = GraphicalHelper.getAbsoluteBoundsIn100Percent((GraphicalEditPart)part);
        return GraphicalHelper.getIntersection(lineOrigin, lineTerminus, bounds, minimalDistancefromLineOrigin);
    }

    public static Option<Point> getIntersection(Point lineOrigin, Point lineTerminus, Rectangle rectangle, boolean minimalDistancefromLineOrigin) {
        PointList line = new PointList();
        line.addPoint(lineOrigin);
        line.addPoint(lineTerminus);
        PointList partBoundsPointList = PointListUtilities.createPointsFromRect((Rectangle)rectangle);
        PointList distances = new PointList();
        PointList intersections = new PointList();
        PointListUtilities.findIntersections((PointList)line, (PointList)partBoundsPointList, (PointList)intersections, (PointList)distances);
        if (intersections.size() > 0) {
            Point referencePoint = minimalDistancefromLineOrigin ? lineOrigin : lineTerminus;
            Point shortestPoint = intersections.getFirstPoint();
            double minimalDistance = shortestPoint.getDistance(referencePoint);
            int i = 1;
            while (i < intersections.size()) {
                Point intersectionPoint = intersections.getPoint(i);
                double currentDistance = intersectionPoint.getDistance(referencePoint);
                if (currentDistance < minimalDistance) {
                    minimalDistance = currentDistance;
                    shortestPoint = intersectionPoint;
                }
                ++i;
            }
            return Options.newSome((Object)shortestPoint);
        }
        return Options.newNone();
    }

    public static PointList getIntersectionPoints(Point start, Point end, Rectangle figureBounds) {
        PointList intersection = new PointList();
        PointList polygon = PointListUtilities.createPointsFromRect((Rectangle)figureBounds);
        LineSeg lineSeg = new LineSeg(start, end);
        PointList intersectionTemp = lineSeg.getLineIntersectionsWithLineSegs(polygon);
        int i = 0;
        while (i < intersectionTemp.size()) {
            Point currentPoint = intersectionTemp.getPoint(i);
            if (lineSeg.containsPoint(currentPoint, 1)) {
                intersection.addPoint(currentPoint);
            }
            ++i;
        }
        return intersection;
    }

    public static Rectangle getAbsoluteBounds(IGraphicalEditPart part) {
        Rectangle bounds = part.getFigure() instanceof HandleBounds ? ((HandleBounds)part.getFigure()).getHandleBounds().getCopy() : part.getFigure().getBounds().getCopy();
        part.getFigure().translateToAbsolute((Translatable)bounds);
        return bounds;
    }

    public static Rectangle getAbsoluteBoundsIn100Percent(GraphicalEditPart part) {
        Rectangle bounds = part.getFigure() instanceof HandleBounds ? ((HandleBounds)part.getFigure()).getHandleBounds().getCopy() : part.getFigure().getBounds().getCopy();
        part.getFigure().translateToAbsolute((Translatable)bounds);
        GraphicalHelper.screen2logical(bounds, part);
        return bounds;
    }

    public static boolean isSnapToGridEnabled(EditPart editPart) {
        return (Boolean)editPart.getViewer().getProperty("SnapToGrid.isEnabled");
    }
}

