/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.editor.provider;

import java.util.Map;
import java.util.Set;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.ui.tools.internal.editor.DTableTreeViewer;
import org.eclipse.sirius.table.ui.tools.internal.editor.DTableViewerManager;
import org.eclipse.sirius.table.ui.tools.internal.editor.provider.DTableColumnHeaderLabelProvider;
import org.eclipse.sirius.table.ui.tools.internal.editor.provider.DTableColumnLabelProvider;
import org.eclipse.sirius.table.ui.tools.internal.editor.provider.DTableEditorUtil;
import org.eclipse.sirius.ui.tools.internal.util.ItemSearcher;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;

public class TableUIUpdaterRunnable
implements Runnable {
    private DTableViewerManager dTableViewerManager;
    private DTableTreeViewer dTableTreeViewer;
    private Set<DLine> toExpands;
    private Set<DLine> toCollapses;
    private Set<Object> toRefreshInViewerWithUpdateLabels;
    private boolean launchGlobalRefreshWithoutUpdateLabels;
    private boolean launchGlobalRefreshWithUpdateLabels;
    private Object[] objectsToUpdateInViewer;
    private Set<DColumn> dColumnsToUpdateDirectly;
    private Set<DColumn> dColumnsWidthToUpdate;
    private Set<DColumn> dColumnsToRemove;
    private Map<DColumn, Integer> dColumnsToAdd;
    private Map<DColumn, Boolean> dColumnsToVisibilityChanged;
    private boolean updateHeaderColumnWidth;

    public TableUIUpdaterRunnable(DTableViewerManager dTableViewerManager, DTableTreeViewer dTableTreeViewer, Set<DLine> toExpands, Set<DLine> toCollapses, Set<Object> toRefreshInViewerWithUpdateLabels, boolean launchGlobalRefreshWithoutUpdateLabels, boolean launchGlobalRefreshWithUpdateLabels, Object[] objectsToUpdateInViewer, Set<DColumn> dColumnsToUpdateDirectly, Set<DColumn> dColumnsWidthToUpdate, Set<DColumn> dColumnsToRemove, Map<DColumn, Integer> dColumnsToAdd, Map<DColumn, Boolean> dColumnsToVisibilityChanged, boolean updateHeaderColumnWidth) {
        this.dTableTreeViewer = dTableTreeViewer;
        this.dTableViewerManager = dTableViewerManager;
        this.toRefreshInViewerWithUpdateLabels = toRefreshInViewerWithUpdateLabels;
        this.objectsToUpdateInViewer = objectsToUpdateInViewer;
        this.toExpands = toExpands;
        this.toCollapses = toCollapses;
        this.dColumnsToRemove = dColumnsToRemove;
        this.dColumnsToAdd = dColumnsToAdd;
        this.launchGlobalRefreshWithoutUpdateLabels = launchGlobalRefreshWithoutUpdateLabels;
        this.launchGlobalRefreshWithUpdateLabels = launchGlobalRefreshWithUpdateLabels;
        this.dColumnsWidthToUpdate = dColumnsWidthToUpdate;
        this.updateHeaderColumnWidth = updateHeaderColumnWidth;
        this.dColumnsToVisibilityChanged = dColumnsToVisibilityChanged;
        this.dColumnsToUpdateDirectly = dColumnsToUpdateDirectly;
    }

    @Override
    public void run() {
        if (this.dTableTreeViewer != null && this.dTableTreeViewer.getControl() != null && !this.dTableTreeViewer.getControl().isDisposed()) {
            this.expand();
            this.collapse();
            this.refresh();
            DslCommonPlugin.PROFILER.startWork("Update a line of the SWT table");
            this.dTableTreeViewer.update(this.objectsToUpdateInViewer, null);
            DslCommonPlugin.PROFILER.stopWork("Update a line of the SWT table");
            this.removeColumns();
            this.addColumns();
            if (this.launchGlobalRefreshWithoutUpdateLabels || this.launchGlobalRefreshWithUpdateLabels) {
                DslCommonPlugin.PROFILER.startWork("Refresh a table");
                this.dTableTreeViewer.refresh(this.launchGlobalRefreshWithUpdateLabels);
                DslCommonPlugin.PROFILER.stopWork("Refresh a table");
            }
            if (this.updateHeaderColumnWidth) {
                DTable dTable = (DTable)this.dTableTreeViewer.getInput();
                Tree tree = this.dTableTreeViewer.getTree();
                TreeColumn headerTreeColumn = tree.getColumn(0);
                if (headerTreeColumn.getWidth() != dTable.getHeaderColumnWidth()) {
                    headerTreeColumn.setWidth(dTable.getHeaderColumnWidth());
                }
            }
            this.updateColumns();
            this.updateColumnVisibility();
        }
    }

    private void expand() {
        for (DLine itemtoExpand : this.toExpands) {
            DslCommonPlugin.PROFILER.startWork("Change the collapse state of a line of the SWT table");
            this.dTableTreeViewer.setExpandedState(itemtoExpand, true);
            DslCommonPlugin.PROFILER.stopWork("Change the collapse state of a line of the SWT table");
        }
    }

    private void collapse() {
        for (DLine itemToCollapse : this.toCollapses) {
            DslCommonPlugin.PROFILER.startWork("Change the collapse state of a line of the SWT table");
            this.dTableTreeViewer.setExpandedState(itemToCollapse, false);
            DslCommonPlugin.PROFILER.stopWork("Change the collapse state of a line of the SWT table");
        }
    }

    private void refresh() {
        for (Object itemToRefresh : this.toRefreshInViewerWithUpdateLabels) {
            DslCommonPlugin.PROFILER.startWork("Refresh the SWT table");
            this.dTableTreeViewer.refresh(itemToRefresh, true);
            DslCommonPlugin.PROFILER.stopWork("Refresh the SWT table");
        }
    }

    private void removeColumns() {
        for (DColumn dColumn : this.dColumnsToRemove) {
            this.dTableViewerManager.removeOldColumn(dColumn);
        }
    }

    private void addColumns() {
        for (Map.Entry<DColumn, Integer> entry : this.dColumnsToAdd.entrySet()) {
            DColumn newColumn = entry.getKey();
            Integer position = entry.getValue();
            DTableEditorUtil.addNewColumn(this.dTableViewerManager, position, newColumn);
        }
        if (!this.dColumnsToAdd.isEmpty()) {
            this.dTableTreeViewer.refresh();
        }
    }

    private void updateColumns() {
        for (DColumn dColumnToUpdateDirectly : this.dColumnsToUpdateDirectly) {
            int i = 0;
            while (i < this.dTableTreeViewer.getTree().getColumns().length) {
                CellLabelProvider labelProvider = this.dTableTreeViewer.getLabelProvider(i);
                if (labelProvider instanceof DTableColumnLabelProvider && ((DTableColumnLabelProvider)labelProvider).isProvideColumn(dColumnToUpdateDirectly)) {
                    DslCommonPlugin.PROFILER.startWork("Set the column name in the SWT table");
                    TreeColumn treeColumn = this.dTableTreeViewer.getTree().getColumn(i);
                    DTableColumnHeaderLabelProvider dTableColumnHeaderLabelProvider = new DTableColumnHeaderLabelProvider();
                    String text = dTableColumnHeaderLabelProvider.getText(dColumnToUpdateDirectly);
                    treeColumn.setText(text);
                    Image image = dTableColumnHeaderLabelProvider.getImage(dColumnToUpdateDirectly);
                    treeColumn.setImage(image);
                    DslCommonPlugin.PROFILER.stopWork("Set the column name in the SWT table");
                }
                ++i;
            }
        }
        if (this.dTableViewerManager.getEditor().isPropertiesUpdateEnabled()) {
            for (DColumn dColumn : this.dColumnsWidthToUpdate) {
                TreeColumn treeColumn;
                Tree tree = this.dTableTreeViewer.getTree();
                ItemSearcher itemSearcher = new ItemSearcher(tree, (DRepresentationElement)dColumn);
                itemSearcher.run();
                Object result = itemSearcher.getResult();
                if (!(result instanceof TreeColumn) || (treeColumn = (TreeColumn)result).getWidth() == dColumn.getWidth()) continue;
                treeColumn.setWidth(dColumn.getWidth());
                ((TreeColumnLayout)treeColumn.getParent().getParent().getLayout()).setColumnData((Widget)treeColumn, (ColumnLayoutData)new ColumnPixelData(dColumn.getWidth()));
            }
        }
    }

    private void updateColumnVisibility() {
        for (Map.Entry<DColumn, Boolean> entry : this.dColumnsToVisibilityChanged.entrySet()) {
            DColumn dColumn = entry.getKey();
            Boolean visible = entry.getValue();
            int i = 0;
            while (i < this.dTableTreeViewer.getTree().getColumns().length) {
                CellLabelProvider labelProvider = this.dTableTreeViewer.getLabelProvider(i);
                if (labelProvider instanceof DTableColumnLabelProvider && ((DTableColumnLabelProvider)labelProvider).isProvideColumn(dColumn)) {
                    DslCommonPlugin.PROFILER.startWork("Change the visible state of a column of the SWT table");
                    TreeColumn treeColumn = this.dTableTreeViewer.getTree().getColumn(i);
                    this.handleColumn(treeColumn, visible);
                    DslCommonPlugin.PROFILER.stopWork("Change the visible state of a column of the SWT table");
                }
                ++i;
            }
        }
    }

    private void handleColumn(TreeColumn treeColumn, boolean visible) {
        if (visible) {
            Integer restoredWith = (Integer)treeColumn.getData("restoredWidth");
            if (restoredWith != null) {
                treeColumn.setWidth(restoredWith.intValue());
                ((TreeColumnLayout)treeColumn.getParent().getParent().getLayout()).setColumnData((Widget)treeColumn, (ColumnLayoutData)new ColumnPixelData(restoredWith.intValue()));
            } else {
                treeColumn.pack();
                ((TreeColumnLayout)treeColumn.getParent().getParent().getLayout()).setColumnData((Widget)treeColumn, (ColumnLayoutData)new ColumnPixelData(treeColumn.getWidth()));
            }
        } else {
            treeColumn.setData("restoredWidth", (Object)treeColumn.getWidth());
            treeColumn.setWidth(0);
            ((TreeColumnLayout)treeColumn.getParent().getParent().getLayout()).setColumnData((Widget)treeColumn, (ColumnLayoutData)new ColumnPixelData(0));
        }
    }
}

