/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.business.internal.refresh;

import com.google.common.base.Objects;
import org.eclipse.sirius.table.business.internal.refresh.KeyCache;
import org.eclipse.sirius.table.metamodel.table.DFeatureColumn;
import org.eclipse.sirius.table.metamodel.table.description.ColumnMapping;

public class DFeatureColumnCandidate {
    private final String featureName;
    private final ColumnMapping mapping;
    private DFeatureColumn element;
    private final int hashCode;

    public DFeatureColumnCandidate(ColumnMapping mapping, String featureName) {
        this.mapping = mapping;
        this.featureName = featureName;
        this.hashCode = this.computeHashCode();
    }

    public DFeatureColumnCandidate(DFeatureColumn tableElement) {
        this.mapping = tableElement.getOriginMapping();
        this.featureName = tableElement.getFeatureName();
        this.element = tableElement;
        this.hashCode = this.computeHashCode();
    }

    public boolean comesFromTableElement() {
        return this.getOriginalElement() != null;
    }

    public DFeatureColumn getOriginalElement() {
        return this.element;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        return KeyCache.DEFAULT.getKey(String.valueOf(this.mapping == null || this.mapping.getName() == null ? "" : this.mapping.getName()) + (String)Objects.firstNonNull((Object)this.featureName, (Object)""));
    }

    public boolean equals(Object obj) {
        Boolean result = null;
        if (this == obj) {
            result = true;
        }
        if (result == null && obj == null) {
            result = false;
        }
        if (result == null && !(obj instanceof DFeatureColumnCandidate)) {
            result = false;
        }
        DFeatureColumnCandidate other = (DFeatureColumnCandidate)obj;
        if (result == null && this.mapping == null) {
            if (other.mapping != null) {
                result = false;
            }
        } else if (result == null && !this.mapping.getName().equals(other.mapping.getName())) {
            result = false;
        }
        if (result == null && this.featureName == null) {
            if (other.featureName != null) {
                result = false;
            }
        } else if (result == null && !this.featureName.equals(other.featureName)) {
            result = false;
        }
        if (result == null) {
            result = true;
        }
        return result;
    }

    public ColumnMapping getMapping() {
        return this.mapping;
    }

    public String getFeatureName() {
        return this.featureName;
    }
}

