/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.support.internal.helper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import org.eclipse.core.filebuffers.manipulation.ContainerCreator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.sirius.common.tools.api.resource.FileProvider;
import org.eclipse.sirius.tests.support.api.EclipseTestsSupportHelper;
import org.eclipse.sirius.ui.tools.api.project.ModelingProjectManager;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public final class EclipseTestsSupportHelperImpl
implements EclipseTestsSupportHelper {
    public static final EclipseTestsSupportHelper INSTANCE = new EclipseTestsSupportHelperImpl();

    private EclipseTestsSupportHelperImpl() {
    }

    @Override
    public Resource createResourceInProject(ResourceSet set, String projectName, String fileName) {
        return set.createResource(URI.createPlatformResourceURI((String)("/" + projectName + "/" + fileName), (boolean)true));
    }

    @Override
    public IProject createModelingProject(String projectName, boolean createAndOpenBlankRepresentationsFile) {
        try {
            return ModelingProjectManager.INSTANCE.createNewModelingProject(projectName, null, createAndOpenBlankRepresentationsFile, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public IProject createProject(String projectName) {
        IProjectDescription projectDescription = ResourcesPlugin.getWorkspace().newProjectDescription(projectName);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        try {
            if (!project.exists()) {
                project.create(projectDescription, (IProgressMonitor)new NullProgressMonitor());
            }
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        return project;
    }

    @Override
    public void deleteProject(String projectName) {
        final IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                if (project.exists()) {
                    project.delete(true, (IProgressMonitor)new NullProgressMonitor());
                }
            }
        };
        try {
            operation.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void deleteFile(String workspaceRelativePath) {
        final IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(workspaceRelativePath));
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                if (file.exists()) {
                    file.delete(true, (IProgressMonitor)new NullProgressMonitor());
                }
            }
        };
        try {
            operation.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void copyFile(String relativePath, String destinationWorkspaceRelativePath) {
        if (relativePath == null) {
            throw new IllegalArgumentException("relativePath cannot be null");
        }
        if (destinationWorkspaceRelativePath == null) {
            throw new IllegalArgumentException("destination WorkspaceRelativePath cannot be null");
        }
        File sourceFile = FileProvider.getDefault().getFile((IPath)new Path(relativePath));
        IFile destinationFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(destinationWorkspaceRelativePath));
        if (sourceFile == null) {
            throw new IllegalArgumentException("sourceFile cannot be null: check the source path: " + relativePath);
        }
        if (destinationFile == null) {
            throw new IllegalArgumentException("destinationFile cannot be null: check the workspace relative destination path: " + destinationWorkspaceRelativePath);
        }
        this.copyFile(sourceFile, destinationFile, true);
    }

    @Override
    public void copyFile(String bundleID, String projectRelativePath, String destinationWorkspaceRelativePath, boolean refreshAfterCopy) {
        if (bundleID == null) {
            throw new IllegalArgumentException("bundleID cannot be null");
        }
        if (projectRelativePath == null) {
            throw new IllegalArgumentException("projectRelativePath cannot be null");
        }
        if (destinationWorkspaceRelativePath == null) {
            throw new IllegalArgumentException("destinationWorkspaceRelativePath cannot be null");
        }
        File sourceFile = FileProvider.getDefault().getFile(bundleID, (IPath)new Path(projectRelativePath));
        IFile destinationFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(destinationWorkspaceRelativePath));
        if (sourceFile == null) {
            throw new IllegalArgumentException("sourceFile cannot be null: check the project relative source path: " + projectRelativePath + " in " + bundleID);
        }
        if (destinationFile == null) {
            throw new IllegalArgumentException("destinationFile cannot be null: check the workspace relative destination path: " + destinationWorkspaceRelativePath);
        }
        this.copyFile(sourceFile, destinationFile, refreshAfterCopy);
    }

    @Override
    public void copyFile(String bundleID, String projectRelativePath, String destinationWorkspaceRelativePath) {
        this.copyFile(bundleID, projectRelativePath, destinationWorkspaceRelativePath, true);
    }

    private void copyFile(File sourceFile, IFile destinationFile, boolean refreshAfterCopy) {
        StringBuffer errorMessage = new StringBuffer();
        try {
            new ContainerCreator(ResourcesPlugin.getWorkspace(), destinationFile.getParent().getFullPath()).createContainer((IProgressMonitor)new NullProgressMonitor());
            this.copyFile(sourceFile, new File(destinationFile.getLocation().toOSString()));
            if (refreshAfterCopy) {
                destinationFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            errorMessage.append(e.getMessage());
        }
        catch (IOException e) {
            errorMessage.append(e.getMessage());
        }
        if (!destinationFile.exists() && refreshAfterCopy) {
            throw new RuntimeException("Problem during the copy of the file : " + errorMessage);
        }
    }

    @Override
    public void copyFile(File sourceFile, File destFile) throws IOException {
        if (sourceFile == null) {
            throw new IllegalArgumentException("sourceFile cannot be null");
        }
        if (destFile == null) {
            throw new IllegalArgumentException("destFile cannot be null");
        }
        if (!sourceFile.exists()) {
            throw new IllegalArgumentException("File '" + sourceFile + "' to copy does not exists");
        }
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    @Override
    public void changeFileReadOnlyAttribute(String destinationWorkspaceRelativePath, boolean readOnly) {
        if (destinationWorkspaceRelativePath == null) {
            throw new IllegalArgumentException("destinationWorkspaceRelativePath cannot be null");
        }
        IFile destinationFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(destinationWorkspaceRelativePath));
        destinationFile.getLocation().toFile().setReadOnly();
    }
}

