/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.swtbot.support.utils;

import java.util.concurrent.TimeUnit;
import org.eclipse.sirius.tests.swtbot.support.utils.SiriusContextMenuFinder;
import org.eclipse.sirius.tests.swtbot.support.utils.menu.SWTBotContextMenu;
import org.eclipse.sirius.viewpoint.FontFormat;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.matchers.WidgetMatcherFactory;
import org.eclipse.swtbot.swt.finder.results.BoolResult;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.results.WidgetResult;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.swtbot.swt.finder.widgets.TimeoutException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class SWTBotUtils {
    public static final long CLOSE_PROGRESS_MONITOR_TIMEOUT = TimeUnit.SECONDS.toSeconds(60L);
    private static SWTWorkbenchBot bot = new SWTWorkbenchBot();

    private SWTBotUtils() {
    }

    public static void directEditWithKeyboard(Widget widget, String text) {
        char[] charArray = text.toCharArray();
        if (charArray.length > 0) {
            char[] cArray = charArray;
            int n = charArray.length;
            int n2 = 0;
            while (n2 < n) {
                char element = cArray[n2];
                SWTBotUtils.pressKeyboardKey(widget, element);
                ++n2;
            }
        }
    }

    public static void pressKeyboardKey(final Widget widget, final char key) {
        UIThreadRunnable.asyncExec((VoidResult)new VoidResult(){

            public void run() {
                widget.notifyListeners(1, SWTBotUtils.keyEvent(0, key, key, widget));
                widget.notifyListeners(2, SWTBotUtils.keyEvent(0, key, key, widget));
            }
        });
    }

    public static void pressEnterKey(final Widget widget) {
        UIThreadRunnable.asyncExec((VoidResult)new VoidResult(){

            public void run() {
                widget.notifyListeners(31, SWTBotUtils.keyEvent(0, '\r', 13, widget));
            }
        });
    }

    private static Event keyEvent(int modificationKey, char c, int keyCode, Widget widget) {
        Event keyEvent = SWTBotUtils.createEvent(widget);
        keyEvent.stateMask = modificationKey;
        keyEvent.character = c;
        keyEvent.keyCode = keyCode;
        return keyEvent;
    }

    private static Event createEvent(Widget widget) {
        Event event = new Event();
        event.time = (int)System.currentTimeMillis();
        event.widget = widget;
        event.display = bot.getDisplay();
        return event;
    }

    public static void clickContextMenu(final SWTBotTreeItem treeItem, final String text) {
        UIThreadRunnable.asyncExec((VoidResult)new VoidResult(){

            public void run() {
                SWTBotContextMenu menu = new SWTBotContextMenu(treeItem);
                menu.click(text);
            }
        });
    }

    public static boolean hasContextMenu(final SWTBotTreeItem treeItem, final String text) {
        return (Boolean)UIThreadRunnable.syncExec((Display)treeItem.display, (Result)new BoolResult(){

            public Boolean run() {
                SWTBotContextMenu swtBotContextMenu = new SWTBotContextMenu(treeItem);
                return swtBotContextMenu.exist(text);
            }
        });
    }

    public static boolean isContextMenuEnabled(final SWTBotTreeItem treeItem, String text) {
        Matcher withMnemonic = WidgetMatcherFactory.withMnemonic((String)text);
        final Matcher matcher = Matchers.allOf((Matcher)WidgetMatcherFactory.widgetOfType(MenuItem.class), (Matcher)withMnemonic);
        return (Boolean)UIThreadRunnable.syncExec((Result)new BoolResult(){

            public Boolean run() {
                return new SiriusContextMenuFinder((Control)((TreeItem)treeItem.widget).getParent()).findMenuEnablement((Matcher<MenuItem>)matcher);
            }
        });
    }

    public static void clickContextMenu(final SWTBotTree tree, final String text) {
        UIThreadRunnable.asyncExec((VoidResult)new VoidResult(){

            public void run() {
                SWTBotContextMenu menu = new SWTBotContextMenu(tree);
                menu.click(text);
            }
        });
    }

    public static void waitAllUiEvents() {
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
            }
        });
    }

    public static void waitProgressMonitorClose(String dialogTaskLabel) throws TimeoutException {
        SWTBotUtils.waitProgressMonitorClose("Progress Information", dialogTaskLabel, CLOSE_PROGRESS_MONITOR_TIMEOUT, TimeUnit.SECONDS);
    }

    public static void waitProgressMonitorClose(String dialogTitle, String dialogTaskLabel, long timeout, TimeUnit unit) throws TimeoutException {
        SWTBotUtils.waitProgressMonitorClose(dialogTitle, dialogTaskLabel, timeout, unit, true);
    }

    public static void waitProgressMonitorClose(final String dialogTitle, String dialogTaskLabel, long timeout, TimeUnit unit, final boolean wholeTitle) throws TimeoutException {
        bot.sleep(800L);
        final Shell[] shells = bot.getFinder().getShells();
        Shell progressShell = (Shell)UIThreadRunnable.syncExec((Display)bot.getDisplay(), (Result)new WidgetResult<Shell>(){

            public Shell run() {
                Shell[] shellArray = shells;
                int n = shells.length;
                int n2 = 0;
                while (n2 < n) {
                    Shell shell = shellArray[n2];
                    if (!shell.isDisposed() && (wholeTitle && shell.getText().equalsIgnoreCase(dialogTitle) || !wholeTitle && shell.getText().contains(dialogTitle))) {
                        return shell;
                    }
                    ++n2;
                }
                return null;
            }
        });
        if (progressShell != null) {
            long begin = System.currentTimeMillis();
            boolean noTimeOut = true;
            while (noTimeOut && SWTBotUtils.isShellNotClosed(progressShell)) {
                long now = System.currentTimeMillis();
                if (now - begin > unit.toMillis(timeout)) {
                    noTimeOut = false;
                    continue;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!noTimeOut) {
                SWTBotUtils.waitAllUiEvents();
                if (SWTBotUtils.isShellNotClosed(progressShell)) {
                    throw new TimeoutException("'" + dialogTaskLabel + "' progress monitor dialog did not close in " + unit.toSeconds(CLOSE_PROGRESS_MONITOR_TIMEOUT) + "s");
                }
            }
        }
    }

    private static boolean isShellNotClosed(final Shell progressShell) {
        return (Boolean)UIThreadRunnable.syncExec((Display)bot.getDisplay(), (Result)new BoolResult(){

            public Boolean run() {
                return !progressShell.isDisposed();
            }
        });
    }

    public static FontFormat getWidgetFormat(final TreeItem widget) {
        return (FontFormat)UIThreadRunnable.syncExec((Result)new Result<FontFormat>(){

            public FontFormat run() {
                FontFormat result = FontFormat.NORMAL_LITERAL;
                Font font = widget.getFont(0);
                if (font.getFontData().length > 0) {
                    switch (font.getFontData()[0].getStyle()) {
                        case 1: {
                            result = FontFormat.BOLD_LITERAL;
                            break;
                        }
                        case 2: {
                            result = FontFormat.ITALIC_LITERAL;
                            break;
                        }
                        case 3: {
                            result = FontFormat.BOLD_ITALIC_LITERAL;
                            break;
                        }
                        default: {
                            result = FontFormat.NORMAL_LITERAL;
                        }
                    }
                }
                return result;
            }
        });
    }

    public static void clickOnTreeColumn(final SWTBotTree tree, final int columnIndex) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                TreeColumn column = ((Tree)tree.widget).getColumn(columnIndex);
                new SWTBotTreeColumn(column).clickOnColumn();
            }
        });
    }

    public static final class SWTBotTreeColumn
    extends AbstractSWTBot<TreeColumn> {
        public SWTBotTreeColumn(TreeColumn w) throws WidgetNotFoundException {
            super((Widget)w);
        }

        public void clickOnColumn() {
            this.notify(13);
            this.notify(4, this.createMouseEvent(0, 0, 1, 524288, 1), (Widget)((TreeColumn)this.widget).getParent());
        }
    }
}

