/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.views.common;

import com.google.common.collect.Iterables;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.common.ui.tools.api.view.common.item.ItemDecorator;
import org.eclipse.sirius.ui.tools.api.views.common.item.ItemWrapper;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class SessionLabelProvider
extends AdapterFactoryLabelProvider {
    public SessionLabelProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public String getText(Object object) {
        String text = null;
        if (object instanceof ItemDecorator) {
            text = ((ItemDecorator)object).getText();
        } else {
            Object item = object;
            if (object instanceof ItemWrapper) {
                item = ((ItemWrapper)object).getWrappedObject();
            }
            if (item instanceof Resource && this.safeResource((Resource)item)) {
                Resource res = (Resource)item;
                if (res.getURI() != null && res.getURI().lastSegment() != null) {
                    return String.valueOf(URI.decode((String)res.getURI().lastSegment())) + " - [" + URI.decode((String)res.getURI().toString()) + "]";
                }
            } else {
                try {
                    text = super.getText(item);
                }
                catch (IllegalStateException illegalStateException) {
                    SiriusEditPlugin.getPlugin().getLog().log((IStatus)new Status(2, "org.eclipse.sirius", "Error while reading to the model"));
                }
            }
        }
        return text;
    }

    private boolean safeResource(Resource res) {
        boolean safe = false;
        if (res.getResourceSet() != null) {
            safe = true;
        } else {
            for (EObject obj : Iterables.filter((Iterable)EPackage.Registry.INSTANCE.values(), EObject.class)) {
                if (!obj.eResource().equals(res)) continue;
                safe = true;
                break;
            }
        }
        return safe;
    }

    public Image getImage(Object object) {
        Image image = null;
        if (object instanceof ItemDecorator) {
            image = ((ItemDecorator)object).getImage();
        } else if (object instanceof ItemWrapper) {
            image = super.getImage(((ItemWrapper)object).getWrappedObject());
        } else if (object instanceof Resource && this.safeResource((Resource)object)) {
            Resource resource = (Resource)object;
            String fileName = resource.getURI().lastSegment();
            ImageDescriptor imageDescriptor = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(fileName);
            if (imageDescriptor != null) {
                image = imageDescriptor.createImage();
            }
        } else {
            image = super.getImage(object);
        }
        return image;
    }
}

