/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session.danalysis;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomainEvent;
import org.eclipse.emf.transaction.TransactionalEditingDomainListener;
import org.eclipse.emf.transaction.TransactionalEditingDomainListenerImpl;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.transaction.util.ValidateEditSupport;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.emf.workspace.ResourceUndoContext;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistryListener2;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.extender.MetamodelDescriptorManager;
import org.eclipse.sirius.business.api.helper.SiriusResourceHelper;
import org.eclipse.sirius.business.api.query.DAnalysisQuery;
import org.eclipse.sirius.business.api.query.FileQuery;
import org.eclipse.sirius.business.api.query.ResourceQuery;
import org.eclipse.sirius.business.api.query.URIQuery;
import org.eclipse.sirius.business.api.session.ModelChangeTrigger;
import org.eclipse.sirius.business.api.session.ReloadingPolicy;
import org.eclipse.sirius.business.api.session.SavingPolicy;
import org.eclipse.sirius.business.api.session.SavingPolicyImpl;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionEventBroker;
import org.eclipse.sirius.business.api.session.SessionListener;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.SessionService;
import org.eclipse.sirius.business.api.session.SessionStatus;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSelector;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSelectorService;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSession;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSessionHelper;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSessionService;
import org.eclipse.sirius.business.internal.metamodel.helper.ComponentizationHelper;
import org.eclipse.sirius.business.internal.migration.resource.ResourceFileExtensionPredicate;
import org.eclipse.sirius.business.internal.movida.Movida;
import org.eclipse.sirius.business.internal.movida.registry.ViewpointRegistryListener;
import org.eclipse.sirius.business.internal.query.DAnalysisesInternalQuery;
import org.eclipse.sirius.business.internal.resource.AirDCrossReferenceAdapter;
import org.eclipse.sirius.business.internal.resource.ResourceModifiedFieldUpdater;
import org.eclipse.sirius.business.internal.session.ReloadingPolicyImpl;
import org.eclipse.sirius.business.internal.session.RepresentationNameListener;
import org.eclipse.sirius.business.internal.session.SessionEventBrokerImpl;
import org.eclipse.sirius.business.internal.session.danalysis.ControlledResourcesDetector;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisRefresher;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionServicesImpl;
import org.eclipse.sirius.business.internal.session.danalysis.DanglingRefRemovalTrigger;
import org.eclipse.sirius.business.internal.session.danalysis.IResourceCollector;
import org.eclipse.sirius.business.internal.session.danalysis.LocalResourceCollector;
import org.eclipse.sirius.business.internal.session.danalysis.MovidaSupport;
import org.eclipse.sirius.business.internal.session.danalysis.ReloadRepresentationsFileCmd;
import org.eclipse.sirius.business.internal.session.danalysis.RepresentationsChangeAdapter;
import org.eclipse.sirius.business.internal.session.danalysis.ResourceSyncClientNotificationFilter;
import org.eclipse.sirius.business.internal.session.danalysis.SemanticResourceGetter;
import org.eclipse.sirius.business.internal.session.danalysis.SemanticResourcesUpdater;
import org.eclipse.sirius.business.internal.session.danalysis.SessionLazyCrossReferencer;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.resource.ResourceSetSync;
import org.eclipse.sirius.common.tools.api.resource.ResourceSyncClient;
import org.eclipse.sirius.common.tools.api.util.EqualityHelper;
import org.eclipse.sirius.common.tools.api.util.LazyCrossReferencer;
import org.eclipse.sirius.ecore.extender.business.api.accessor.EcoreMetamodelDescriptor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.MetamodelDescriptor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.IllegalURIException;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.sirius.ecore.extender.business.api.permission.exception.LockedInstanceException;
import org.eclipse.sirius.tools.api.command.semantic.RemoveSemanticResourceCommand;
import org.eclipse.sirius.tools.api.command.ui.NoUICallback;
import org.eclipse.sirius.tools.api.interpreter.InterpreterRegistry;
import org.eclipse.sirius.tools.api.ui.RefreshEditorsPrecommitListener;
import org.eclipse.sirius.tools.internal.interpreter.ODesignGenericInterpreter;
import org.eclipse.sirius.tools.internal.resource.ResourceSetUtil;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationContainer;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.MetaModelExtension;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.SyncStatus;
import org.eclipse.sirius.viewpoint.ViewpointFactory;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.sirius.viewpoint.description.MetamodelExtensionSetting;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.impl.DAnalysisSessionEObjectImpl;

public class DAnalysisSessionImpl
extends DAnalysisSessionEObjectImpl
implements Session,
DAnalysisSession,
ResourceSyncClient,
ViewpointRegistryListener,
ViewpointRegistryListener2 {
    protected final TransactionalEditingDomain transactionalEditingDomain;
    protected Resource sessionResource;
    private DAnalysis mainDAnalysis;
    protected Collection<Resource> semanticResources;
    protected SemanticResourcesUpdater semanticResourcesUpdater;
    private final ControlledResourcesDetector controlledResourcesDetector;
    private DAnalysisRefresher dAnalysisRefresher;
    protected SavingPolicy savingPolicy;
    private final Saver saver = new Saver();
    private ReloadingPolicy reloadingPolicy;
    private boolean disposeEditingDomainOnClose = true;
    private MovidaSupport movidaSupport = new MovidaSupport(this);
    private IResourceCollector currentResourceCollector;
    protected SessionEventBroker broker;
    private SessionService services;
    private ECrossReferenceAdapter crossReferencer;
    private IInterpreter interpreter;
    private final ListenerList listeners = new ListenerList();
    private int lastNotification = -1;
    protected RefreshEditorsPrecommitListener refreshEditorsListeners;
    private final RepresentationsChangeAdapter representationsChangeAdapter;
    private final ResourceSetListener representationNameListener;

    public DAnalysisSessionImpl(DAnalysis mainDAnalysis) {
        Preconditions.checkNotNull((Object)mainDAnalysis);
        this.sessionResource = mainDAnalysis.eResource();
        Preconditions.checkNotNull((Object)this.sessionResource, (Object)"A session must be inside a resource.");
        this.transactionalEditingDomain = (TransactionalEditingDomain)Preconditions.checkNotNull((Object)TransactionUtil.getEditingDomain((EObject)mainDAnalysis), (Object)"A session must be associated to an EditingDomain");
        this.mainDAnalysis = mainDAnalysis;
        this.interpreter = new ODesignGenericInterpreter();
        this.representationsChangeAdapter = new RepresentationsChangeAdapter(this);
        this.representationNameListener = new RepresentationNameListener();
        this.controlledResourcesDetector = new ControlledResourcesDetector(this);
        super.getAnalyses().add((Object)mainDAnalysis);
        super.getResources().add((Object)this.sessionResource);
        this.setAnalysisSelector(DAnalysisSelectorService.getSelector(this));
        this.setResourceCollector(new LocalResourceCollector(this.getTransactionalEditingDomain().getResourceSet()));
        this.setDeferSaveToPostCommit(true);
        this.setSaveInExclusiveTransaction(true);
    }

    public void setDisposeEditingDomainOnClose(boolean disposeOnClose) {
        this.disposeEditingDomainOnClose = disposeOnClose;
    }

    public boolean getDisposeEditingDomainOnClose() {
        return this.disposeEditingDomainOnClose;
    }

    @Override
    public TransactionalEditingDomain getTransactionalEditingDomain() {
        return this.transactionalEditingDomain;
    }

    @Override
    public void addAnalysis(Resource analysisResource) {
        Preconditions.checkArgument((boolean)(analysisResource.getContents().get(0) instanceof DAnalysis));
        DAnalysis analysis = (DAnalysis)analysisResource.getContents().get(0);
        super.getResources().add((Object)analysisResource);
        super.getAnalyses().add((Object)analysis);
        this.registerResourceInCrossReferencer(analysisResource);
        this.addAdaptersOnAnalysis(analysis);
        this.notifyListeners(10);
        this.updateSelectedViewpointsData((IProgressMonitor)new NullProgressMonitor());
        this.initInterpreter();
    }

    @Override
    public void removeAnalysis(Resource analysisResource) {
        Preconditions.checkArgument((boolean)(analysisResource.getContents().get(0) instanceof DAnalysis));
        DAnalysis analysis = (DAnalysis)analysisResource.getContents().get(0);
        super.getResources().remove((Object)analysisResource);
        super.getAnalyses().remove((Object)analysis);
        for (DAnalysis potentialRef : this.allAnalyses()) {
            if (!potentialRef.getReferencedAnalysis().contains((Object)analysis)) continue;
            potentialRef.getReferencedAnalysis().remove((Object)analysis);
        }
        this.unregisterResourceInCrossReferencer(analysisResource);
        this.transactionalEditingDomain.getResourceSet().getResources().remove((Object)analysisResource);
        this.removeAdaptersOnAnalysis(analysis);
        this.notifyListeners(10);
    }

    @Override
    public void addReferencedAnalysis(DAnalysis newAnalysis) {
        DAnalysis referencer;
        assert (newAnalysis.eResource() != null);
        ArrayList sources = Lists.newArrayList();
        if (!super.getAnalyses().isEmpty() && (referencer = (DAnalysis)super.getAnalyses().iterator().next()) != null) {
            sources.add(referencer);
        }
        this.addReferencedAnalysis(newAnalysis, sources);
    }

    @Override
    public void addReferencedAnalysis(DAnalysis newAnalysis, Collection<DAnalysis> referencers) {
        if (referencers != null && !referencers.isEmpty()) {
            for (DAnalysis referencer : referencers) {
                referencer.getReferencedAnalysis().add((Object)newAnalysis);
            }
            this.addAdaptersOnAnalysis(newAnalysis);
            this.registerResourceInCrossReferencer(newAnalysis.eResource());
            for (DAnalysis dAnalysis : new DAnalysisQuery(newAnalysis).getAllReferencedAnalyses()) {
                this.addAdaptersOnAnalysis(dAnalysis);
                this.registerResourceInCrossReferencer(dAnalysis.eResource());
            }
        } else {
            throw new IllegalStateException("Cant add a referenced analysis if no parent analysis exists");
        }
        this.notifyListeners(10);
    }

    @Override
    public void removeReferencedAnalysis(DAnalysis analysis) {
        assert (analysis.eResource() != null);
        ArrayList referencers = Lists.newArrayList();
        for (DAnalysis potentialRef : this.allAnalyses()) {
            if (!potentialRef.getReferencedAnalysis().contains((Object)analysis)) continue;
            referencers.add(potentialRef);
        }
        if (!referencers.isEmpty()) {
            for (DAnalysis referencer : referencers) {
                referencer.getReferencedAnalysis().remove((Object)analysis);
            }
        } else {
            throw new IllegalStateException("Cant remove a referenced analysis if no parent analysis exists");
        }
        this.removeAdaptersOnAnalysis(analysis);
        this.notifyListeners(10);
    }

    public Collection<DAnalysis> allAnalyses() {
        return new DAnalysisesInternalQuery((Collection<DAnalysis>)super.getAnalyses()).getAllAnalyses();
    }

    private boolean couldBeUnload(ResourceSet rset, Resource resource) {
        return resource.getURI() != null && rset.getPackageRegistry().getEPackage(resource.getURI().toString()) == null;
    }

    @Override
    public void open(IProgressMonitor monitor) {
        try {
            try {
                monitor.beginTask("Open session", 33);
                if (!SessionManager.INSTANCE.getSessions().contains(this)) {
                    SessionManager.INSTANCE.add(this);
                }
                monitor.worked(1);
                this.notifyListeners(6);
                monitor.worked(1);
                DslCommonPlugin.PROFILER.startWork("Open Session");
                this.dAnalysisRefresher = new DAnalysisRefresher(this);
                ResourceSetSync.getOrInstallResourceSetSync((TransactionalEditingDomain)this.transactionalEditingDomain).registerClient((ResourceSyncClient)this);
                monitor.worked(1);
                this.transactionalEditingDomain.addResourceSetListener(this.representationNameListener);
                monitor.worked(1);
                this.saver.initialize();
                Collection<DAnalysis> allAnalyses = this.allAnalyses();
                if (allAnalyses.isEmpty()) {
                    throw new RuntimeException("A analysis session could not be opened without at least a valid analyis");
                }
                DslCommonPlugin.PROFILER.startWork("Resolve All");
                this.dAnalysisRefresher.resolveAllVSMResources(allAnalyses);
                ArrayList resourcesBeforeLoadOfSession = Lists.newArrayList((Iterable)this.getTransactionalEditingDomain().getResourceSet().getResources());
                this.dAnalysisRefresher.forceLoadingOfEveryLinkedResource();
                monitor.worked(10);
                this.dAnalysisRefresher.addAutomaticallyLoadedResourcesToSemanticResources(resourcesBeforeLoadOfSession);
                monitor.worked(1);
                this.setSynchronizeStatusofEveryResource();
                monitor.worked(1);
                DslCommonPlugin.PROFILER.stopWork("Resolve All");
                this.handlePossibleControlledResources();
                monitor.worked(1);
                this.dAnalysisRefresher.init();
                monitor.worked(1);
                if (!this.getSemanticResources().isEmpty()) {
                    this.interpreter = new ODesignGenericInterpreter();
                    this.initInterpreter();
                }
                monitor.worked(1);
                this.initializeAccessor();
                monitor.worked(1);
                ResourceSetSync.getOrInstallResourceSetSync((TransactionalEditingDomain)this.transactionalEditingDomain);
                monitor.worked(1);
                DslCommonPlugin.PROFILER.stopWork("Open Session");
                if (Movida.isEnabled()) {
                    org.eclipse.sirius.business.internal.movida.registry.ViewpointRegistry registry = (org.eclipse.sirius.business.internal.movida.registry.ViewpointRegistry)ViewpointRegistry.getInstance();
                    registry.addListener(this);
                } else {
                    ViewpointRegistry.getInstance().addListener(this);
                }
                TransactionalEditingDomain.DefaultOptions options = (TransactionalEditingDomain.DefaultOptions)TransactionUtil.getAdapter((TransactionalEditingDomain)this.getTransactionalEditingDomain(), TransactionalEditingDomain.DefaultOptions.class);
                if (options != null) {
                    Object value = options.getDefaultTransactionOptions().get("validate_edit");
                    ValidateEditSupport delegate = null;
                    if (value instanceof ValidateEditSupport) {
                        delegate = (ValidateEditSupport)value;
                    }
                    if (!(delegate instanceof ResourceModifiedFieldUpdater) && this.getTransactionalEditingDomain() instanceof InternalTransactionalEditingDomain) {
                        InternalTransactionalEditingDomain internalDomain = (InternalTransactionalEditingDomain)this.getTransactionalEditingDomain();
                        new ResourceModifiedFieldUpdater(internalDomain, delegate);
                    }
                }
                super.setOpen(true);
                this.notifyListeners(7);
                monitor.worked(1);
                this.updateSelectedViewpointsData((IProgressMonitor)new SubProgressMonitor(monitor, 10));
                this.initLocalTriggers();
                this.getTransactionalEditingDomain().addResourceSetListener((ResourceSetListener)this.saver);
            }
            catch (OperationCanceledException e) {
                this.close((IProgressMonitor)new SubProgressMonitor(monitor, 10));
                throw e;
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void initLocalTriggers() {
        Predicate danglingRemovalPredicate = Predicates.or(DanglingRefRemovalTrigger.IS_DETACHMENT, DanglingRefRemovalTrigger.IS_ATTACHMENT);
        DanglingRefRemovalTrigger danglingRemovalTrigger = new DanglingRefRemovalTrigger(this.getTransactionalEditingDomain(), this.getModelAccessor(), this.getSemanticCrossReferencer());
        this.getEventBroker().addLocalTrigger(SessionEventBrokerImpl.asFilter((Predicate<Notification>)danglingRemovalPredicate), (ModelChangeTrigger)danglingRemovalTrigger);
        this.addRefreshEditorsListener();
        for (DAnalysis analysis : this.allAnalyses()) {
            this.addAdaptersOnAnalysis(analysis);
        }
    }

    protected void setSynchronizeStatusofEveryResource() {
        this.setSynchronizeStatusofEveryResource((Iterable<Resource>)this.transactionalEditingDomain.getResourceSet().getResources());
    }

    protected final void setSynchronizeStatusofEveryResource(Iterable<Resource> resourcesToConsider) {
        ResourceSetSync rsSetSync = ResourceSetSync.getOrInstallResourceSetSync((TransactionalEditingDomain)this.transactionalEditingDomain);
        ArrayList changes = Lists.newArrayList();
        for (Resource resource : Sets.newHashSet(resourcesToConsider)) {
            ResourceSetSync.ResourceStatus oldStatus = ResourceSetSync.getStatus((Resource)resource);
            ResourceSetSync.ResourceStatus newStatus = resource.isModified() ? ResourceSetSync.ResourceStatus.CHANGED : ResourceSetSync.ResourceStatus.SYNC;
            changes.add(new ResourceSyncClient.ResourceStatusChange(resource, newStatus, oldStatus));
        }
        rsSetSync.statusesChanged((Collection)changes);
    }

    private void initializeAccessor() {
        try {
            ModelAccessor accessor = this.getModelAccessor();
            if (accessor != null) {
                accessor.init(this.transactionalEditingDomain.getResourceSet());
            }
        }
        catch (IllegalURIException illegalURIException) {
            super.setBlocked(true);
        }
    }

    private void setFilesPropertyToIntepreters() {
        ArrayList<String> filePaths = new ArrayList<String>();
        for (Viewpoint vp : this.getSelectedViewpointsSpecificToGeneric()) {
            Resource vpResource = vp.eResource();
            if (vpResource == null) continue;
            filePaths.add(vpResource.getURI().toPlatformString(true));
        }
        this.interpreter.setProperty((Object)"files", filePaths);
    }

    private void handlePossibleControlledResources() {
        if (this.controlledResourcesDetector != null) {
            this.controlledResourcesDetector.init();
        }
        if (this.semanticResourcesUpdater != null) {
            this.semanticResourcesUpdater.dispose();
            this.semanticResourcesUpdater = null;
        }
        this.semanticResources = null;
    }

    private void initInterpreter() {
        this.interpreter.setProperty((Object)"files", null);
        this.setFilesPropertyToIntepreters();
        EObject eObject = (EObject)this.getSemanticResources().iterator().next().getContents().get(0);
        Session session = SessionManager.INSTANCE.getSession(eObject);
        InterpreterRegistry.prepareImportsFromSession(this.interpreter, session);
        this.interpreter.setCrossReferencer(this.getSemanticCrossReferencer());
    }

    @Override
    public Collection<Viewpoint> getSelectedViewpoints(boolean includeReferencedAnalysis) {
        TreeSet<Viewpoint> result;
        block4: {
            block3: {
                result = new TreeSet<Viewpoint>(new ViewpointRegistry.ViewpointComparator());
                if (!includeReferencedAnalysis) break block3;
                if (super.isBlocked()) break block4;
                Collection<DView> selectedViews = this.getSelectedViews();
                for (DView view : selectedViews) {
                    Viewpoint viewpoint = view.getViewpoint();
                    if (viewpoint == null) continue;
                    result.add(viewpoint);
                }
                break block4;
            }
            if (!super.isBlocked()) {
                for (DView dView : this.mainDAnalysis.getSelectedViews()) {
                    Viewpoint viewpoint = dView.getViewpoint();
                    if (viewpoint == null || viewpoint.eIsProxy()) continue;
                    result.add(viewpoint);
                }
            }
        }
        return Collections.unmodifiableSet(result);
    }

    public Collection<Viewpoint> getSelectedViewpointsSpecificToGeneric() {
        TreeSet<Viewpoint> viewpoints = new TreeSet<Viewpoint>(new ViewpointRegistry.ViewpointComparator());
        viewpoints.addAll(this.getSelectedViewpoints(false));
        ArrayList<Viewpoint> orderedViewpoints = new ArrayList<Viewpoint>(viewpoints.size());
        for (Viewpoint viewpoint : viewpoints) {
            int insertPosition = orderedViewpoints.size();
            for (Viewpoint viewpoint2 : orderedViewpoints) {
                if (ComponentizationHelper.isExtendedBy(viewpoint, viewpoint2)) {
                    insertPosition = orderedViewpoints.indexOf(viewpoint2);
                    continue;
                }
                if (!ComponentizationHelper.isExtendedBy(viewpoint2, viewpoint)) continue;
                insertPosition = orderedViewpoints.indexOf(viewpoint2) + 1;
            }
            orderedViewpoints.add(insertPosition, viewpoint);
        }
        return Collections.unmodifiableCollection(orderedViewpoints);
    }

    @Override
    public Resource getSessionResource() {
        return this.sessionResource;
    }

    @Override
    public Set<Resource> getReferencedSessionResources() {
        ArrayList allSessionResources = Lists.newArrayList(this.getAllSessionResources());
        allSessionResources.remove(this.getSessionResource());
        return new HashSet<Resource>(allSessionResources);
    }

    @Override
    public Collection<Resource> getSemanticResources() {
        if (this.semanticResources == null) {
            this.semanticResources = new CopyOnWriteArrayList<Resource>();
            this.semanticResourcesUpdater = new SemanticResourcesUpdater(this, this.semanticResources);
            if (!super.isBlocked()) {
                SemanticResourceGetter semanticResourcesGetter = new SemanticResourceGetter(this);
                try {
                    TransactionUtil.runExclusive((TransactionalEditingDomain)this.getTransactionalEditingDomain(), (RunnableWithResult)semanticResourcesGetter);
                }
                catch (InterruptedException interruptedException) {
                    SiriusPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.sirius", "Error while accessing semantic resources"));
                }
                ((CopyOnWriteArrayList)this.semanticResources).addAllAbsent((Collection)semanticResourcesGetter.getResult());
            }
        }
        return Collections.unmodifiableCollection(this.semanticResources);
    }

    @Override
    public SessionService getServices() {
        if (this.services == null) {
            this.services = new DAnalysisSessionServicesImpl((Collection<DAnalysis>)super.getAnalyses());
        }
        return this.services;
    }

    @Override
    public String toString() {
        String prefix = "Local Session: ";
        StringBuilder builder = new StringBuilder();
        for (DAnalysis analysis : this.allAnalyses()) {
            Resource resource = analysis.eResource();
            if (resource == null || resource.getURI() == null) continue;
            URI uri = resource.getURI();
            if (new URIQuery(uri).isInMemoryURI()) {
                prefix = "Transient Session: ";
            }
            if (uri.segments().length > 0) {
                builder.append(URI.decode((String)uri.lastSegment())).append("  ");
                continue;
            }
            builder.append(uri.opaquePart()).append(" ");
        }
        builder.insert(0, prefix);
        if (builder.length() > 2 && "  ".equals(builder.substring(builder.length() - 2, builder.length()))) {
            builder.delete(builder.length() - 2, builder.length());
        }
        return builder.toString();
    }

    private void addSemanticResource(Resource newResource, boolean addCrossReferencedResources, IProgressMonitor monitor) {
        ResourceSet set = this.transactionalEditingDomain.getResourceSet();
        this.doAddSemanticResource(newResource, set);
        if (addCrossReferencedResources) {
            for (Resource res : this.collectAllReferencedResources(newResource)) {
                this.doAddSemanticResource(res, set);
            }
        }
    }

    protected Collection<Resource> collectAllReferencedResources(Resource res) {
        Collection<Resource> result = Collections.emptyList();
        if (this.currentResourceCollector != null) {
            result = this.currentResourceCollector.getAllReferencedResources(res);
        }
        return result;
    }

    protected Collection<Resource> collectAllReferencingResources(Resource res) {
        Collection<Resource> result = Collections.emptyList();
        if (this.currentResourceCollector != null) {
            result = this.currentResourceCollector.getAllReferencingResources(res);
        }
        return result;
    }

    private synchronized void addSemanticResource(URI semanticModelURI, boolean addCrossReferencedResources, IProgressMonitor monitor) {
        if (semanticModelURI != null) {
            if (new FileQuery(semanticModelURI.fileExtension()).isSessionResourceFile()) {
                throw new IllegalArgumentException("A representation file cannot be added as semantic resource.");
            }
            monitor.beginTask("Semantic resource addition : " + semanticModelURI.lastSegment(), 3);
            ResourceSet resourceSet = this.transactionalEditingDomain.getResourceSet();
            ResourceSetUtil.setProgressMonitor(resourceSet, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
            try {
                monitor.beginTask("Semantic resource addition : " + semanticModelURI.lastSegment(), 3);
                Resource newSemanticResource = resourceSet.getResource(semanticModelURI, false);
                if (newSemanticResource != null && newSemanticResource.getContents().isEmpty()) {
                    newSemanticResource.unload();
                }
                monitor.worked(1);
                newSemanticResource = resourceSet.getResource(semanticModelURI, true);
                if (!this.getSemanticResources().contains(newSemanticResource)) {
                    this.addSemanticResource(newSemanticResource, addCrossReferencedResources, monitor);
                }
            }
            finally {
                monitor.done();
                ResourceSetUtil.resetProgressMonitor(resourceSet);
            }
        }
    }

    @Override
    public void addSemanticResource(URI semanticResourceURI, IProgressMonitor monitor) {
        this.addSemanticResource(semanticResourceURI, true, monitor);
    }

    @Override
    public synchronized void createSemanticResource(URI semanticModelURI) {
        ResourceSet rs = this.transactionalEditingDomain.getResourceSet();
        Resource resource = rs.createResource(semanticModelURI);
        rs.getResources().remove((Object)resource);
        this.addSemanticResource(resource, true, null);
    }

    protected void doAddSemanticResource(Resource newResource, ResourceSet set) {
        if (new ResourceQuery(newResource).isRepresentationsResource()) {
            throw new IllegalArgumentException("A representation file cannot be added as semantic resource.");
        }
        if (newResource.getResourceSet() != set) {
            set.getResources().add((Object)newResource);
        }
        if (newResource.getContents().size() > 0) {
            this.notifyNewMetamodels(newResource);
            EObject root = (EObject)newResource.getContents().get(0);
            for (DAnalysis analysis : this.allAnalyses()) {
                analysis.getModels().add((Object)root);
            }
        }
        this.registerResourceInCrossReferencer(newResource);
    }

    protected void registerResourceInCrossReferencer(Resource newResource) {
        if (this.crossReferencer != null && !newResource.eAdapters().contains((Object)this.crossReferencer)) {
            newResource.eAdapters().add((Object)this.crossReferencer);
        }
    }

    protected void unregisterResourceInCrossReferencer(Resource resource) {
        if (this.crossReferencer != null && resource.eAdapters().contains((Object)this.crossReferencer)) {
            resource.eAdapters().remove((Object)this.crossReferencer);
        }
    }

    private void notifyNewMetamodels(Resource newResource) {
        if (Boolean.valueOf(System.getProperty("org.eclipse.sirius.enableUnsafeOptimisations", "false")).booleanValue()) {
            return;
        }
        Collection<EPackage> collectedMetamodels = this.collectMetamodels((TreeIterator<EObject>)newResource.getAllContents());
        ModelAccessor accessor = this.getModelAccessor();
        if (accessor != null) {
            ArrayList<EcoreMetamodelDescriptor> descriptors = new ArrayList<EcoreMetamodelDescriptor>();
            for (EPackage package1 : collectedMetamodels) {
                descriptors.add(new EcoreMetamodelDescriptor(package1));
            }
            accessor.activateMetamodels(descriptors);
        }
    }

    private Collection<EPackage> collectMetamodels(TreeIterator<EObject> allContents) {
        LinkedHashSet<EPackage> result = new LinkedHashSet<EPackage>();
        while (allContents.hasNext()) {
            result.add(((EObject)allContents.next()).eClass().getEPackage());
        }
        return result;
    }

    @Override
    public ModelAccessor getModelAccessor() {
        return SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(this.transactionalEditingDomain.getResourceSet());
    }

    @Override
    public final void save(IProgressMonitor monitor) {
        this.save(null, monitor);
    }

    @Override
    public void save(Map<?, ?> options, IProgressMonitor monitor) {
        this.saver.save(options, monitor);
    }

    protected void doSave(final Map<?, ?> options, final IProgressMonitor monitor, boolean runExclusive) {
        block13: {
            try {
                try {
                    monitor.beginTask("Session saving", 3);
                    final ArrayList allResources = Lists.newArrayList();
                    allResources.addAll(this.getAllSessionResources());
                    Collection<Resource> semanticResourcesCollection = this.getSemanticResources();
                    allResources.addAll(semanticResourcesCollection);
                    allResources.addAll(this.getControlledResources());
                    monitor.worked(1);
                    RunnableWithResult.Impl<Collection<Resource>> save = new RunnableWithResult.Impl<Collection<Resource>>(){

                        public void run() {
                            try {
                                Collection<Resource> savedResources = DAnalysisSessionImpl.this.getSavingPolicy().save(allResources, options, (IProgressMonitor)new SubProgressMonitor(monitor, 7));
                                this.setResult(savedResources);
                                this.setStatus(Status.OK_STATUS);
                            }
                            catch (Throwable e) {
                                this.setStatus((IStatus)new Status(4, "org.eclipse.sirius", "error while saving", e));
                            }
                        }
                    };
                    if (runExclusive && !this.saver.domainDisposed.get()) {
                        this.getTransactionalEditingDomain().runExclusive((Runnable)save);
                    } else {
                        save.run();
                    }
                    if (!save.getStatus().isOK()) {
                        SiriusPlugin.getDefault().error("save failed", new CoreException(save.getStatus()));
                        break block13;
                    }
                    Collection savedResources = (Collection)save.getResult();
                    boolean semanticSave = false;
                    for (Resource resource : savedResources) {
                        if (!semanticResourcesCollection.contains(resource) && !this.getControlledResources().contains((Object)resource)) continue;
                        semanticSave = true;
                    }
                    if (semanticSave) {
                        this.notifyListeners(11);
                    }
                    monitor.worked(1);
                    CommandStack commandStack = this.transactionalEditingDomain.getCommandStack();
                    if (commandStack instanceof BasicCommandStack) {
                        ((BasicCommandStack)commandStack).saveIsDone();
                    }
                    if (this.allResourcesAreInSync()) {
                        this.notifyListeners(3);
                    } else {
                        this.notifyListeners(2);
                    }
                    monitor.worked(1);
                }
                catch (InterruptedException e) {
                    SiriusPlugin.getDefault().warning("save interrupted", e);
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    @Override
    public String getID() {
        String id = "INVALID SESSION";
        StringBuilder builder = new StringBuilder();
        Collection<DAnalysis> allAnalyses = this.allAnalyses();
        if (!allAnalyses.isEmpty()) {
            for (DAnalysis analysis : allAnalyses) {
                Resource analysisResource = analysis.eResource();
                if (analysisResource != null && analysisResource.getURI() != null) {
                    builder.append(analysisResource.getURI().toString()).append(' ');
                    continue;
                }
                return "INVALID SESSION";
            }
            id = builder.toString();
        }
        return id;
    }

    @Override
    public void addSelectedView(DView view, IProgressMonitor monitor) throws IllegalArgumentException {
        try {
            monitor.beginTask("View selection", 3);
            DAnalysis foundAnalysis = null;
            for (DAnalysis dAnalysis : this.allAnalyses()) {
                if (!dAnalysis.getOwnedViews().contains((Object)view)) continue;
                foundAnalysis = dAnalysis;
                break;
            }
            if (foundAnalysis == null) {
                throw new IllegalArgumentException("The view is not contained in the analysis");
            }
            foundAnalysis.getSelectedViews().add((Object)view);
            monitor.worked(1);
            this.updateSelectedViewpointsData((IProgressMonitor)new NullProgressMonitor());
            monitor.worked(1);
            this.notifyListeners(0);
            monitor.worked(1);
            this.initInterpreter();
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public Collection<DView> getSelectedViews() {
        HashSet<DView> selectedViews = new HashSet<DView>();
        for (DAnalysis analysis : this.allAnalyses()) {
            for (Object object : analysis.getSelectedViews()) {
                if (!(object instanceof DView)) continue;
                selectedViews.add((DView)object);
            }
        }
        return selectedViews;
    }

    @Override
    public Collection<DView> getOwnedViews() {
        HashSet<DView> ownedViews = new HashSet<DView>();
        for (DAnalysis analysis : this.allAnalyses()) {
            for (DView dView : analysis.getOwnedViews()) {
                ownedViews.add(dView);
            }
        }
        return ownedViews;
    }

    void unselectSirius(Viewpoint viewpoint, IProgressMonitor pm) {
        for (DView selectedDView : this.mainDAnalysis.getSelectedViews()) {
            if (!EqualityHelper.areEquals((EObject)selectedDView.getViewpoint(), (EObject)viewpoint)) continue;
            this.removeSelectedView(selectedDView, pm);
            break;
        }
    }

    @Override
    public void removeSelectedView(DView view, IProgressMonitor monitor) {
        try {
            monitor.beginTask("View unselection", 1);
            this.mainDAnalysis.getSelectedViews().remove((Object)view);
            this.updateSelectedViewpointsData((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.notifyListeners(0);
            this.initInterpreter();
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IInterpreter getInterpreter() {
        if (this.crossReferencer == null) {
            this.interpreter.setCrossReferencer(this.getSemanticCrossReferencer());
        }
        return this.interpreter;
    }

    @Override
    public void createView(Viewpoint viewpoint, Collection<EObject> semantics, IProgressMonitor monitor) {
        this.createView(viewpoint, semantics, true, monitor);
    }

    @Override
    public void createView(Viewpoint viewpoint, Collection<EObject> semantics, boolean createNewRepresentations, IProgressMonitor monitor) {
        try {
            monitor.beginTask("View creation for Sirius : " + viewpoint.getName(), 3 + 10 * semantics.size());
            LinkedHashSet<DView> intializedDViews = new LinkedHashSet<DView>();
            for (DAnalysis dAnalysis : this.allAnalyses()) {
                if (this.hasAlreadyDViewForSirius(dAnalysis, viewpoint)) continue;
                DView firstOrphanDView = new DAnalysisQuery(dAnalysis).getFirstOrphanDView();
                DView dView = null;
                dView = firstOrphanDView == null ? ViewpointFactory.eINSTANCE.createDRepresentationContainer() : firstOrphanDView;
                dView.setViewpoint(viewpoint);
                dAnalysis.getOwnedViews().add((Object)dView);
                dAnalysis.getSelectedViews().add((Object)dView);
                dView.setInitialized(true);
                intializedDViews.add(dView);
            }
            monitor.worked(1);
            this.initInterpreter();
            InterpreterRegistry.prepareImportsFromSession(this.interpreter, this);
            if (createNewRepresentations) {
                monitor.subTask("Initialize representations");
                for (EObject semantic : semantics) {
                    DialectManager.INSTANCE.initRepresentations(viewpoint, semantic, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                }
            }
            this.updateSelectedViewpointsData((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            for (DView dView : intializedDViews) {
                if (!(dView instanceof DRepresentationContainer)) continue;
                DRepresentationContainer dRepresentationContainer = (DRepresentationContainer)dView;
                for (MetamodelExtensionSetting extensionSetting : viewpoint.getOwnedMMExtensions()) {
                    ModelAccessor accessor = this.getModelAccessor();
                    if (extensionSetting.getExtensionGroup() == null || !accessor.eInstanceOf(extensionSetting.getExtensionGroup(), "ExtensionGroup")) continue;
                    EObject group = extensionSetting.getExtensionGroup();
                    MetaModelExtension extension = ViewpointFactory.eINSTANCE.createMetaModelExtension();
                    extension.setExtensionGroup(group);
                    dRepresentationContainer.setOwnedExtensions(extension);
                }
            }
            monitor.worked(1);
            if (!intializedDViews.isEmpty()) {
                this.notifyListeners(0);
            }
            monitor.worked(1);
        }
        finally {
            monitor.done();
        }
    }

    private boolean hasAlreadyDViewForSirius(DAnalysis dAnalysis, Viewpoint viewpoint) {
        boolean hasAlreadyDViewForSirius = false;
        for (DView ownedDView : dAnalysis.getOwnedViews()) {
            if (ownedDView.getViewpoint() == null || !EqualityHelper.areEquals((EObject)ownedDView.getViewpoint(), (EObject)viewpoint)) continue;
            hasAlreadyDViewForSirius = true;
            break;
        }
        return hasAlreadyDViewForSirius;
    }

    private void updateSelectedViewpointsData(IProgressMonitor monitor) {
        try {
            Resource viewpointResource;
            LinkedHashSet selectedViewpoints = Sets.newLinkedHashSet();
            for (Viewpoint viewpoint : this.getSelectedViewpoints(false)) {
                if (viewpoint.eResource() != null) {
                    selectedViewpoints.add(SiriusResourceHelper.getCorrespondingViewpoint(this, viewpoint));
                    continue;
                }
                selectedViewpoints.add(viewpoint);
            }
            Sets.SetView difference = Sets.difference((Set)Sets.newHashSet(this.getActivatedViewpoints()), (Set)Sets.newHashSet((Iterable)selectedViewpoints));
            monitor.beginTask("Update selected Viewpoints data", selectedViewpoints.size() + difference.size() + 1);
            for (Viewpoint viewpoint : selectedViewpoints) {
                viewpointResource = viewpoint.eResource();
                if (viewpointResource != null) {
                    this.registerResourceInCrossReferencer(viewpointResource);
                }
                monitor.worked(1);
            }
            for (Viewpoint viewpoint : difference) {
                viewpointResource = viewpoint.eResource();
                if (viewpointResource != null) {
                    this.unregisterResourceInCrossReferencer(viewpointResource);
                }
                monitor.worked(1);
            }
            super.getActivatedViewpoints().addAll((Collection)selectedViewpoints);
            super.getActivatedViewpoints().retainAll((Collection)selectedViewpoints);
            if (Movida.isEnabled()) {
                this.movidaSupport.updatePhysicalVSMResourceURIs(selectedViewpoints);
            }
            ModelAccessor accessor = this.getModelAccessor();
            Collection<MetamodelDescriptor> metamodels = MetamodelDescriptorManager.INSTANCE.provides(this.getSelectedViewpoints(false));
            if (accessor != null) {
                accessor.activateMetamodels(metamodels);
            }
            if (this.getInterpreter() != null) {
                this.getInterpreter().activateMetamodels(metamodels);
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void addListener(SessionListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeListener(SessionListener listener) {
        this.listeners.remove((Object)listener);
    }

    @Override
    public ECrossReferenceAdapter getSemanticCrossReferencer() {
        if (this.crossReferencer == null) {
            this.crossReferencer = this.createSemanticCrossReferencer();
            if (this.interpreter != null) {
                this.interpreter.setCrossReferencer(this.crossReferencer);
            }
        }
        return this.crossReferencer;
    }

    protected ECrossReferenceAdapter createSemanticCrossReferencer() {
        return new SessionLazyCrossReferencer(this);
    }

    public static void uncachedEObejctIDs(List<Resource> resources) {
        for (Resource currentResource : resources) {
            if (!(currentResource instanceof ResourceImpl)) continue;
            ((ResourceImpl)currentResource).setIntrinsicIDToEObjectMap(null);
        }
    }

    @Override
    public void setAnalysisSelector(DAnalysisSelector selector) {
        if (this.getServices() instanceof DAnalysisSessionService) {
            ((DAnalysisSessionService)((Object)this.getServices())).setAnalysisSelector(selector);
        }
    }

    @Override
    public Set<Resource> getAllSessionResources() {
        LinkedHashSet<Resource> analysisResources = new LinkedHashSet<Resource>();
        for (DAnalysis analysis : this.allAnalyses()) {
            Resource analysisResource = analysis.eResource();
            if (analysisResource == null) continue;
            analysisResources.add(analysisResource);
        }
        return Collections.unmodifiableSet(analysisResources);
    }

    private void transferCustomData(Session origin, EObject associatedInstance) {
        Collection<EObject> diagrams = origin.getServices().getCustomData("GMF_DIAGRAMS", associatedInstance);
        for (EObject object : diagrams) {
            this.getServices().putCustomData("GMF_DIAGRAMS", associatedInstance, object);
        }
    }

    private DView findViewForRepresentation(DRepresentation representation, DAnalysis analysis) {
        Viewpoint vp = this.getViewpoint(representation);
        for (DView view : analysis.getOwnedViews()) {
            if (view.getViewpoint() == null || !EqualityHelper.areEquals((EObject)view.getViewpoint(), (EObject)vp)) continue;
            return view;
        }
        return null;
    }

    private Viewpoint getViewpoint(DRepresentation representation) {
        return ((DView)representation.eContainer()).getViewpoint();
    }

    @Override
    public void addAdaptersOnAnalysis(DAnalysis analysis) {
        if (this.representationsChangeAdapter != null) {
            this.representationsChangeAdapter.registerAnalysis(analysis);
        }
        if (this.semanticResourcesUpdater != null && !analysis.eAdapters().contains((Object)this.semanticResourcesUpdater)) {
            analysis.eAdapters().add((Object)this.semanticResourcesUpdater);
        }
    }

    @Override
    public void removeAdaptersOnAnalysis(DAnalysis analysis) {
        if (this.representationsChangeAdapter != null) {
            this.representationsChangeAdapter.unregisterAnalysis(analysis);
        }
    }

    @Override
    public void moveRepresentation(DAnalysis newContainer, DRepresentation representation) {
        IPermissionAuthority receiverAuthority;
        IPermissionAuthority authority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(representation.eContainer());
        NullProgressMonitor pm = new NullProgressMonitor();
        if (!authority.canDeleteInstance((EObject)representation)) {
            throw new LockedInstanceException(new EObject[]{representation});
        }
        EObject semantic = representation.eContainer() instanceof DRepresentationContainer && !((DRepresentationContainer)representation.eContainer()).getModels().isEmpty() ? (EObject)((DRepresentationContainer)representation.eContainer()).getModels().iterator().next() : null;
        DView receiver = this.findViewForRepresentation(representation, newContainer);
        if (receiver == null) {
            IPermissionAuthority analysisAuthority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority((EObject)newContainer);
            if (analysisAuthority.canCreateIn((EObject)newContainer)) {
                this.createView(this.getViewpoint(representation), Lists.newArrayList((Object[])new EObject[]{semantic}), false, (IProgressMonitor)pm);
                receiver = this.findViewForRepresentation(representation, newContainer);
            } else {
                throw new LockedInstanceException(new EObject[]{newContainer});
            }
        }
        if ((receiverAuthority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority((EObject)receiver)).canCreateIn((EObject)receiver)) {
            receiver.getOwnedRepresentations().add((Object)representation);
            if (receiver.eContainer() instanceof DAnalysis) {
                DAnalysisSessionHelper.updateModelsReferences((DAnalysis)receiver.eContainer(), (Iterator<DSemanticDecorator>)Iterators.filter((Iterator)representation.eAllContents(), DSemanticDecorator.class));
            }
        } else {
            throw new LockedInstanceException(new EObject[]{receiver});
        }
        this.transferCustomData(this, representation);
    }

    private void notifyListeners(int notification) {
        if (notification == 10 || notification == 0 || notification == 16 || notification != this.lastNotification) {
            for (SessionListener listener : Iterables.filter((Iterable)Lists.newArrayList((Object[])this.listeners.getListeners()), SessionListener.class)) {
                listener.notify(notification);
            }
            this.lastNotification = notification;
        }
    }

    public void removeReferencedRepresentation(DAnalysis analysis, DRepresentation representation) {
        DView view = this.findViewForRepresentation(representation, analysis);
        if (view != null && view.getReferencedRepresentations().contains((Object)representation)) {
            IPermissionAuthority authority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority((EObject)view);
            if (authority.canEditFeature((EObject)view, ViewpointPackage.eINSTANCE.getDView_ReferencedRepresentations().getName())) {
                view.getReferencedRepresentations().remove((Object)representation);
            } else {
                throw new LockedInstanceException(new EObject[]{view});
            }
        }
    }

    @Override
    public void notifyControlledModel(Resource newControlled) {
        for (Resource controlledResource : super.getControlledResources()) {
            controlledResource.setModified(true);
        }
        super.getControlledResources().add((Object)newControlled);
        this.notifyListeners(11);
    }

    @Override
    public void notifyUnControlledModel(EObject uncontrolled, Resource resource) {
        if (resource.getContents().size() == 0) {
            super.getControlledResources().remove((Object)resource);
        }
        this.notifyListeners(11);
    }

    @Override
    public void removeSemanticResource(Resource semanticResource, IProgressMonitor monitor) {
        ResourceSet resourceSet = this.transactionalEditingDomain.getResourceSet();
        for (Resource res : this.collectAllReferencingResources(semanticResource)) {
            this.doRemoveSemanticResource(res, resourceSet);
        }
        this.doRemoveSemanticResource(semanticResource, resourceSet);
    }

    protected void doRemoveSemanticResource(Resource res, ResourceSet set) {
        if (res.getContents().size() > 0) {
            EObject root = (EObject)res.getContents().get(0);
            for (DAnalysis analysis : this.allAnalyses()) {
                analysis.getModels().remove((Object)root);
            }
        }
        this.unregisterResourceInCrossReferencer(res);
        if (this.couldBeUnload(set, res)) {
            res.unload();
        }
        set.getResources().remove((Object)res);
    }

    public void statusChanged(Resource resource, ResourceSetSync.ResourceStatus oldStatus, ResourceSetSync.ResourceStatus newStatus) {
    }

    public void statusesChanged(Collection<ResourceSyncClient.ResourceStatusChange> changes) {
        if (this.isOpen()) {
            Multimap<ResourceSetSync.ResourceStatus, Resource> newStatuses = this.getImpactingNewStatuses(changes);
            boolean allResourcesSync = this.allResourcesAreInSync();
            for (ResourceSetSync.ResourceStatus newStatus : newStatuses.keySet()) {
                switch (newStatus) {
                    case SYNC: {
                        if (!allResourcesSync) break;
                        this.notifyListeners(3);
                        break;
                    }
                    case CHANGED: {
                        this.notifyListeners(2);
                        break;
                    }
                    case EXTERNAL_CHANGED: 
                    case CONFLICTING_CHANGED: 
                    case CONFLICTING_DELETED: 
                    case DELETED: {
                        NullProgressMonitor pm = new NullProgressMonitor();
                        Collection collection = newStatuses.get((Object)newStatus);
                        for (Resource resource : collection) {
                            try {
                                if (this.isInProjectDeletedRenamedOrClosed(resource)) {
                                    this.processAction(ReloadingPolicy.Action.CLOSE_SESSION, resource, (IProgressMonitor)pm);
                                    return;
                                }
                                this.processActions(this.getReloadingPolicy().getActions(this, resource, newStatus), resource, (IProgressMonitor)pm);
                            }
                            catch (Exception e) {
                                SiriusPlugin.getDefault().error("Can't handle resource change : " + resource.getURI(), e);
                            }
                        }
                        allResourcesSync = this.allResourcesAreInSync();
                        if (allResourcesSync) {
                            this.notifyListeners(3);
                            break;
                        }
                        this.notifyListeners(2);
                        break;
                    }
                }
            }
            if (allResourcesSync) {
                super.setSynchronizationStatus(SyncStatus.SYNC);
            } else {
                super.setSynchronizationStatus(SyncStatus.DIRTY);
            }
        }
    }

    protected boolean isResourceOfSession(Resource resource, Iterable<Resource> resources) {
        boolean isResourceOfSession = false;
        ResourceSyncClientNotificationFilter resourceSyncClientNotificationFilter = new ResourceSyncClientNotificationFilter(resource);
        isResourceOfSession = Iterables.any(resources, (Predicate)resourceSyncClientNotificationFilter);
        return isResourceOfSession;
    }

    private Multimap<ResourceSetSync.ResourceStatus, Resource> getImpactingNewStatuses(Collection<ResourceSyncClient.ResourceStatusChange> changes) {
        LinkedHashMultimap impactingNewStatuses = LinkedHashMultimap.create();
        Iterable resources = Iterables.concat(this.getSemanticResources(), this.getAllSessionResources(), this.getControlledResources());
        for (ResourceSyncClient.ResourceStatusChange change : changes) {
            if (!this.isResourceOfSession(change.getResource(), resources)) continue;
            impactingNewStatuses.put((Object)change.getNewStatus(), (Object)change.getResource());
        }
        return impactingNewStatuses;
    }

    private boolean isInProjectDeletedRenamedOrClosed(Resource resource) {
        IProject project;
        IFile file = WorkspaceSynchronizer.getFile((Resource)resource);
        if (file != null && (project = file.getProject()) != null) {
            return !project.exists() || !project.isOpen();
        }
        return false;
    }

    private void processActions(List<ReloadingPolicy.Action> actions, Resource resource, IProgressMonitor pm) throws Exception {
        for (ReloadingPolicy.Action action : actions) {
            this.processAction(action, resource, pm);
        }
    }

    private void processAction(ReloadingPolicy.Action action, Resource resource, IProgressMonitor pm) throws Exception {
        switch (action) {
            case CLOSE_SESSION: {
                this.close(pm);
                break;
            }
            case RELOAD: {
                if (!this.isOpen()) break;
                this.reloadResource(resource);
                break;
            }
            case REMOVE: {
                this.removeResourceFromSession(resource, pm);
                break;
            }
        }
    }

    private void removeResourceFromSession(Resource resource, IProgressMonitor pm) {
        if (this.getSemanticResources().contains(resource)) {
            this.getTransactionalEditingDomain().getCommandStack().execute((Command)new RemoveSemanticResourceCommand(this, resource, false, (IProgressMonitor)new NullProgressMonitor()));
        } else if (this.getAllSessionResources().contains(resource)) {
            this.removeAnalysis(resource);
        }
        if (this.getResources().contains((Object)resource)) {
            for (EObject root : Lists.newArrayList((Iterable)resource.getContents())) {
                EcoreUtil.remove((EObject)root);
            }
            this.getResources().remove((Object)resource);
        }
        if (this.getAllSessionResources().isEmpty()) {
            this.close(pm);
        }
    }

    private void reloadResource(final Resource resource) throws IOException {
        this.notifyListeners(4);
        ReloadRepresentationsFileCmd reloadingAnalysisCmd = null;
        ResourceQuery resourceQuery = new ResourceQuery(resource);
        boolean representationsResource = resourceQuery.isRepresentationsResource();
        if (representationsResource) {
            reloadingAnalysisCmd = new ReloadRepresentationsFileCmd(this, this.transactionalEditingDomain, "Reload " + resource.getURI() + "file", resource);
        }
        ArrayList resourcesBeforeReload = Lists.newArrayList((Iterable)this.getTransactionalEditingDomain().getResourceSet().getResources());
        RunnableWithResult.Impl<Object> reload = new RunnableWithResult.Impl<Object>(){

            public void run() {
                resource.unload();
                try {
                    resource.load(Collections.EMPTY_MAP);
                    EcoreUtil.resolveAll((Resource)resource);
                }
                catch (IOException e) {
                    this.setResult(e);
                }
            }
        };
        try {
            this.transactionalEditingDomain.runExclusive((Runnable)reload);
            if (reload.getResult() != null) {
                throw (IOException)reload.getResult();
            }
            if (!reload.getStatus().isOK()) {
                SiriusPlugin.getDefault().error("a reload operation failed for unknown reason", null);
            } else {
                if (representationsResource) {
                    this.transactionalEditingDomain.getCommandStack().execute((Command)reloadingAnalysisCmd);
                    if (resource.getURI().equals(this.sessionResource.getURI())) {
                        this.sessionResource = resource;
                        this.mainDAnalysis = (DAnalysis)this.sessionResource.getContents().get(0);
                    }
                }
                if (this.dAnalysisRefresher != null) {
                    this.dAnalysisRefresher.addAutomaticallyLoadedResourcesToSemanticResources(resourcesBeforeReload);
                }
                this.notifyListeners(5);
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    @Override
    public void setReloadingPolicy(ReloadingPolicy reloadingPolicy) {
        this.reloadingPolicy = reloadingPolicy;
    }

    @Override
    public ReloadingPolicy getReloadingPolicy() {
        return this.reloadingPolicy != null ? this.reloadingPolicy : new ReloadingPolicyImpl(new NoUICallback());
    }

    @Override
    public void setSavingPolicy(SavingPolicy savingPolicy) {
        this.savingPolicy = savingPolicy;
    }

    @Override
    public SavingPolicy getSavingPolicy() {
        return this.savingPolicy != null ? this.savingPolicy : new SavingPolicyImpl(this.transactionalEditingDomain);
    }

    protected boolean allResourcesAreInSync() {
        Iterable it = Iterables.concat(this.getSemanticResources(), this.getAllSessionResources(), super.getControlledResources());
        return this.checkResourcesAreInSync(it);
    }

    protected final boolean checkResourcesAreInSync(Iterable<? extends Resource> resourcesToConsider) {
        boolean allResourceAreInSync = true;
        for (Resource resource : resourcesToConsider) {
            ResourceSetSync.ResourceStatus status = ResourceSetSync.getStatus((Resource)resource);
            URI uri = resource.getURI();
            boolean bl = allResourceAreInSync = status == ResourceSetSync.ResourceStatus.SYNC || !uri.isPlatformResource() && !new URIQuery(uri).isInMemoryURI() && !new URIQuery(uri).isCDOURI();
            if (!allResourceAreInSync) break;
        }
        return allResourceAreInSync;
    }

    @Override
    public SessionStatus getStatus() {
        if (this.allResourcesAreInSync()) {
            return SessionStatus.SYNC;
        }
        return SessionStatus.DIRTY;
    }

    public void transfertNotification(int notification) {
        this.notifyListeners(notification);
    }

    @Override
    public SessionEventBroker getEventBroker() {
        if (this.broker == null) {
            this.broker = new SessionEventBrokerImpl(this.transactionalEditingDomain);
        }
        return this.broker;
    }

    protected void addRefreshEditorsListener() {
        if (this.refreshEditorsListeners == null) {
            this.refreshEditorsListeners = new RefreshEditorsPrecommitListener(this.transactionalEditingDomain);
            this.getEventBroker().addLocalTrigger(RefreshEditorsPrecommitListener.IS_IMPACTING, (ModelChangeTrigger)this.refreshEditorsListeners);
            this.addListener(this.refreshEditorsListeners);
        }
    }

    @Override
    public RefreshEditorsPrecommitListener getRefreshEditorsListener() {
        return this.refreshEditorsListeners;
    }

    @Override
    public void close(IProgressMonitor monitor) {
        if (!this.isOpen()) {
            return;
        }
        if (this.saver != null && this.getTransactionalEditingDomain() != null) {
            this.getTransactionalEditingDomain().removeResourceSetListener((ResourceSetListener)this.saver);
        }
        if (Movida.isEnabled()) {
            org.eclipse.sirius.business.internal.movida.registry.ViewpointRegistry registry = (org.eclipse.sirius.business.internal.movida.registry.ViewpointRegistry)ViewpointRegistry.getInstance();
            registry.removeListener(this);
        } else {
            ViewpointRegistry.getInstance().removeListener(this);
        }
        this.notifyListeners(8);
        this.disableAndRemoveECrossReferenceAdapters();
        if (this.controlledResourcesDetector != null) {
            this.controlledResourcesDetector.dispose();
        }
        if (this.dAnalysisRefresher != null) {
            this.dAnalysisRefresher.dispose();
            this.dAnalysisRefresher = null;
        }
        if (this.interpreter != null) {
            this.interpreter.dispose();
        }
        ResourceSetSync.getOrInstallResourceSetSync((TransactionalEditingDomain)this.transactionalEditingDomain).unregisterClient((ResourceSyncClient)this);
        ResourceSetSync.uninstallResourceSetSync((TransactionalEditingDomain)this.transactionalEditingDomain);
        super.setOpen(false);
        ResourceSet resourceSet = this.getTransactionalEditingDomain().getResourceSet();
        if (this.currentResourceCollector != null) {
            this.currentResourceCollector.dispose();
            this.currentResourceCollector = null;
        }
        this.interpreter = null;
        this.crossReferencer = null;
        this.transactionalEditingDomain.removeResourceSetListener(this.representationNameListener);
        if (this.broker != null) {
            this.broker.dispose();
            this.broker = null;
        }
        this.flushOperations();
        this.unloadResource();
        if (this.disposeEditingDomainOnClose) {
            for (Resource resource : new ArrayList(resourceSet.getResources())) {
                resource.unload();
                resourceSet.getResources().remove((Object)resource);
            }
        }
        this.notifyListeners(9);
        SessionManager.INSTANCE.remove(this);
        if (this.semanticResourcesUpdater != null) {
            this.semanticResourcesUpdater.dispose();
            this.semanticResourcesUpdater = null;
        }
        if (this.semanticResources != null) {
            this.semanticResources.clear();
        }
        this.reenableECrossReferenceAdaptersBeforeEndOfClosing();
        this.saver.dispose();
        if (this.disposeEditingDomainOnClose) {
            this.transactionalEditingDomain.dispose();
            this.doDisposePermissionAuthority(resourceSet);
        }
        this.mainDAnalysis = null;
    }

    protected void disableAndRemoveECrossReferenceAdapters() {
        ResourceSet resourceSet = this.getTransactionalEditingDomain().getResourceSet();
        Adapter existingAirDCrossReferenceAdapter = EcoreUtil.getExistingAdapter((Notifier)resourceSet, AirDCrossReferenceAdapter.class);
        AirDCrossReferenceAdapter airDCrossReferenceAdapter = null;
        if (existingAirDCrossReferenceAdapter instanceof AirDCrossReferenceAdapter) {
            airDCrossReferenceAdapter = (AirDCrossReferenceAdapter)existingAirDCrossReferenceAdapter;
            airDCrossReferenceAdapter.disableResolve();
            resourceSet.eAdapters().remove((Object)airDCrossReferenceAdapter);
        }
        if (this.getSemanticCrossReferencer() instanceof LazyCrossReferencer) {
            ((LazyCrossReferencer)this.getSemanticCrossReferencer()).disableResolve();
        }
        for (Resource res : this.getSemanticResources()) {
            this.unregisterResourceInCrossReferencer(res);
        }
        for (DAnalysis analysis : Iterables.filter(this.allAnalyses(), (Predicate)Predicates.notNull())) {
            this.removeAdaptersOnAnalysis(analysis);
            Resource analysisResource = analysis.eResource();
            if (analysisResource == null) continue;
            this.unregisterResourceInCrossReferencer(analysisResource);
        }
        ArrayList resources = Lists.newArrayList((Iterable)resourceSet.getResources());
        for (Resource resource : Iterables.filter((Iterable)resources, (Predicate)new ResourceFileExtensionPredicate("odesign", false))) {
            this.unregisterResourceInCrossReferencer(resource);
        }
    }

    protected void reenableECrossReferenceAdaptersBeforeEndOfClosing() {
        ResourceSet resourceSet = this.getTransactionalEditingDomain().getResourceSet();
        Adapter existingAirDCrossReferenceAdapter = EcoreUtil.getExistingAdapter((Notifier)resourceSet, AirDCrossReferenceAdapter.class);
        AirDCrossReferenceAdapter airDCrossReferenceAdapter = null;
        if (existingAirDCrossReferenceAdapter instanceof AirDCrossReferenceAdapter) {
            airDCrossReferenceAdapter = (AirDCrossReferenceAdapter)existingAirDCrossReferenceAdapter;
            airDCrossReferenceAdapter.enableResolve();
        }
        if (this.getSemanticCrossReferencer() instanceof LazyCrossReferencer) {
            ((LazyCrossReferencer)this.getSemanticCrossReferencer()).enableResolve();
        }
    }

    private void flushOperations() {
        CommandStack commandStack = this.transactionalEditingDomain.getCommandStack();
        ResourceSet resourceSet = this.transactionalEditingDomain.getResourceSet();
        if (commandStack != null) {
            if (commandStack instanceof IWorkspaceCommandStack) {
                IWorkspaceCommandStack workspaceCommandStack = (IWorkspaceCommandStack)commandStack;
                for (Resource resource : new ArrayList(resourceSet.getResources())) {
                    workspaceCommandStack.getOperationHistory().dispose((IUndoContext)new ResourceUndoContext(this.transactionalEditingDomain, resource), true, true, true);
                }
            }
            commandStack.flush();
        }
    }

    protected void doDisposePermissionAuthority(ResourceSet resourceSet) {
        PermissionAuthorityRegistry.getDefault().getPermissionAuthority(resourceSet).dispose(resourceSet);
    }

    private void unloadResource() {
        for (DAnalysis analysis : Iterables.filter(this.allAnalyses(), (Predicate)Predicates.notNull())) {
            Resource resource = analysis.eResource();
            if (resource == null) continue;
            if (resource.getResourceSet() != null) {
                resource.unload();
            }
            this.transactionalEditingDomain.getResourceSet().getResources().remove((Object)resource);
        }
        for (Resource resource : super.getResources()) {
            if (this.couldBeUnload(this.transactionalEditingDomain.getResourceSet(), resource)) {
                resource.unload();
            }
            this.transactionalEditingDomain.getResourceSet().getResources().remove((Object)resource);
        }
        for (Resource res : this.getSemanticResources()) {
            if (res.getResourceSet() != null && this.couldBeUnload(res.getResourceSet(), res)) {
                res.unload();
            }
            this.transactionalEditingDomain.getResourceSet().getResources().remove((Object)res);
        }
        for (Resource res : super.getControlledResources()) {
            if (res.getResourceSet() != null && this.couldBeUnload(res.getResourceSet(), res)) {
                res.unload();
            }
            this.transactionalEditingDomain.getResourceSet().getResources().remove((Object)res);
        }
        super.getAnalyses().clear();
        super.getResources().clear();
        super.getControlledResources().clear();
    }

    @Override
    public void modelerDesciptionFilesLoaded() {
        if (!Movida.isEnabled()) {
            ArrayList allResources = Lists.newArrayList((Iterable)this.transactionalEditingDomain.getResourceSet().getResources());
            for (Resource res : Iterables.filter((Iterable)allResources, (Predicate)new ResourceFileExtensionPredicate("odesign", true))) {
                if (!res.isModified() && res.isLoaded() && res.getContents().isEmpty()) {
                    this.unregisterResourceInCrossReferencer(res);
                    res.unload();
                }
                IFile correspondingFile = WorkspaceSynchronizer.getFile((Resource)res);
                if (res.isLoaded() || correspondingFile == null || !correspondingFile.exists()) continue;
                try {
                    res.load(Collections.emptyMap());
                    if (!res.isLoaded() || res.getContents().isEmpty()) continue;
                    this.registerResourceInCrossReferencer(res);
                    InterpreterRegistry.prepareImportsFromSession(this.interpreter, this);
                }
                catch (IOException e) {
                    SiriusPlugin.getDefault().warning(MessageFormat.format("Unable to load the VSM at {0}", res.getURI()), e);
                }
            }
        }
        this.notifyListeners(16);
    }

    @Override
    public void registryChanged(org.eclipse.sirius.business.internal.movida.registry.ViewpointRegistry registry, Set<URI> removed, Set<URI> added, Set<URI> changed) {
        this.movidaSupport.registryChanged(registry, removed, added, changed);
    }

    public void setResourceCollector(IResourceCollector collector) {
        this.currentResourceCollector = collector;
    }

    public void setDeferSaveToPostCommit(boolean deferSaveOnPostCommit) {
        this.saver.deferSaveToPostCommit = deferSaveOnPostCommit;
    }

    public boolean isDeferSaveToPostCommit() {
        return this.saver.deferSaveToPostCommit;
    }

    public void setSaveInExclusiveTransaction(boolean saveInExclusiveTransaction) {
        this.saver.saveInExclusiveTransaction = saveInExclusiveTransaction;
    }

    public boolean isSaveInExclusiveTransaction() {
        return this.saver.saveInExclusiveTransaction;
    }

    private final class Saver
    extends ResourceSetListenerImpl {
        private boolean deferSaveToPostCommit;
        private boolean saveInExclusiveTransaction;
        private AtomicBoolean domainDisposed = new AtomicBoolean(false);
        private AtomicBoolean saveOnPostCommit = new AtomicBoolean(false);
        private Map<?, ?> options;
        private IProgressMonitor monitor;
        private TransactionalEditingDomainListener domainListener = new TransactionalEditingDomainListenerImpl(){

            public void transactionClosed(TransactionalEditingDomainEvent event) {
                Saver.this.disarm();
            }

            public void editingDomainDisposing(TransactionalEditingDomainEvent event) {
                Saver.this.domainDisposed.set(true);
            }
        };

        private Saver() {
        }

        public void initialize() {
            TransactionalEditingDomain ted = DAnalysisSessionImpl.this.getTransactionalEditingDomain();
            if (ted instanceof TransactionalEditingDomain.Lifecycle) {
                TransactionalEditingDomain.Lifecycle lc = (TransactionalEditingDomain.Lifecycle)ted;
                lc.addTransactionalEditingDomainListener(this.domainListener);
            }
        }

        public void dispose() {
            TransactionalEditingDomain ted = DAnalysisSessionImpl.this.getTransactionalEditingDomain();
            if (ted instanceof TransactionalEditingDomain.Lifecycle) {
                TransactionalEditingDomain.Lifecycle lc = (TransactionalEditingDomain.Lifecycle)ted;
                lc.removeTransactionalEditingDomainListener(this.domainListener);
            }
            this.disarm();
        }

        public boolean isPostcommitOnly() {
            return true;
        }

        public void resourceSetChanged(ResourceSetChangeEvent event) {
            if (this.saveOnPostCommit.get()) {
                this.saveNow(this.options, this.monitor, true);
            }
        }

        public void save(Map<?, ?> options, IProgressMonitor monitor) {
            boolean tip = this.transactionInProgress();
            if (tip && this.deferSaveToPostCommit) {
                this.saveOnPostCommit(options, monitor);
            } else {
                this.saveNow(options, monitor, this.saveInExclusiveTransaction && !tip && !this.domainDisposed.get());
            }
        }

        private void saveOnPostCommit(Map<?, ?> options, IProgressMonitor monitor) {
            this.options = options;
            this.monitor = monitor;
            this.saveOnPostCommit.set(true);
        }

        private void saveNow(Map<?, ?> options, IProgressMonitor monitor, boolean runExclusive) {
            try {
                DAnalysisSessionImpl.this.doSave(options, monitor, runExclusive);
            }
            finally {
                this.disarm();
            }
        }

        protected void disarm() {
            this.options = null;
            this.monitor = null;
            this.saveOnPostCommit.set(false);
        }

        private boolean transactionInProgress() {
            if (DAnalysisSessionImpl.this.getTransactionalEditingDomain() instanceof InternalTransactionalEditingDomain) {
                InternalTransaction tx = ((InternalTransactionalEditingDomain)DAnalysisSessionImpl.this.getTransactionalEditingDomain()).getActiveTransaction();
                return tx != null;
            }
            return false;
        }
    }
}

