/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session.danalysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.sirius.business.internal.query.DAnalysisesInternalQuery;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.SiriusPlugin;

public class SemanticResourceGetter
extends RunnableWithResult.Impl<Collection<Resource>> {
    private DAnalysisSessionImpl dAnalysisSessionImpl;

    public SemanticResourceGetter(DAnalysisSessionImpl dAnalysisSessionImpl) {
        this.dAnalysisSessionImpl = dAnalysisSessionImpl;
    }

    public void run() {
        LinkedHashSet<Resource> semanticResources = new LinkedHashSet<Resource>();
        if (!this.dAnalysisSessionImpl.isBlocked()) {
            Collection<DAnalysis> allAnalyses = new DAnalysisesInternalQuery((Collection<DAnalysis>)this.dAnalysisSessionImpl.getAnalyses()).getAllAnalyses();
            for (DAnalysis analysis : allAnalyses) {
                if (analysis == null) continue;
                for (EObject model : new ArrayList<EObject>((Collection<EObject>)analysis.getModels())) {
                    if (model == null) continue;
                    try {
                        Resource resource = model.eResource();
                        if (resource == null || this.dAnalysisSessionImpl.getControlledResources().contains((Object)resource)) continue;
                        semanticResources.add(resource);
                    }
                    catch (IllegalStateException illegalStateException) {
                        if (!SiriusPlugin.getDefault().isDebugging()) continue;
                        SiriusPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.sirius", "Error while connecting to remote CDO server"));
                    }
                }
            }
        }
        this.setResult(semanticResources);
    }
}

