/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.unit.tree;

import java.util.Iterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.ecore.extender.business.api.accessor.IMetamodelExtender;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.business.internal.accessor.ecore.EcoreIntrinsicExtender;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.query.legacy.business.internal.interpreter.AcceleoExtendedInterpreter;
import org.eclipse.sirius.tree.business.internal.dialect.common.viewpoint.GlobalContext;
import org.eclipse.sirius.tree.business.internal.dialect.common.viewpoint.MappingBasedPartition;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MappingBasedPartitionTests {
    private GlobalContext ctx;

    @Before
    public void setUp() throws Exception {
        ResourceSetImpl set = new ResourceSetImpl();
        ModelAccessor accessor = new ModelAccessor();
        accessor.addExtender((IMetamodelExtender)new EcoreIntrinsicExtender(), 0);
        accessor.init((ResourceSet)set);
        AcceleoExtendedInterpreter interpreter = new AcceleoExtendedInterpreter();
        this.ctx = new GlobalContext(accessor, (IInterpreter)interpreter, null);
    }

    @Test
    public void orderIsKept() {
        MappingBasedPartition partition = new MappingBasedPartition(this.ctx, "EObject", Options.newSome((Object)"<%eClassifiers%>"), Options.newNone());
        EPackage semanticModel = (EPackage)EcoreUtil.copy((EObject)EcorePackage.eINSTANCE);
        Iterator itTree = partition.evaluate((EObject)semanticModel).elements();
        Iterator itSemContent = semanticModel.getEClassifiers().iterator();
        Assert.assertTrue((boolean)itTree.hasNext());
        Assert.assertTrue((boolean)itSemContent.hasNext());
        while (itSemContent.hasNext()) {
            EObject semantic = (EObject)itSemContent.next();
            Assert.assertSame((Object)semantic, itTree.next());
        }
    }

    @Test
    public void orderIsKeptWithTypeFiltering() {
        MappingBasedPartition partition = new MappingBasedPartition(this.ctx, "EClass", Options.newSome((Object)"<%eClassifiers%>"), Options.newNone());
        EPackage semanticModel = (EPackage)EcoreUtil.copy((EObject)EcorePackage.eINSTANCE);
        Iterator itTree = partition.evaluate((EObject)semanticModel).elements();
        Iterator itSemContent = semanticModel.getEClassifiers().iterator();
        Assert.assertTrue((boolean)itTree.hasNext());
        Assert.assertTrue((boolean)itSemContent.hasNext());
        while (itSemContent.hasNext()) {
            EObject semantic = (EObject)itSemContent.next();
            if (!(semantic instanceof EClass)) continue;
            Assert.assertSame((Object)semantic, itTree.next());
        }
    }
}

