/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools;

import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.sirius.common.tools.api.editing.EditingDomainFactoryRegistry;
import org.eclipse.sirius.common.tools.api.profiler.TimeProfiler;
import org.eclipse.sirius.common.tools.api.profiler.TimeProfiler2;
import org.eclipse.sirius.common.tools.internal.assist.ProposalProviderRegistry;
import org.eclipse.sirius.common.tools.internal.assist.ProposalProviderRegistryListener;
import org.eclipse.sirius.common.tools.internal.ecore.DynamicPackageRegistryReader;
import org.eclipse.sirius.common.tools.internal.editing.EditingDomainFactoryRegistryListener;
import org.osgi.framework.BundleContext;

public class DslCommonPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.sirius.common";
    public static final TimeProfiler PROFILER = new TimeProfiler2();
    private static DslCommonPlugin plugin;
    private EditingDomainFactoryRegistryListener editingDomainFactoryRegistryListener = new EditingDomainFactoryRegistryListener();
    private final ProposalProviderRegistryListener proposalProviderRegistryListener = new ProposalProviderRegistryListener();

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.initExtensionRegistries();
        new DynamicPackageRegistryReader().readRegistry();
    }

    private void initExtensionRegistries() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.addRegistryChangeListener((IRegistryChangeListener)this.editingDomainFactoryRegistryListener, "org.eclipse.sirius.common.editingDomainFactory");
        this.editingDomainFactoryRegistryListener.parseInitialContributions();
        registry.addListener((IRegistryEventListener)this.proposalProviderRegistryListener, "org.eclipse.sirius.common.proposalProvider");
        this.proposalProviderRegistryListener.parseInitialContributions();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
        this.clearExtensionRegistries();
    }

    private void clearExtensionRegistries() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.removeRegistryChangeListener((IRegistryChangeListener)this.editingDomainFactoryRegistryListener);
        EditingDomainFactoryRegistry.clearRegistry();
        registry.removeListener((IRegistryEventListener)this.proposalProviderRegistryListener);
        ProposalProviderRegistry.clearRegistry();
    }

    public static DslCommonPlugin getDefault() {
        return plugin;
    }

    public void error(String message, Throwable t) {
        Status status = new Status(4, PLUGIN_ID, message, t);
        this.getLog().log((IStatus)status);
    }

    public void warning(String message, Throwable t) {
        Status status = new Status(2, PLUGIN_ID, message, t);
        this.getLog().log((IStatus)status);
    }

    public void info(String message) {
        Status status = new Status(1, PLUGIN_ID, message);
        this.getLog().log((IStatus)status);
    }
}

