/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.resource;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocument;
import org.eclipse.gmf.runtime.emf.core.resources.GMFResourceFactory;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.tools.api.util.GMFNotationHelper;
import org.eclipse.ui.IEditorInput;

public class ResourceMissingDocumentProvider {
    private static final String DEFAULT_NOTE_MESSAGE = "This diagram was not saved. You can close the editor";
    private ResourceSet errorResourceSet;
    private Resource errorResource;
    private Diagram errorDiagram;

    public void setDocumentContent(IDocument document, IEditorInput element) {
        document.setContent((Object)this.getErrorDiagram(DEFAULT_NOTE_MESSAGE));
    }

    public void setDocumentContent(IDocument document, IEditorInput element, String noteMessage) {
        document.setContent((Object)this.getErrorDiagram(noteMessage));
    }

    private Diagram getErrorDiagram(String noteMessage) {
        if (this.errorDiagram == null) {
            this.errorResourceSet = new ResourceSetImpl();
            TransactionalEditingDomain domain = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain(this.errorResourceSet);
            this.errorResource = new GMFResourceFactory().createResource(URI.createURI((String)"error://diagram"));
            this.errorResourceSet.getResources().add((Object)this.errorResource);
            this.errorDiagram = NotationFactory.eINSTANCE.createDiagram();
            domain.getCommandStack().execute((Command)new AddErrorCommand(domain, this.errorDiagram, this.errorResource, noteMessage));
        }
        return this.errorDiagram;
    }

    public void dispose() {
        if (this.errorResourceSet != null) {
            TransactionUtil.getEditingDomain((ResourceSet)this.errorResourceSet).dispose();
            this.errorResource = null;
            this.errorDiagram = null;
        }
    }

    private class AddErrorCommand
    extends RecordingCommand {
        private final Diagram diagram;
        private final String noteMessage;
        private final Resource resource;

        public AddErrorCommand(TransactionalEditingDomain domain, Diagram diagram, Resource resource, String noteMessage) {
            super(domain, "Navigate to another representation");
            this.diagram = diagram;
            this.resource = resource;
            this.noteMessage = noteMessage;
        }

        protected void doExecute() {
            if (ResourceMissingDocumentProvider.this.errorResource == null || this.diagram == null) {
                return;
            }
            this.resource.getContents().add((Object)this.diagram);
            GMFNotationHelper.createNote(this.diagram, this.noteMessage, DiagramUIPlugin.getPlugin().getPreferenceStore());
        }
    }
}

