/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.dialect.identifier;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.dialect.identifier.AbstractRepresentationElementIdentifier;
import org.eclipse.sirius.common.tools.api.util.EqualityHelper;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.business.internal.dialect.identifier.NodeIdentifier;

public class EdgeIdentifier
extends AbstractRepresentationElementIdentifier {
    private EObject semantic;
    private String mappingName;
    private NodeIdentifier source;
    private NodeIdentifier target;

    public EdgeIdentifier(DEdge edge, NodeIdentifier source, NodeIdentifier target) {
        this(edge.getTarget(), edge.getMapping().getName(), source, target);
    }

    public EdgeIdentifier(EObject semantic, String mappingName, NodeIdentifier source, NodeIdentifier target) {
        if (semantic == null || mappingName == null || source == null || target == null) {
            throw new IllegalArgumentException("semantic, mappingName, source and target are mandatories");
        }
        this.semantic = semantic;
        this.mappingName = mappingName;
        this.source = source;
        this.target = target;
    }

    public int uniqueID() {
        int result = 1;
        result = 31 * result + (this.mappingName == null ? 0 : this.mappingName.hashCode());
        result = 31 * result + (this.semantic == null ? 0 : this.semantic.hashCode());
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        EdgeIdentifier other = (EdgeIdentifier)((Object)obj);
        if (this.mappingName == null ? other.mappingName != null : !this.mappingName.equals(other.mappingName)) {
            return false;
        }
        if (this.semantic == null ? other.semantic != null : !EqualityHelper.areEquals((EObject)this.semantic, (EObject)other.semantic)) {
            return false;
        }
        if (this.source == null ? other.source != null : !this.source.equals(other.source)) {
            return false;
        }
        return !(this.target == null ? other.target != null : !this.target.equals(other.target));
    }
}

