/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.business.internal.refresh;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.table.business.internal.refresh.KeyCache;
import org.eclipse.sirius.table.metamodel.table.DTargetColumn;
import org.eclipse.sirius.table.metamodel.table.description.ColumnMapping;

public class DTargetColumnCandidate {
    private final EObject semantic;
    private final ColumnMapping mapping;
    private DTargetColumn element;
    private final URI semanticURI;
    private final int hashCode;

    public DTargetColumnCandidate(ColumnMapping mapping, EObject semanticElement) {
        this.mapping = mapping;
        this.semantic = semanticElement;
        this.semanticURI = this.semantic != null ? EcoreUtil.getURI((EObject)this.semantic) : null;
        this.hashCode = this.computeHashCode();
    }

    public DTargetColumnCandidate(DTargetColumn tableElement) {
        this.mapping = tableElement.getOriginMapping();
        this.semantic = tableElement.getTarget();
        this.element = tableElement;
        this.semanticURI = this.semantic != null ? EcoreUtil.getURI((EObject)this.semantic) : null;
        this.hashCode = this.computeHashCode();
    }

    public boolean comesFromTableElement() {
        return this.getOriginalElement() != null;
    }

    public DTargetColumn getOriginalElement() {
        return this.element;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        return KeyCache.DEFAULT.getKey(String.valueOf(this.mapping != null ? this.mapping.getName() : "") + this.semanticURI);
    }

    public boolean equals(Object obj) {
        Boolean result = null;
        if (this == obj) {
            result = true;
        }
        if (result == null && obj == null) {
            result = false;
        }
        if (result == null && !(obj instanceof DTargetColumnCandidate)) {
            result = false;
        }
        DTargetColumnCandidate other = (DTargetColumnCandidate)obj;
        if (result == null && this.mapping == null) {
            if (other.mapping != null) {
                result = false;
            }
        } else if (result == null && !this.mapping.getName().equals(other.mapping.getName())) {
            result = false;
        }
        if (result == null && this.semantic == null) {
            if (other.semantic != null) {
                result = false;
            }
        } else if (result == null && !this.semanticURI.equals((Object)other.semanticURI)) {
            result = false;
        }
        if (result == null) {
            result = true;
        }
        return result;
    }

    public ColumnMapping getMapping() {
        return this.mapping;
    }

    public EObject getSemantic() {
        return this.semantic;
    }
}

