/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.swtbot.support.internal.business;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import org.eclipse.sirius.tests.swtbot.support.api.business.UILocalSession;
import org.eclipse.sirius.tests.swtbot.support.api.business.UIProject;
import org.eclipse.sirius.tests.swtbot.support.api.business.UIResource;
import org.eclipse.sirius.tests.swtbot.support.api.business.UISessionCreationWizardFlow;
import org.eclipse.sirius.tests.swtbot.support.api.condition.ItemEnabledCondition;
import org.eclipse.sirius.tests.swtbot.support.api.dialog.ViewpointSelectionDialog;
import org.eclipse.sirius.tests.swtbot.support.api.widget.WrappedSWTBotRadio;
import org.eclipse.sirius.tests.swtbot.support.utils.SWTBotUtils;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.swt.finder.waits.Conditions;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotRadio;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;

public class UISessionCreationWizard
implements UISessionCreationWizardFlow.SessionChoice {
    private static final String DEFAULT_SESSION_NAME = "representations";
    private final UISessionCreationWizardFlow.AirdPickingChoice airdPickingChoice = new UISessionCreationWizardFlow.AirdPickingChoice(){

        @Override
        public UISessionCreationWizardFlow.WizardOk select(UIResource res) {
            UISessionCreationWizard.this.sessionResource = res;
            return UISessionCreationWizard.this.wizardOK;
        }

        @Override
        public UISessionCreationWizardFlow.WizardOk withDefaultSessionName() {
            UISessionCreationWizard.this.withDefaultSessionName();
            return UISessionCreationWizard.this.wizardOK;
        }

        @Override
        public UILocalSession withDefaultSessionNameWithoutViewpointSelection() {
            UISessionCreationWizard.this.withDefaultSessionName();
            UISessionCreationWizard.this.bot.tree().getAllItems()[0].select();
            SWTBotButton button = UISessionCreationWizard.this.bot.button("Finish");
            SWTBotShell dialogShell = UISessionCreationWizard.this.bot.activeShell();
            UISessionCreationWizard.this.bot.waitUntil((ICondition)new ItemEnabledCondition((AbstractSWTBot<? extends Widget>)button));
            button.click();
            UISessionCreationWizard.this.bot.waitUntil(Conditions.shellCloses((SWTBotShell)dialogShell));
            UISessionCreationWizard.this.sessionResource = new UIResource(UISessionCreationWizard.this.uiProject, "representations.aird");
            return new UILocalSession(UISessionCreationWizard.this.getSessionResource());
        }
    };
    private final SWTWorkbenchBot bot;
    private UIResource modelResource;
    private ViewpointSelectionDialog selectionDialog;
    private final UISessionCreationWizardFlow.SemanticModelPage semanticModelPage = new UISessionCreationWizardFlow.SemanticModelPage(){

        @Override
        public UISessionCreationWizardFlow.AirdPickingChoice select(UIResource res) {
            UISessionCreationWizard.this.sessionResource = res;
            return UISessionCreationWizard.this.airdPickingChoice;
        }
    };
    private String sessionName;
    private UIResource sessionResource;
    private UIProject uiProject;
    private final UISessionCreationWizardFlow.VpSelectionAfterWizard vpSelection = new UISessionCreationWizardFlow.VpSelectionAfterWizard(){

        @Override
        public UILocalSession selectNoViewpoint() {
            UISessionCreationWizard.this.selectNoViewpoint();
            UILocalSession lSession = UISessionCreationWizard.this.finish();
            return lSession;
        }

        @Override
        public UILocalSession selectViewpoints(String ... vps) {
            UISessionCreationWizard.this.selectViewpoints(Sets.newHashSet((Object[])vps));
            UILocalSession lSession = UISessionCreationWizard.this.finish();
            return lSession;
        }
    };
    private final UISessionCreationWizardFlow.WizardOk wizardOK = new UISessionCreationWizardFlow.WizardOk(){

        @Override
        public UISessionCreationWizardFlow.VpSelectionAfterWizard finish() {
            return UISessionCreationWizard.this.vpSelection;
        }
    };
    private SWTBotShell wizardShell;

    public UISessionCreationWizard() {
        this.bot = new SWTWorkbenchBot();
    }

    public UISessionCreationWizard(UIResource pUIResource) {
        this();
        this.modelResource = pUIResource;
        this.selectionDialog = new ViewpointSelectionDialog(this.bot);
        this.wizardShell = this.bot.shell("New Representations File");
    }

    @Override
    public UISessionCreationWizardFlow.AirdPickingChoice emptySession() {
        SWTBotRadio emptySessionRadioButton = this.bot.radio(0);
        emptySessionRadioButton = new WrappedSWTBotRadio(emptySessionRadioButton);
        emptySessionRadioButton.click();
        SWTBotButton button = this.bot.button("Next >");
        this.bot.waitUntil((ICondition)new ItemEnabledCondition((AbstractSWTBot<? extends Widget>)button));
        button.click();
        return this.airdPickingChoice;
    }

    public UILocalSession finish() {
        this.bot.waitUntil(Conditions.shellCloses((SWTBotShell)this.wizardShell));
        return new UILocalSession(this.getModelResource(), this.getSessionResource());
    }

    @Override
    public UISessionCreationWizardFlow.AirdPickingChoice fromAlreadySelectedSemanticResource() {
        new WrappedSWTBotRadio(this.bot.radio("Initialization from a semantic resource")).click();
        SWTBotButton button = this.bot.button("Finish");
        this.bot.waitUntil((ICondition)new ItemEnabledCondition((AbstractSWTBot<? extends Widget>)button));
        button.click();
        SWTBotUtils.waitProgressMonitorClose("New Representations File");
        return this.airdPickingChoice;
    }

    @Override
    public UISessionCreationWizardFlow.SemanticModelPage fromSemanticResource() {
        return this.semanticModelPage;
    }

    public UIResource getModelResource() {
        return this.modelResource;
    }

    public UIResource getSessionResource() {
        if (this.sessionResource == null) {
            UIProject project = this.uiProject;
            if (project == null) {
                project = this.modelResource.getProject();
            }
            this.sessionResource = new UIResource(project, this.modelResource.getPath(), String.valueOf(this.sessionName) + "." + "aird");
        }
        return this.sessionResource;
    }

    @Override
    public UISessionCreationWizard in(UIProject pUiProject) {
        this.uiProject = pUiProject;
        return this;
    }

    public UISessionCreationWizard selectNoViewpoint() {
        return this.selectViewpoints(Collections.<String>emptySet());
    }

    public UISessionCreationWizard selectViewpoint(String viewpointToSelect) {
        return this.selectViewpoints(Collections.singleton(viewpointToSelect));
    }

    public UISessionCreationWizard selectViewpoints(Set<String> viewpointsToSelect) {
        this.selectionDialog.selectViewpoint(viewpointsToSelect, Collections.<String>emptySet());
        return this;
    }

    public UISessionCreationWizard withDefaultSessionName() {
        if (this.modelResource == null) {
            this.sessionName = DEFAULT_SESSION_NAME;
        } else {
            int dotPos = this.modelResource.getName().lastIndexOf(46);
            if (dotPos > -1) {
                this.sessionName = this.modelResource.getName().substring(0, dotPos);
            }
        }
        return this;
    }

    public UISessionCreationWizard withSessionName(String name) {
        this.sessionName = name;
        return this;
    }
}

