/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.business.internal.dialect.common.tree;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.synchronizer.CreatedOutput;
import org.eclipse.sirius.synchronizer.Mapping;
import org.eclipse.sirius.synchronizer.MappingHiearchyTable;
import org.eclipse.sirius.synchronizer.ModelToModelSynchronizer;
import org.eclipse.sirius.synchronizer.PreRefreshStatus;
import org.eclipse.sirius.synchronizer.SemanticPartitionInvalidator;
import org.eclipse.sirius.synchronizer.SignatureProvider;
import org.eclipse.sirius.tree.DTree;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.DTreeItemContainer;
import org.eclipse.sirius.tree.business.internal.dialect.common.tree.CreatedDTree;
import org.eclipse.sirius.tree.business.internal.dialect.common.tree.CreatedTreeItem;
import org.eclipse.sirius.tree.business.internal.dialect.common.tree.DTreePreRefreshStatus;
import org.eclipse.sirius.tree.business.internal.dialect.common.tree.OutputDTreeDescriptor;
import org.eclipse.sirius.tree.business.internal.dialect.common.tree.OutputTreeItemDescriptor;
import org.eclipse.sirius.tree.business.internal.dialect.common.tree.SemanticPartitionProvider;
import org.eclipse.sirius.tree.business.internal.dialect.common.tree.TreeMappingProvider;
import org.eclipse.sirius.tree.business.internal.dialect.common.tree.TreeSignatureProvider;
import org.eclipse.sirius.tree.business.internal.dialect.common.viewpoint.GlobalContext;
import org.eclipse.sirius.tree.description.TreeItemMapping;

public class DTreeRefresh {
    private DTreeItemContainer container;
    private SemanticPartitionInvalidator invalidator;
    private Iterable<? extends TreeItemMapping> mappings;
    private GlobalContext ctx;

    public DTreeRefresh(DTreeItemContainer tree, Iterable<? extends TreeItemMapping> mappings, SemanticPartitionInvalidator invalidator, GlobalContext ctx) {
        this.container = tree;
        this.invalidator = invalidator;
        this.ctx = ctx;
        this.mappings = mappings;
    }

    public void refresh(IProgressMonitor monitor) {
        this.refresh(false, monitor);
    }

    public void refresh(boolean fullRefresh, IProgressMonitor monitor) {
        try {
            monitor.beginTask("Refresh tree", 4);
            if (this.ctx.getModelAccessor().getPermissionAuthority().canEditInstance((EObject)this.container)) {
                MappingHiearchyTable hierarchy = new MappingHiearchyTable();
                TreeSignatureProvider signProvider = new TreeSignatureProvider(hierarchy);
                SemanticPartitionProvider semProvider = new SemanticPartitionProvider(this.ctx);
                final TreeMappingProvider provider = new TreeMappingProvider(semProvider);
                Iterable providedMappings = Iterables.transform(this.mappings, (Function)new Function<TreeItemMapping, Mapping>(){

                    public Mapping apply(TreeItemMapping from) {
                        return provider.getOrCreate(from);
                    }
                });
                monitor.worked(1);
                hierarchy.compute((Collection)Lists.newArrayList((Iterable)providedMappings));
                monitor.worked(1);
                DTreePreRefreshStatus pre = new DTreePreRefreshStatus(this.ctx, provider);
                ModelToModelSynchronizer refresher = new ModelToModelSynchronizer(this.invalidator, hierarchy, (PreRefreshStatus)pre, (SignatureProvider)signProvider);
                CreatedOutput cDiag = this.buildOutput(provider);
                monitor.worked(1);
                refresher.update(cDiag, fullRefresh);
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
    }

    private CreatedOutput buildOutput(TreeMappingProvider provider) {
        if (this.container instanceof DTree) {
            DTree tree = (DTree)this.container;
            OutputDTreeDescriptor existingDTree = new OutputDTreeDescriptor(tree.getTarget(), tree.getDescription(), provider);
            CreatedDTree cDiag = new CreatedDTree(this.ctx, tree, existingDTree);
            return cDiag;
        }
        if (this.container instanceof DTreeItem) {
            DTreeItem item = (DTreeItem)this.container;
            DTreeItemContainer treeItemcontainer = item.getContainer();
            OutputTreeItemDescriptor descriptor = new OutputTreeItemDescriptor(treeItemcontainer, item.getTarget(), item.getActualMapping(), 0, provider);
            CreatedTreeItem created = new CreatedTreeItem(this.ctx, item, descriptor);
            return created;
        }
        throw new RuntimeException("Unkown representation container instance");
    }
}

