/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.views;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.progress.UIJob;

public class RefreshLabelImageJob
extends UIJob {
    public static final String FAMILY = RefreshLabelImageJob.class.getName();
    public static final long REFRESH_JOB_DELAY = 200L;
    private final String[] refreshProperties = new String[]{"org.eclipse.jface.image"};
    private Collection<Object> elementsToRefresh = Collections.emptySet();
    private CommonNavigator view;

    public RefreshLabelImageJob(CommonNavigator view, Collection<Object> elementsToRefresh) {
        super("Refreshing lock decorations");
        this.view = view;
        this.elementsToRefresh = elementsToRefresh;
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        if (this.view.getCommonViewer() != null) {
            if (this.elementsToRefresh == null || this.elementsToRefresh.isEmpty()) {
                this.view.getCommonViewer().refresh();
            } else {
                CommonViewer commonViewer = this.view.getCommonViewer();
                commonViewer.update(this.elementsToRefresh.toArray(), this.refreshProperties);
            }
        }
        if (this.elementsToRefresh != null) {
            this.elementsToRefresh.clear();
        }
        return Status.OK_STATUS;
    }

    public Collection<?> getElementsToRefresh() {
        return this.elementsToRefresh;
    }

    public boolean belongsTo(Object family) {
        return FAMILY.equals(family);
    }
}

