/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.helper;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.query.FileQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.description.Group;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public final class SiriusUtil {
    public static final String SESSION_RESOURCE_EXTENSION = "aird";
    public static final String DESCRIPTION_MODEL_EXTENSION = "odesign";

    private SiriusUtil() {
    }

    public static boolean isModelerDescriptionFile(Resource resource) {
        if (resource.getURI() != null && resource.getURI().fileExtension() != null) {
            return new FileQuery(resource.getURI().fileExtension()).isVSMFile();
        }
        return false;
    }

    public static DSemanticDecorator getNearestDecorateSemanticElement(EObject eObject) {
        DSemanticDecorator result = null;
        EObject eObj = eObject;
        while (result == null && eObj != null) {
            if (eObj instanceof DSemanticDecorator) {
                result = (DSemanticDecorator)eObj;
            }
            eObj = eObj.eContainer();
        }
        return result;
    }

    public static Group getGroupByName(ResourceSet resourceSet, String name) {
        Group result = null;
        Iterator iterResources = resourceSet.getResources().iterator();
        while (iterResources.hasNext() && result == null) {
            Resource currentResource = (Resource)iterResources.next();
            Iterator iterContents = currentResource.getContents().iterator();
            while (iterContents.hasNext() && result == null) {
                Group group;
                Object currentRoot = iterContents.next();
                if (!(currentRoot instanceof Group) || (group = (Group)currentRoot).getName() == null || !group.getName().equals(name)) continue;
                result = group;
            }
        }
        return result;
    }

    public static DView findView(DRepresentationElement element) {
        DRepresentationElement current = element;
        while (current != null) {
            if (current instanceof DView) {
                return (DView)((Object)current);
            }
            current = current.eContainer();
        }
        return null;
    }

    public static DRepresentation findRepresentation(DRepresentationElement element) {
        DRepresentationElement current = element;
        while (current != null) {
            if (current instanceof DRepresentation) {
                return (DRepresentation)((Object)current);
            }
            current = current.eContainer();
        }
        return null;
    }

    public static boolean isFromSirius(Object ep) {
        if (ep != null) {
            String packageName = ep.getClass().getPackage().getName();
            return packageName.startsWith("org.eclipse.sirius");
        }
        return false;
    }

    public static boolean hasAlreadyResource(ResourceSet resourceSet, URI uri) {
        boolean result = false;
        for (Resource resource : resourceSet.getResources()) {
            if (uri == null || !uri.equals((Object)resource.getURI())) continue;
            result = true;
        }
        return result;
    }

    public static Viewpoint findViewpoint(Resource resource, String viewpointName) {
        if (resource.getContents() != null && !resource.getContents().isEmpty()) {
            Iterator<Viewpoint> it = SiriusUtil.getViewpoints(resource);
            while (it.hasNext()) {
                Viewpoint editingDomainViewpoint = it.next();
                if ((viewpointName != null || editingDomainViewpoint.getName() != null) && (viewpointName == null || !viewpointName.equals(editingDomainViewpoint.getName()))) continue;
                return editingDomainViewpoint;
            }
        }
        return null;
    }

    public static void delete(EObject eObject) {
        SiriusUtil.delete(eObject, null);
    }

    public static void delete(EObject eObject, Session session) {
        Session currentEObjectSession = session;
        if (currentEObjectSession == null) {
            EObject model;
            EObject semanticRootElement = EcoreUtil.getRootContainer((EObject)eObject);
            if (semanticRootElement instanceof DAnalysis && (model = (EObject)Iterables.getFirst(((DAnalysis)semanticRootElement).getModels(), null)) != null) {
                semanticRootElement = model;
            }
            currentEObjectSession = SessionManager.INSTANCE.getSession(semanticRootElement);
        }
        if (currentEObjectSession != null) {
            Collection usages = currentEObjectSession.getSemanticCrossReferencer().getInverseReferences(eObject);
            for (EStructuralFeature.Setting setting : usages) {
                if (!setting.getEStructuralFeature().isChangeable()) continue;
                EcoreUtil.remove((EStructuralFeature.Setting)setting, (Object)eObject);
            }
            EcoreUtil.remove((EObject)eObject);
        } else {
            EcoreUtil.delete((EObject)eObject);
        }
    }

    private static Iterator<Viewpoint> getViewpoints(Resource resource) {
        if (DESCRIPTION_MODEL_EXTENSION.equals(resource.getURI().fileExtension())) {
            ArrayList result = Lists.newArrayList();
            for (Group group : Iterables.filter((Iterable)resource.getContents(), Group.class)) {
                result.addAll(group.getOwnedViewpoints());
            }
            return result.iterator();
        }
        return Iterators.filter((Iterator)resource.getAllContents(), Viewpoint.class);
    }
}

