/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.resource.parser;

import java.io.IOException;
import org.eclipse.emf.ecore.xmi.impl.XMLContentHandlerImpl;
import org.eclipse.sirius.business.internal.resource.parser.XMIModelFileSaxParserNormalAbortException;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMIModelFileHandler
extends DefaultHandler {
    private boolean firstElementRead;
    private boolean canLoad;

    public boolean isLoadable() {
        return this.canLoad;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        boolean isXMI;
        if (this.firstElementRead) {
            throw new XMIModelFileSaxParserNormalAbortException("All needed informations have been reached. Stop the parsing.");
        }
        this.firstElementRead = true;
        this.canLoad = isXMI = this.lookForXMI(attributes);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.firstElementRead) {
            throw new XMIModelFileSaxParserNormalAbortException("All needed informations have been reached. Stop the parsing.");
        }
        super.endElement(uri, localName, qName);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        throw new XMIModelFileSaxParserNormalAbortException("We try to access external elements. Stop the parsing.");
    }

    private boolean lookForXMI(Attributes attributes) {
        int i = 0;
        while (i < attributes.getLength()) {
            String value;
            String attributeName = attributes.getQName(i);
            if (attributeName.startsWith("xmlns") && !StringUtil.isEmpty((String)(value = attributes.getValue(i))) && XMLContentHandlerImpl.XMI.isXMINamespace((String)value)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

