/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session.danalysis;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.internal.query.DAnalysisesInternalQuery;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;
import org.eclipse.sirius.business.internal.session.danalysis.SemanticResourceGetter;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.ViewpointPackage;

public class SemanticResourcesUpdater
extends AdapterImpl
implements Adapter {
    private DAnalysisSessionImpl dAnalysisSessionImpl;
    private Collection<Resource> semanticResources;
    private Map<String, EObject> resourceToRootEObjectMap = Maps.newHashMap();

    public SemanticResourcesUpdater(DAnalysisSessionImpl dAnalysisSessionImpl) {
        this.dAnalysisSessionImpl = dAnalysisSessionImpl;
    }

    public void setSemanticResources(Collection<Resource> semanticResources) {
        Collection<DAnalysis> allAnalyses = new DAnalysisesInternalQuery((Collection<DAnalysis>)this.dAnalysisSessionImpl.getAnalyses()).getAllAnalyses();
        for (DAnalysis dAnalysis : allAnalyses) {
            if (dAnalysis.eAdapters().contains((Object)this)) continue;
            dAnalysis.eAdapters().add((Object)this);
        }
        this.semanticResources = semanticResources;
    }

    public void notifyChanged(Notification msg) {
        if (!(msg.isTouch() || msg.getFeature() != ViewpointPackage.Literals.DANALYSIS_SESSION_EOBJECT__ANALYSES && msg.getFeature() != ViewpointPackage.Literals.DANALYSIS__REFERENCED_ANALYSIS && msg.getFeature() != ViewpointPackage.Literals.DANALYSIS_SESSION_EOBJECT__ANALYSES && msg.getFeature() != ViewpointPackage.Literals.DANALYSIS__MODELS && msg.getFeature() != ViewpointPackage.Literals.DANALYSIS_SESSION_EOBJECT__CONTROLLED_RESOURCES)) {
            if (msg.getFeature() == ViewpointPackage.Literals.DANALYSIS__MODELS) {
                int eventType = msg.getEventType();
                if (eventType == 3 || eventType == 5) {
                    this.addAssociatedResource(msg.getNewValue());
                } else if (eventType == 4 || eventType == 6) {
                    this.removeAssociatedResource(msg.getOldValue());
                }
            }
            SemanticResourceGetter semanticResourcesGetter = new SemanticResourceGetter(this.dAnalysisSessionImpl);
            semanticResourcesGetter.run();
            boolean hasNbOfSemanticResourcesChanged = this.semanticResources.size() != ((Collection)semanticResourcesGetter.getResult()).size();
            this.semanticResources.clear();
            this.semanticResources.addAll((Collection)semanticResourcesGetter.getResult());
            if (hasNbOfSemanticResourcesChanged) {
                this.dAnalysisSessionImpl.transfertNotification(11);
            }
        }
    }

    private void addAssociatedResource(Object value) {
        if (value instanceof EObject) {
            Resource eResource = ((EObject)value).eResource();
            if (eResource != null) {
                this.resourceToRootEObjectMap.put(eResource.getURI().toString(), (EObject)value);
            }
        } else if (value instanceof EList) {
            EList eListNotifier = (EList)value;
            for (Object object : eListNotifier) {
                this.addAssociatedResource(object);
            }
        }
    }

    private void removeAssociatedResource(Object value) {
        block2: {
            block3: {
                if (!(value instanceof EObject)) break block3;
                for (String resource : this.resourceToRootEObjectMap.keySet()) {
                    if (!value.equals(this.resourceToRootEObjectMap.get(resource))) continue;
                    this.resourceToRootEObjectMap.remove(resource);
                    break block2;
                }
                break block2;
            }
            if (!(value instanceof EList)) break block2;
            EList eListNotifier = (EList)value;
            for (Object object : eListNotifier) {
                this.removeAssociatedResource(object);
            }
        }
    }

    public EObject getRootObjectFromResourceURI(String resourceURI) {
        return this.resourceToRootEObjectMap.get(resourceURI);
    }

    public void dispose() {
        Collection<DAnalysis> allAnalyses = new DAnalysisesInternalQuery((Collection<DAnalysis>)this.dAnalysisSessionImpl.getAnalyses()).getAllAnalyses();
        for (DAnalysis dAnalysis : allAnalyses) {
            if (!dAnalysis.eAdapters().contains((Object)this)) continue;
            dAnalysis.eAdapters().remove((Object)this);
        }
        this.dAnalysisSessionImpl = null;
        this.semanticResources = null;
        this.resourceToRootEObjectMap.clear();
    }
}

