/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tools.api.command.semantic;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;
import org.eclipse.sirius.viewpoint.DAnalysisSessionEObject;

public class RemoveSemanticResourceCommand
extends RecordingCommand {
    protected Session session;
    protected Resource semanticResource;
    protected boolean removeCrossReferencedResources;
    protected boolean removeFromControlledResources;
    private boolean removeReferencingResources;
    private IProgressMonitor monitor;

    public RemoveSemanticResourceCommand(Session session, Resource semanticResource, boolean removeFromControlledResources, IProgressMonitor monitor) {
        this(session, semanticResource, removeFromControlledResources, monitor, true);
    }

    public RemoveSemanticResourceCommand(Session session, Resource semanticResource, boolean removeFromControlledResources, IProgressMonitor monitor, boolean removeReferencingResources) {
        super(session.getTransactionalEditingDomain(), "Remove model");
        this.semanticResource = semanticResource;
        this.session = session;
        this.removeFromControlledResources = removeFromControlledResources;
        this.monitor = monitor;
        this.removeReferencingResources = removeReferencingResources;
    }

    protected void doExecute() {
        if (this.monitor == null) {
            this.monitor = new NullProgressMonitor();
        }
        if (this.semanticResource != null && this.session != null) {
            ArrayList<Resource> semanticResources = new ArrayList<Resource>(this.session.getSemanticResources());
            if (this.session instanceof DAnalysisSessionImpl) {
                semanticResources.addAll((Collection<Resource>)((DAnalysisSessionEObject)((Object)this.session)).getControlledResources());
            }
            if (semanticResources.contains(this.semanticResource)) {
                if (this.session instanceof DAnalysisSessionImpl) {
                    ((DAnalysisSessionImpl)this.session).removeSemanticResource(this.semanticResource, this.monitor, this.removeReferencingResources);
                } else {
                    this.session.removeSemanticResource(this.semanticResource, this.monitor);
                }
            }
        }
    }
}

