/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tools.internal.resource;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.ContentHandler;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.sirius.tools.internal.resource.FileURIHandlerWithProgressMonitorImpl;
import org.eclipse.sirius.tools.internal.resource.PlatformResourceURIHandlerWithProgressMonitorImpl;

public final class ResourceSetUtil {
    private ResourceSetUtil() {
    }

    public static void setProgressMonitor(ResourceSet resourceSet, IProgressMonitor monitor) {
        PlatformResourceURIHandlerWithProgressMonitorImpl platformResourceURIHandlerWithProgressMonitorImpl;
        ArrayList<Object> handlers = new ArrayList<Object>((Collection<Object>)resourceSet.getURIConverter().getURIHandlers());
        FileURIHandlerWithProgressMonitorImpl fileURIHandlerWithProgressMonitorImpl = ResourceSetUtil.getFileURIHandlerWithProgressMonitorImpl(resourceSet);
        if (fileURIHandlerWithProgressMonitorImpl == null) {
            fileURIHandlerWithProgressMonitorImpl = new FileURIHandlerWithProgressMonitorImpl();
            handlers.add(0, (Object)fileURIHandlerWithProgressMonitorImpl);
        }
        if ((platformResourceURIHandlerWithProgressMonitorImpl = ResourceSetUtil.getPlatformResourceURIHandlerWithProgressMonitorImpl(resourceSet)) == null) {
            platformResourceURIHandlerWithProgressMonitorImpl = new PlatformResourceURIHandlerWithProgressMonitorImpl();
            handlers.add(0, (Object)platformResourceURIHandlerWithProgressMonitorImpl);
        }
        platformResourceURIHandlerWithProgressMonitorImpl.setProgressMonitor(monitor);
        resourceSet.setURIConverter((URIConverter)new ExtensibleURIConverterImpl(handlers, (Collection)ContentHandler.Registry.INSTANCE.contentHandlers()));
    }

    public static void resetProgressMonitor(ResourceSet resourceSet) {
        resourceSet.getURIConverter().getURIHandlers().remove((Object)ResourceSetUtil.getFileURIHandlerWithProgressMonitorImpl(resourceSet));
        resourceSet.getURIConverter().getURIHandlers().remove((Object)ResourceSetUtil.getPlatformResourceURIHandlerWithProgressMonitorImpl(resourceSet));
    }

    private static FileURIHandlerWithProgressMonitorImpl getFileURIHandlerWithProgressMonitorImpl(ResourceSet resourceSet) {
        FileURIHandlerWithProgressMonitorImpl fileURIHandlerWithProgressMonitorImpl = null;
        URIConverter uriConverter = resourceSet.getURIConverter();
        if (uriConverter instanceof ExtensibleURIConverterImpl) {
            ExtensibleURIConverterImpl extensibleURIConverterImpl = (ExtensibleURIConverterImpl)uriConverter;
            EList uriHandlers = extensibleURIConverterImpl.getURIHandlers();
            for (URIHandler uriHandler : uriHandlers) {
                if (!(uriHandler instanceof FileURIHandlerWithProgressMonitorImpl)) continue;
                fileURIHandlerWithProgressMonitorImpl = (FileURIHandlerWithProgressMonitorImpl)uriHandler;
                break;
            }
        }
        return fileURIHandlerWithProgressMonitorImpl;
    }

    private static PlatformResourceURIHandlerWithProgressMonitorImpl getPlatformResourceURIHandlerWithProgressMonitorImpl(ResourceSet resourceSet) {
        PlatformResourceURIHandlerWithProgressMonitorImpl platformResourceURIHandlerWithProgressMonitorImpl = null;
        URIConverter uriConverter = resourceSet.getURIConverter();
        if (uriConverter instanceof ExtensibleURIConverterImpl) {
            ExtensibleURIConverterImpl extensibleURIConverterImpl = (ExtensibleURIConverterImpl)uriConverter;
            EList uriHandlers = extensibleURIConverterImpl.getURIHandlers();
            for (URIHandler uriHandler : uriHandlers) {
                if (!(uriHandler instanceof PlatformResourceURIHandlerWithProgressMonitorImpl)) continue;
                platformResourceURIHandlerWithProgressMonitorImpl = (PlatformResourceURIHandlerWithProgressMonitorImpl)uriHandler;
                break;
            }
        }
        return platformResourceURIHandlerWithProgressMonitorImpl;
    }
}

