/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.graphical.edit.policies;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.handles.MoveHandle;
import org.eclipse.gef.handles.ResizeHandle;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.AbstractBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderedShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ResizableEditPolicyEx;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.api.query.AbstractDNodeQuery;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.ui.business.api.query.NodeQuery;
import org.eclipse.sirius.diagram.ui.business.internal.query.RequestQuery;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramBorderNodeEditPart;
import org.eclipse.sirius.diagram.ui.edit.internal.part.PortLayoutHelper;
import org.eclipse.sirius.diagram.ui.internal.edit.commands.CenterEditPartEdgesCommand;
import org.eclipse.sirius.diagram.ui.internal.edit.commands.ChangeBendpointsOfEdgesCommand;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNodeNameEditPart;
import org.eclipse.sirius.diagram.ui.internal.operation.ShiftEdgeIdentityAnchorOperation;
import org.eclipse.sirius.diagram.ui.tools.api.figure.locator.DBorderItemLocator;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.IBorderItemOffsets;
import org.eclipse.sirius.diagram.ui.tools.internal.edit.command.CommandFactory;
import org.eclipse.sirius.diagram.ui.tools.internal.figure.locator.FeedbackDBorderItemLocator;
import org.eclipse.sirius.diagram.ui.tools.internal.ui.NoCopyDragEditPartsTrackerEx;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;

public class SpecificBorderItemSelectionEditPolicy
extends ResizableEditPolicyEx {
    public static final String BORDER_NODE_REAL_LOCATION_KEY = "borderNodesRealLocation";
    private static final String BORDER_NODE_FEEDBACKS_KEY = "borderNodeFeedbacks";
    private List<IFigure> feedbacks = new ArrayList<IFigure>();
    private Map<IFigure, Rectangle> correspondingExpandedCoordinate = new HashMap<IFigure, Rectangle>();
    private Rectangle collapsedRectangle;
    private EditPart feedbacksActivated;
    private boolean feedbackFigureDisplayed;

    public void eraseSourceFeedback(Request request) {
        if (!(request instanceof ChangeBoundsRequest)) {
            return;
        }
        this.getBorderNodeFeedbacks(request).remove(this.getDragSourceFeedbackFigure());
        if ("move".equals(request.getType()) && this.isDragAllowed() || "clone".equals(request.getType()) || "add children".equals(request.getType())) {
            this.eraseChangeBoundsFeedback((ChangeBoundsRequest)request);
        }
        if ("drop".equals(request.getType()) || "resize".equals(request.getType()) || "resize children".equals(request.getType())) {
            this.eraseChangeBoundsFeedback((ChangeBoundsRequest)request);
            this.eraseChangeBoundsProhibitedFeedbackWhenDrop();
        }
    }

    protected void eraseChangeBoundsFeedback(ChangeBoundsRequest request) {
        this.feedbackFigureDisplayed = false;
        super.eraseChangeBoundsFeedback(request);
    }

    private List<IFigure> getBorderNodeFeedbacks(Request request) {
        Object result = request.getExtendedData().get(BORDER_NODE_FEEDBACKS_KEY);
        if (result instanceof List && Iterables.all((Iterable)((List)result), (Predicate)Predicates.instanceOf(IFigure.class))) {
            return (List)result;
        }
        return new ArrayList<IFigure>();
    }

    private Map<DDiagramElement, Point> getLocationsForDDiagramElement(Request request) {
        Object result = request.getExtendedData().get(BORDER_NODE_REAL_LOCATION_KEY);
        if (result instanceof Map) {
            return (Map)result;
        }
        return Maps.newHashMap();
    }

    private void eraseChangeBoundsProhibitedFeedbackWhenDrop() {
        for (IFigure figure : this.feedbacks) {
            this.removeFeedback(figure);
        }
        this.feedbacks.clear();
        this.correspondingExpandedCoordinate.clear();
        this.feedbacksActivated = null;
        this.collapsedRectangle = null;
    }

    public void showSourceFeedback(Request request) {
        if (!(request instanceof ChangeBoundsRequest)) {
            return;
        }
        if ("move".equals(request.getType()) && this.isDragAllowed() || "add children".equals(request.getType()) || "clone".equals(request.getType())) {
            this.showChangeBoundsFeedback((ChangeBoundsRequest)request);
        }
        if ("drop".equals(request.getType()) || "resize".equals(request.getType()) || "resize children".equals(request.getType())) {
            this.showChangeBoundsFeedback((ChangeBoundsRequest)request);
        }
    }

    protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
        Point shiftedLocation;
        EditPart hostEditPart = this.getHost();
        IBorderItemEditPart borderItemEP = (IBorderItemEditPart)hostEditPart;
        EditPartViewer editPartViewer = hostEditPart.getViewer();
        EditPart targetEditPart = editPartViewer.findObjectAtExcluding(shiftedLocation = request.getLocation().getCopy(), Collections.emptyList(), (EditPartViewer.Conditional)new IBorderedShapeEditPartCondition());
        if (targetEditPart instanceof AbstractGraphicalEditPart) {
            AbstractGraphicalEditPart targetAbstractGraphicalEditPart = (AbstractGraphicalEditPart)targetEditPart;
            IFigure targetFigure = targetAbstractGraphicalEditPart.getFigure();
            IFigure feedback = this.getDragSourceFeedbackFigure();
            this.feedbackFigureDisplayed = true;
            PrecisionRectangle rect = new PrecisionRectangle(this.getInitialFeedbackBounds());
            this.getHostFigure().translateToAbsolute((Translatable)rect);
            rect.translate(request.getMoveDelta());
            rect.resize(request.getSizeDelta());
            Rectangle realLocation = null;
            if (this.isFeedbackForBorderedNodeDropping(request, targetAbstractGraphicalEditPart)) {
                this.activateProhibitedFeedbacks((EditPart)targetAbstractGraphicalEditPart, request);
                FeedbackDBorderItemLocator borderItemLocator = new FeedbackDBorderItemLocator(targetFigure);
                if (this.isCollapsed((IGraphicalEditPart)borderItemEP)) {
                    borderItemLocator.setBorderItemOffset(IBorderItemOffsets.COLLAPSE_FILTER_OFFSET);
                } else {
                    borderItemLocator.setBorderItemOffset(IBorderItemOffsets.DEFAULT_OFFSET);
                }
                if (targetAbstractGraphicalEditPart.getParent() != this.getHost().getParent().getParent()) {
                    if (targetAbstractGraphicalEditPart.getParent() instanceof DiagramEditPart) {
                        targetAbstractGraphicalEditPart.getFigure().translateToAbsolute((Translatable)rect);
                    } else {
                        targetAbstractGraphicalEditPart.getFigure().translateToRelative((Translatable)rect);
                    }
                } else {
                    this.getHostFigure().translateToRelative((Translatable)rect);
                }
                if (hostEditPart instanceof IGraphicalEditPart && this.isCollapsed((IGraphicalEditPart)hostEditPart)) {
                    Dimension initialDim = this.getInitialDimension((IGraphicalEditPart)hostEditPart);
                    Rectangle newBoundsAbsolute = PortLayoutHelper.getUncollapseCandidateLocation(initialDim, (Rectangle)rect, null);
                    borderItemLocator.setConstraint(newBoundsAbsolute);
                    borderItemLocator.setBorderItemOffset(IBorderItemOffsets.DEFAULT_OFFSET);
                    rect.setBounds(newBoundsAbsolute);
                }
                realLocation = borderItemLocator.getValidLocation((Rectangle)rect, feedback, this.getFiguresToIgnore(request), this.getBorderNodeFeedbacks((Request)request));
                targetFigure.translateToAbsolute((Translatable)realLocation);
                feedback.translateToRelative((Translatable)realLocation);
                feedback.setBounds(realLocation);
                this.storeFeedback(feedback, request);
                Map<DDiagramElement, Point> locationsForDDiagramElement = this.getLocationsForDDiagramElement((Request)request);
                if (this.isCollapsed((IGraphicalEditPart)borderItemEP)) {
                    realLocation = PortLayoutHelper.getCollapseCandidateLocation(borderItemEP.getFigure().getSize(), realLocation, targetFigure.getBounds());
                }
                locationsForDDiagramElement.put((DDiagramElement)borderItemEP.resolveSemanticElement(), realLocation.getLocation());
                request.getExtendedData().put(BORDER_NODE_REAL_LOCATION_KEY, locationsForDDiagramElement);
            } else {
                this.activateProhibitedFeedbacks(hostEditPart.getParent(), request);
                IBorderItemLocator borderItemLocator = borderItemEP.getBorderItemLocator();
                if (borderItemLocator != null) {
                    this.getHostFigure().translateToRelative((Translatable)rect);
                    Rectangle newRect = this.expandsCollapsedNodeBounds(borderItemEP, rect);
                    if (newRect != null) {
                        rect.setBounds(newRect);
                    }
                    if (borderItemLocator instanceof DBorderItemLocator) {
                        List<IFigure> figuresToIgnore = this.getFiguresToIgnore(request);
                        realLocation = ((DBorderItemLocator)borderItemLocator).getValidLocation((Rectangle)rect, borderItemEP.getFigure(), figuresToIgnore, this.getBorderNodeFeedbacks((Request)request));
                    } else {
                        realLocation = borderItemLocator.getValidLocation(rect.getCopy(), borderItemEP.getFigure());
                    }
                    if (this.collapsedRectangle != null) {
                        this.restoreCollapsedNode(borderItemEP);
                    }
                    this.getHostFigure().translateToAbsolute((Translatable)realLocation);
                    feedback.translateToRelative((Translatable)realLocation);
                    feedback.setBounds(realLocation);
                    this.storeFeedback(feedback, request);
                }
            }
        }
    }

    private void storeFeedback(IFigure feedback, ChangeBoundsRequest request) {
        if (request.getEditParts().size() > 1 && !this.getHost().equals(request.getEditParts().get(request.getEditParts().size() - 1))) {
            List<IFigure> borderNodeFeedbacks = this.getBorderNodeFeedbacks((Request)request);
            int currentIndex = borderNodeFeedbacks.indexOf(feedback);
            if (currentIndex != -1) {
                borderNodeFeedbacks.set(currentIndex, feedback);
            } else {
                borderNodeFeedbacks.add(feedback);
            }
            request.getExtendedData().put(BORDER_NODE_FEEDBACKS_KEY, borderNodeFeedbacks);
        }
    }

    private void restoreCollapsedNode(IBorderItemEditPart borderItemEP) {
        IBorderItemLocator borderItemLocator = borderItemEP.getBorderItemLocator();
        if (borderItemLocator instanceof DBorderItemLocator) {
            borderItemLocator.setConstraint(this.collapsedRectangle.getCopy());
            ((DBorderItemLocator)borderItemLocator).setBorderItemOffset(IBorderItemOffsets.COLLAPSE_FILTER_OFFSET);
        }
    }

    private Rectangle expandsCollapsedNodeBounds(IBorderItemEditPart hostEditPart, PrecisionRectangle rect) {
        IBorderItemLocator borderItemLocator;
        if (this.isCollapsed((IGraphicalEditPart)hostEditPart) && (borderItemLocator = hostEditPart.getBorderItemLocator()) instanceof DBorderItemLocator) {
            if (this.collapsedRectangle == null) {
                this.collapsedRectangle = ((DBorderItemLocator)borderItemLocator).getCurrentConstraint();
            }
            EditPart parentEditPart = hostEditPart.getParent();
            Rectangle parentBounds = null;
            if (parentEditPart instanceof IGraphicalEditPart) {
                IFigure parentFigure = ((IGraphicalEditPart)parentEditPart).getFigure();
                parentBounds = parentFigure.getBounds().getCopy();
                if (parentFigure instanceof NodeFigure) {
                    parentBounds = ((NodeFigure)parentFigure).getHandleBounds().getCopy();
                }
                Dimension initialDim = this.getInitialDimension((IGraphicalEditPart)hostEditPart);
                Rectangle newBoundsAbsolute = PortLayoutHelper.getUncollapseCandidateLocation(initialDim, (Rectangle)rect, parentBounds);
                Rectangle newBoundsFromFigure = PortLayoutHelper.getUncollapseCandidateLocation(initialDim, this.collapsedRectangle, null);
                borderItemLocator.setConstraint(newBoundsFromFigure);
                ((DBorderItemLocator)borderItemLocator).setBorderItemOffset(IBorderItemOffsets.DEFAULT_OFFSET);
                return newBoundsAbsolute;
            }
        }
        return null;
    }

    private boolean isCollapsed(IGraphicalEditPart editPart) {
        EObject element = editPart.resolveSemanticElement();
        if (element instanceof DDiagramElement) {
            DDiagramElementQuery query = new DDiagramElementQuery((DDiagramElement)element);
            return query.isIndirectlyCollapsed();
        }
        return false;
    }

    private void activateProhibitedFeedbacks(EditPart targetEditPart, ChangeBoundsRequest request) {
        if (this.isFeedbacksActivated() && !this.isFeedbacksActivatedForEditPart(targetEditPart)) {
            this.eraseChangeBoundsProhibitedFeedbackWhenDrop();
        }
        for (Object child : targetEditPart.getChildren()) {
            AbstractDiagramBorderNodeEditPart borderNodeEditPart;
            if (request.getEditParts().contains(child) || !(child instanceof AbstractDiagramBorderNodeEditPart) || !this.isCollapsed(borderNodeEditPart = (AbstractDiagramBorderNodeEditPart)child)) continue;
            this.configureFeedback((AbstractBorderItemEditPart)borderNodeEditPart, this.getBorderNodeFeedbacks((Request)request));
        }
        this.feedbacksActivated = targetEditPart;
    }

    private boolean isFeedbacksActivatedForEditPart(EditPart targetEditPart) {
        return this.feedbacksActivated == targetEditPart;
    }

    private boolean isFeedbacksActivated() {
        return this.feedbacksActivated != null;
    }

    private void configureFeedback(AbstractBorderItemEditPart borderNodeEditPart, List<IFigure> otherFeedbackFigures) {
        Rectangle figureNewBounds;
        IFigure figure = borderNodeEditPart.getFigure();
        EditPart parentEditPart = borderNodeEditPart.getParent();
        if (!this.isFeedbacksActivatedForEditPart(borderNodeEditPart.getParent())) {
            Dimension initialDim = this.getInitialDimension((IGraphicalEditPart)borderNodeEditPart);
            Rectangle bounds = figure.getBounds().getCopy();
            Rectangle parentBounds = null;
            if (parentEditPart instanceof IGraphicalEditPart) {
                IFigure parentFigure = ((IGraphicalEditPart)parentEditPart).getFigure();
                parentBounds = parentFigure.getBounds().getCopy();
                if (parentFigure instanceof NodeFigure) {
                    parentBounds = ((NodeFigure)parentFigure).getHandleBounds().getCopy();
                }
            }
            Rectangle newBounds = PortLayoutHelper.getUncollapseCandidateLocation(initialDim, bounds, parentBounds);
            IBorderItemLocator borderItemLocator = borderNodeEditPart.getBorderItemLocator();
            Rectangle realNewBounds = this.getRealExpandedBounds(figure, newBounds, (org.eclipse.gmf.runtime.draw2d.ui.figures.IBorderItemLocator)borderItemLocator, otherFeedbackFigures);
            PrecisionRectangle precisionRectangle = new PrecisionRectangle(realNewBounds);
            RectangleFigure r = new RectangleFigure();
            r.setLineStyle(3);
            r.setBounds((Rectangle)precisionRectangle);
            this.addFeedback((IFigure)r);
            figure.translateToAbsolute((Translatable)precisionRectangle);
            r.translateToRelative((Translatable)precisionRectangle);
            r.setBounds((Rectangle)precisionRectangle);
            r.setBackgroundColor(ColorConstants.red);
            r.setAlpha(70);
            this.feedbacks.add((IFigure)r);
            this.correspondingExpandedCoordinate.put(figure, realNewBounds);
        }
        if ((figureNewBounds = this.correspondingExpandedCoordinate.get(figure)) != null) {
            figure.setBounds(figureNewBounds);
        }
    }

    private Rectangle getRealExpandedBounds(IFigure figure, Rectangle candidateNewBounds, org.eclipse.gmf.runtime.draw2d.ui.figures.IBorderItemLocator borderItemLocator, List<IFigure> otherFeedbackFigures) {
        Rectangle realNewBounds = candidateNewBounds;
        if (borderItemLocator instanceof DBorderItemLocator) {
            Rectangle oldConstraint = ((DBorderItemLocator)borderItemLocator).getCurrentConstraint();
            borderItemLocator.setConstraint(candidateNewBounds);
            Dimension oldOffset = ((DBorderItemLocator)borderItemLocator).getBorderItemOffset();
            ((DBorderItemLocator)borderItemLocator).setBorderItemOffset(IBorderItemOffsets.DEFAULT_OFFSET);
            realNewBounds = ((DBorderItemLocator)borderItemLocator).getValidLocation(candidateNewBounds, figure, Collections.singleton(figure), otherFeedbackFigures);
            ((DBorderItemLocator)borderItemLocator).setBorderItemOffset(oldOffset);
            borderItemLocator.setConstraint(oldConstraint);
        }
        return realNewBounds;
    }

    private Dimension getInitialDimension(IGraphicalEditPart editPart) {
        Object node = editPart.getModel();
        if (node instanceof Node) {
            NodeQuery query = new NodeQuery((Node)node);
            return query.getOriginalDimensionBeforeCollapse();
        }
        return new Dimension(0, 0);
    }

    private boolean isFeedbackForBorderedNodeDropping(ChangeBoundsRequest request, AbstractGraphicalEditPart targetAbstractGraphicalEditPart) {
        boolean isFeedbackForBorderedNodeDropping = false;
        if (!new RequestQuery((Request)request).isResize() && !"resize children".equals(request.getType())) {
            EditPart hostEditPart = this.getHost();
            IFigure diagramFigure = ((AbstractGraphicalEditPart)hostEditPart.getRoot().getChildren().get(0)).getFigure();
            IFigure targetFigure = targetAbstractGraphicalEditPart.getFigure();
            if (targetFigure != diagramFigure && !(hostEditPart instanceof DNodeNameEditPart)) {
                isFeedbackForBorderedNodeDropping = targetAbstractGraphicalEditPart != hostEditPart && targetAbstractGraphicalEditPart != hostEditPart.getParent();
            }
        }
        return isFeedbackForBorderedNodeDropping;
    }

    protected Command getResizeCommand(ChangeBoundsRequest request) {
        Command superCommand = super.getResizeCommand(request);
        EditPart host = this.getHost();
        if (host instanceof IGraphicalEditPart) {
            TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)host).getEditingDomain();
            CompositeTransactionalCommand ctc = new CompositeTransactionalCommand(editingDomain, superCommand.getLabel());
            ctc.add((IUndoableOperation)new CommandProxy(superCommand));
            ShiftEdgeIdentityAnchorOperation operation = new ShiftEdgeIdentityAnchorOperation(request);
            ICommand command = CommandFactory.createICommand(editingDomain, operation);
            ctc.add((IUndoableOperation)command);
            CenterEditPartEdgesCommand centerEditPartEdgesCommand = new CenterEditPartEdgesCommand((IGraphicalEditPart)host, request);
            ctc.add((IUndoableOperation)centerEditPartEdgesCommand);
            return new ICommandProxy((ICommand)ctc);
        }
        return superCommand;
    }

    protected Command getMoveCommand(ChangeBoundsRequest request) {
        IBorderItemEditPart borderItemEP = (IBorderItemEditPart)this.getHost();
        IBorderItemLocator borderItemLocator = borderItemEP.getBorderItemLocator();
        if (borderItemLocator != null) {
            Rectangle realLocation;
            PrecisionRectangle rect = new PrecisionRectangle(this.getInitialFeedbackBounds());
            this.getHostFigure().translateToAbsolute((Translatable)rect);
            rect.translate(request.getMoveDelta());
            rect.resize(request.getSizeDelta());
            this.getHostFigure().translateToRelative((Translatable)rect);
            if (borderItemLocator instanceof DBorderItemLocator) {
                List<IFigure> figuresToIgnore = this.getFiguresToIgnore(request);
                Rectangle newBounds = this.expandsCollapsedNodeBounds(borderItemEP, rect);
                if (newBounds != null) {
                    rect.setBounds(newBounds);
                }
                realLocation = ((DBorderItemLocator)borderItemLocator).getValidLocation((Rectangle)rect, borderItemEP.getFigure(), figuresToIgnore, this.getBorderNodeFeedbacks((Request)request));
                if (this.collapsedRectangle != null) {
                    this.restoreCollapsedNode(borderItemEP);
                    IFigure parentFigure = ((DBorderItemLocator)borderItemLocator).getParentFigure();
                    Rectangle parentBounds = parentFigure.getBounds().getCopy();
                    if (parentFigure instanceof NodeFigure) {
                        parentBounds = ((NodeFigure)parentFigure).getHandleBounds().getCopy();
                    }
                    Rectangle collapsedBounds = PortLayoutHelper.getCollapseCandidateLocation(this.collapsedRectangle.getSize(), realLocation, parentBounds);
                    realLocation.setBounds(collapsedBounds);
                }
                ((DBorderItemLocator)borderItemLocator).setFiguresToIgnoresDuringNextRelocate(figuresToIgnore);
            } else {
                realLocation = borderItemLocator.getValidLocation(rect.getCopy(), borderItemEP.getFigure());
            }
            Point parentOrigin = borderItemEP.getFigure().getParent().getBounds().getTopLeft();
            Dimension d = realLocation.getTopLeft().getDifference(parentOrigin);
            Point location = new Point(d.width, d.height);
            SetBoundsCommand moveCommand = new SetBoundsCommand(borderItemEP.getEditingDomain(), DiagramUIMessages.Commands_MoveElement, (IAdaptable)new EObjectAdapter((EObject)((View)this.getHost().getModel())), location);
            ICommandProxy result = new ICommandProxy((ICommand)moveCommand);
            if (this.getHost() instanceof IGraphicalEditPart) {
                PrecisionPoint delta = new PrecisionPoint(realLocation.getTopLeft().getTranslated(borderItemEP.getFigure().getBounds().getTopLeft().getNegated()));
                GraphicalHelper.applyZoomOnPoint((IGraphicalEditPart)((IGraphicalEditPart)this.getHost()), (Point)delta);
                IGraphicalEditPart hostPart = (IGraphicalEditPart)this.getHost();
                CompositeTransactionalCommand ctc = new CompositeTransactionalCommand(hostPart.getEditingDomain(), result.getLabel());
                ctc.add((IUndoableOperation)new CommandProxy((Command)result));
                ctc.add((IUndoableOperation)new ChangeBendpointsOfEdgesCommand(hostPart, delta));
                result = new ICommandProxy((ICommand)ctc);
            }
            return result;
        }
        return null;
    }

    protected List<IFigure> getFiguresToIgnore(ChangeBoundsRequest request) {
        ArrayList figuresToIgnore = Lists.newArrayList();
        for (Object part : request.getEditParts()) {
            if (!(part instanceof GraphicalEditPart)) continue;
            figuresToIgnore.add(((GraphicalEditPart)part).getFigure());
        }
        if (this.feedbackFigureDisplayed) {
            figuresToIgnore.add(this.getDragSourceFeedbackFigure());
        }
        return figuresToIgnore;
    }

    protected void addSelectionHandles() {
        super.addSelectionHandles();
        boolean mustMoveCursorBeDisabled = this.mustMoveCursorBeDisabled();
        for (Object handle : this.handles) {
            if (mustMoveCursorBeDisabled && (handle instanceof MoveHandle || handle instanceof ResizeHandle)) {
                ((IFigure)handle).setCursor(null);
            }
            if (!(handle instanceof MoveHandle)) continue;
            ((MoveHandle)handle).setDragTracker((DragTracker)new NoCopyDragEditPartsTrackerEx(this.getHost()));
        }
    }

    protected boolean mustMoveCursorBeDisabled() {
        EObject semantic;
        boolean result = false;
        if (this.getHost() instanceof org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart && (semantic = ((org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart)this.getHost()).resolveSemanticElement()) instanceof AbstractDNode) {
            result = new AbstractDNodeQuery((AbstractDNode)semantic).isBorderedNode() && new DDiagramElementQuery((DDiagramElement)((AbstractDNode)semantic)).isCollapsed();
        }
        return result;
    }

    static class IBorderedShapeEditPartCondition
    implements EditPartViewer.Conditional {
        IBorderedShapeEditPartCondition() {
        }

        public boolean evaluate(EditPart editpart) {
            return editpart instanceof IBorderedShapeEditPart;
        }
    }
}

