/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.providers;

import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.ui.internal.providers.ElementInitializers;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.swt.graphics.Image;

public class SiriusElementTypes
extends ElementInitializers {
    private static Map<IElementType, EClass> elements;
    private static ImageRegistry imageRegistry;
    private static Set<IElementType> KNOWN_ELEMENT_TYPES;
    public static final IElementType DDiagram_1000;
    public static final IElementType DNode_2001;
    public static final IElementType DNodeContainer_2002;
    public static final IElementType DNodeList_2003;
    public static final IElementType DNode_3001;
    public static final IElementType Dot_3002;
    public static final IElementType Square_3003;
    public static final IElementType Ellipse_3016;
    public static final IElementType Lozenge_3017;
    public static final IElementType BundledImage_3004;
    public static final IElementType WorkspaceImage_3005;
    public static final IElementType Note_3013;
    public static final IElementType GaugeCompositeStyle_3006;
    public static final IElementType CustomStyle_3014;
    public static final IElementType DNode_3007;
    public static final IElementType DNodeContainer_3008;
    public static final IElementType DNodeList_3009;
    public static final IElementType DNodeListElement_3010;
    public static final IElementType DNode_3012;
    public static final IElementType DEdge_4001;
    public static final IElementType BracketEdge_4002;

    static {
        DDiagram_1000 = SiriusElementTypes.getElementType("org.eclipse.sirius.diagram.DDiagram_1000");
        DNode_2001 = SiriusElementTypes.getElementType("org.eclipse.sirius.diagram.DNode_2001");
        DNodeContainer_2002 = SiriusElementTypes.getElementType("org.eclipse.sirius.diagram.DNodeContainer_2002");
        DNodeList_2003 = SiriusElementTypes.getElementType("org.eclipse.sirius.diagram.DNodeList_2003");
        DNode_3001 = SiriusElementTypes.getElementType("org.eclipse.sirius.diagram.DNode_3001");
        Dot_3002 = SiriusElementTypes.getElementType("org.eclipse.sirius.diagram.Dot_3002");
        Square_3003 = SiriusElementTypes.getElementType("org.eclipse.sirius.diagram.Square_3003");
        Ellipse_3016 = SiriusElementTypes.getElementType("org.eclipse.sirius.diagram.Ellipse_3016");
        Lozenge_3017 = SiriusElementTypes.getElementType("org.eclipse.sirius.diagram.Lozenge_3017");
        BundledImage_3004 = SiriusElementTypes.getElementType("org.eclipse.sirius.diagram.BundledImage_3004");
        WorkspaceImage_3005 = SiriusElementTypes.getElementType("org.eclipse.sirius.diagram.WorkspaceImage_3005");
        Note_3013 = SiriusElementTypes.getElementType("org.eclipse.sirius.diagram.Note_3013");
        GaugeCompositeStyle_3006 = SiriusElementTypes.getElementType("org.eclipse.sirius.diagram.GaugeCompositeStyle_3006");
        CustomStyle_3014 = SiriusElementTypes.getElementType("org.eclipse.sirius.diagram.CustomStyle_3014");
        DNode_3007 = SiriusElementTypes.getElementType("org.eclipse.sirius.diagram.DNode_3007");
        DNodeContainer_3008 = SiriusElementTypes.getElementType("org.eclipse.sirius.diagram.DNodeContainer_3008");
        DNodeList_3009 = SiriusElementTypes.getElementType("org.eclipse.sirius.diagram.DNodeList_3009");
        DNodeListElement_3010 = SiriusElementTypes.getElementType("org.eclipse.sirius.diagram.DNodeListElement_3010");
        DNode_3012 = SiriusElementTypes.getElementType("org.eclipse.sirius.diagram.DNode_3012");
        DEdge_4001 = SiriusElementTypes.getElementType("org.eclipse.sirius.diagram.DEdge_4001");
        BracketEdge_4002 = SiriusElementTypes.getElementType("org.eclipse.sirius.diagram.BracketEdge_4002");
    }

    private SiriusElementTypes() {
    }

    private static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry();
        }
        return imageRegistry;
    }

    private static String getImageRegistryKey(ENamedElement element) {
        return element.getName();
    }

    private static ImageDescriptor getProvidedImageDescriptor(ENamedElement element) {
        EClass eClass;
        if (element instanceof EStructuralFeature) {
            EStructuralFeature feature = (EStructuralFeature)element;
            EClass eContainingClass = feature.getEContainingClass();
            EClassifier eType = feature.getEType();
            if (eContainingClass != null && !eContainingClass.isAbstract()) {
                element = eContainingClass;
            } else if (eType instanceof EClass && !((EClass)eType).isAbstract()) {
                element = eType;
            }
        }
        if (element instanceof EClass && !(eClass = (EClass)element).isAbstract()) {
            return DiagramUIPlugin.getPlugin().getItemImageDescriptor(eClass.getEPackage().getEFactoryInstance().create(eClass));
        }
        return null;
    }

    public static ImageDescriptor getImageDescriptor(ENamedElement element) {
        String key = SiriusElementTypes.getImageRegistryKey(element);
        ImageDescriptor imageDescriptor = SiriusElementTypes.getImageRegistry().getDescriptor(key);
        if (imageDescriptor == null) {
            imageDescriptor = SiriusElementTypes.getProvidedImageDescriptor(element);
            if (imageDescriptor == null) {
                imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
            }
            SiriusElementTypes.getImageRegistry().put(key, imageDescriptor);
        }
        return imageDescriptor;
    }

    public static Image getImage(ENamedElement element) {
        String key = SiriusElementTypes.getImageRegistryKey(element);
        Image image = SiriusElementTypes.getImageRegistry().get(key);
        if (image == null) {
            ImageDescriptor imageDescriptor = SiriusElementTypes.getProvidedImageDescriptor(element);
            if (imageDescriptor == null) {
                imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
            }
            SiriusElementTypes.getImageRegistry().put(key, imageDescriptor);
            image = SiriusElementTypes.getImageRegistry().get(key);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(IAdaptable hint) {
        ENamedElement element = SiriusElementTypes.getElement(hint);
        if (element == null) {
            return null;
        }
        return SiriusElementTypes.getImageDescriptor(element);
    }

    public static Image getImage(IAdaptable hint) {
        ENamedElement element = SiriusElementTypes.getElement(hint);
        if (element == null) {
            return null;
        }
        return SiriusElementTypes.getImage(element);
    }

    public static ENamedElement getElement(IAdaptable hint) {
        Object type = hint.getAdapter(IElementType.class);
        if (elements == null) {
            elements = new IdentityHashMap<IElementType, EClass>();
            elements.put(DDiagram_1000, DiagramPackage.eINSTANCE.getDDiagram());
            elements.put(DNode_2001, DiagramPackage.eINSTANCE.getDNode());
            elements.put(DNodeContainer_2002, DiagramPackage.eINSTANCE.getDNodeContainer());
            elements.put(DNodeList_2003, DiagramPackage.eINSTANCE.getDNodeList());
            elements.put(DNode_3001, DiagramPackage.eINSTANCE.getDNode());
            elements.put(BundledImage_3004, DiagramPackage.eINSTANCE.getBundledImage());
            elements.put(Dot_3002, DiagramPackage.eINSTANCE.getDot());
            elements.put(GaugeCompositeStyle_3006, DiagramPackage.eINSTANCE.getGaugeCompositeStyle());
            elements.put(Square_3003, DiagramPackage.eINSTANCE.getSquare());
            elements.put(Ellipse_3016, DiagramPackage.eINSTANCE.getEllipse());
            elements.put(Lozenge_3017, DiagramPackage.eINSTANCE.getLozenge());
            elements.put(WorkspaceImage_3005, DiagramPackage.eINSTANCE.getWorkspaceImage());
            elements.put(Note_3013, DiagramPackage.eINSTANCE.getNote());
            elements.put(CustomStyle_3014, DiagramPackage.eINSTANCE.getCustomStyle());
            elements.put(DNode_3007, DiagramPackage.eINSTANCE.getDNode());
            elements.put(DNodeContainer_3008, DiagramPackage.eINSTANCE.getDNodeContainer());
            elements.put(DNodeList_3009, DiagramPackage.eINSTANCE.getDNodeList());
            elements.put(DNodeListElement_3010, DiagramPackage.eINSTANCE.getDNodeListElement());
            elements.put(DNode_3012, DiagramPackage.eINSTANCE.getDNode());
            elements.put(DEdge_4001, DiagramPackage.eINSTANCE.getDEdge());
        }
        return (ENamedElement)elements.get(type);
    }

    private static IElementType getElementType(String id) {
        return ElementTypeRegistry.getInstance().getType(id);
    }

    public static boolean isKnownElementType(IElementType elementType) {
        if (KNOWN_ELEMENT_TYPES == null) {
            KNOWN_ELEMENT_TYPES = new HashSet<IElementType>();
            KNOWN_ELEMENT_TYPES.add(DDiagram_1000);
            KNOWN_ELEMENT_TYPES.add(DNode_2001);
            KNOWN_ELEMENT_TYPES.add(DNodeContainer_2002);
            KNOWN_ELEMENT_TYPES.add(DNodeList_2003);
            KNOWN_ELEMENT_TYPES.add(DNode_3001);
            KNOWN_ELEMENT_TYPES.add(BundledImage_3004);
            KNOWN_ELEMENT_TYPES.add(Dot_3002);
            KNOWN_ELEMENT_TYPES.add(GaugeCompositeStyle_3006);
            KNOWN_ELEMENT_TYPES.add(Square_3003);
            KNOWN_ELEMENT_TYPES.add(Ellipse_3016);
            KNOWN_ELEMENT_TYPES.add(Lozenge_3017);
            KNOWN_ELEMENT_TYPES.add(WorkspaceImage_3005);
            KNOWN_ELEMENT_TYPES.add(Note_3013);
            KNOWN_ELEMENT_TYPES.add(CustomStyle_3014);
            KNOWN_ELEMENT_TYPES.add(DNode_3007);
            KNOWN_ELEMENT_TYPES.add(DNodeContainer_3008);
            KNOWN_ELEMENT_TYPES.add(DNodeList_3009);
            KNOWN_ELEMENT_TYPES.add(DNodeListElement_3010);
            KNOWN_ELEMENT_TYPES.add(DNode_3012);
            KNOWN_ELEMENT_TYPES.add(DEdge_4001);
            KNOWN_ELEMENT_TYPES.add(BracketEdge_4002);
        }
        return KNOWN_ELEMENT_TYPES.contains(elementType);
    }
}

