/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.refresh.listeners;

import com.google.common.base.Predicate;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.ModelChangeTrigger;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionEventBroker;
import org.eclipse.sirius.business.internal.session.SessionEventBrokerImpl;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.business.internal.helper.display.VisibilityPropagatorAdapter;
import org.eclipse.sirius.diagram.ui.internal.refresh.listeners.ComputedStyleDescriptionCacheCleaner;
import org.eclipse.sirius.diagram.ui.internal.refresh.listeners.DDiagramHiddenElementsUpdater;
import org.eclipse.sirius.diagram.ui.internal.refresh.listeners.EdgeLayoutUpdaterModelChangeTrigger;
import org.eclipse.sirius.diagram.ui.internal.refresh.listeners.EdgeStyleUpdater;
import org.eclipse.sirius.diagram.ui.internal.refresh.listeners.FilterListener;
import org.eclipse.sirius.diagram.ui.internal.refresh.listeners.FilterListenerScope;
import org.eclipse.sirius.diagram.ui.internal.refresh.listeners.FontFormatUpdater;
import org.eclipse.sirius.diagram.ui.internal.refresh.listeners.GMFBoundsUpdater;
import org.eclipse.sirius.diagram.ui.internal.refresh.listeners.NotationVisibilityUpdater;
import org.eclipse.sirius.diagram.ui.internal.refresh.listeners.VisibilityUpdater;

public class GMFDiagramUpdater {
    private NotationVisibilityUpdater notationVisibilityUpdater;
    private FontFormatUpdater viewFontChangesRefactorer;
    private FilterListener filterListener;
    private GMFBoundsUpdater gmfBoundsUpdater;
    private VisibilityUpdater visibilityUpdater;
    private DDiagramHiddenElementsUpdater dDiagramHiddenElementsUpdater;
    private ComputedStyleDescriptionCacheCleaner computedStyleDescriptionCacheCleaner;
    private EdgeStyleUpdater edgeStyleUpdater;
    private SessionEventBroker eventBroker;
    private VisibilityPropagatorAdapter visibilityPropagator;
    private EdgeLayoutUpdaterModelChangeTrigger edgeLayoutUpdaterChangeTrigger;

    public GMFDiagramUpdater(Session session, DDiagram dDiagram) {
        TransactionalEditingDomain domain = session.getTransactionalEditingDomain();
        this.notationVisibilityUpdater = new NotationVisibilityUpdater(session);
        this.viewFontChangesRefactorer = new FontFormatUpdater(domain);
        this.eventBroker = session.getEventBroker();
        this.filterListener = new FilterListener(dDiagram, session.getTransactionalEditingDomain());
        this.eventBroker.addLocalTrigger(SessionEventBrokerImpl.asFilter((Predicate)new FilterListenerScope()), (ModelChangeTrigger)this.filterListener);
        this.edgeLayoutUpdaterChangeTrigger = new EdgeLayoutUpdaterModelChangeTrigger(session, dDiagram);
        this.gmfBoundsUpdater = new GMFBoundsUpdater(domain, dDiagram);
        this.visibilityUpdater = new VisibilityUpdater(domain, dDiagram);
        this.dDiagramHiddenElementsUpdater = new DDiagramHiddenElementsUpdater(domain, dDiagram);
        this.visibilityPropagator = new VisibilityPropagatorAdapter(session, dDiagram);
        this.computedStyleDescriptionCacheCleaner = new ComputedStyleDescriptionCacheCleaner(domain, dDiagram);
        this.edgeStyleUpdater = new EdgeStyleUpdater(domain, session.getSemanticCrossReferencer());
    }

    public void dispose() {
        this.visibilityPropagator.dispose();
        this.notationVisibilityUpdater.dispose();
        this.viewFontChangesRefactorer.dispose();
        this.gmfBoundsUpdater.dispose();
        this.visibilityUpdater.dispose();
        this.dDiagramHiddenElementsUpdater.dispose();
        this.computedStyleDescriptionCacheCleaner.dispose();
        this.computedStyleDescriptionCacheCleaner = null;
        this.edgeStyleUpdater.dispose();
        this.eventBroker.removeLocalTrigger((ModelChangeTrigger)this.filterListener);
        this.edgeLayoutUpdaterChangeTrigger.dispose();
        this.edgeLayoutUpdaterChangeTrigger = null;
        this.eventBroker = null;
    }
}

