/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.api.query;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.business.api.query.DiagramElementMappingQuery;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.SiriusPlugin;

public class AbstractNodeMappingQuery
extends DiagramElementMappingQuery {
    private AbstractNodeMapping abstractNodeMapping;

    public AbstractNodeMappingQuery(AbstractNodeMapping abstractNodeMapping) {
        super(abstractNodeMapping);
        this.abstractNodeMapping = abstractNodeMapping;
    }

    public boolean evaluatePrecondition(DSemanticDiagram diagram, DragAndDropTarget containerView, IInterpreter interpreter, EObject semantic) {
        DslCommonPlugin.PROFILER.startWork("Check precondition expressions");
        boolean result = true;
        if (!StringUtil.isEmpty((String)this.abstractNodeMapping.getPreconditionExpression())) {
            EObject container = null;
            if (containerView instanceof DSemanticDecorator) {
                container = ((DSemanticDecorator)containerView).getTarget();
            }
            interpreter.setVariable("containerView", (Object)containerView);
            interpreter.setVariable("container", (Object)container);
            interpreter.setVariable("viewpoint", (Object)diagram);
            interpreter.setVariable("diagram", (Object)diagram);
            try {
                result = interpreter.evaluateBoolean(semantic, this.abstractNodeMapping.getPreconditionExpression());
            }
            catch (EvaluationException e) {
                SiriusPlugin.getDefault().warning("the following abstract node mapping precondition could not be correctly evaluated : " + this.abstractNodeMapping.getPreconditionExpression(), (Exception)((Object)e));
            }
            interpreter.unSetVariable("containerView");
            interpreter.unSetVariable("container");
            interpreter.unSetVariable("diagram");
            interpreter.unSetVariable("viewpoint");
        }
        DslCommonPlugin.PROFILER.stopWork("Check precondition expressions");
        return result;
    }
}

