/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.business.internal.refresh;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.table.business.internal.refresh.KeyCache;
import org.eclipse.sirius.table.metamodel.table.DCell;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.description.ColumnMapping;

public class DCellCandidate {
    private final EObject semantic;
    private final ColumnMapping mapping;
    private final DColumn column;
    private final DLine line;
    private DCell element;
    private final URI semanticURI;
    private final URI lineURI;
    private final URI columnURI;
    private final int hashCode;

    public DCellCandidate(ColumnMapping mapping, EObject semanticElement, DLine line, DColumn column) {
        this.mapping = mapping;
        this.semantic = semanticElement;
        this.line = line;
        this.column = column;
        this.semanticURI = this.semantic != null ? EcoreUtil.getURI((EObject)this.semantic) : null;
        this.lineURI = line != null ? EcoreUtil.getURI((EObject)line) : null;
        this.columnURI = column != null ? EcoreUtil.getURI((EObject)column) : null;
        this.hashCode = this.computeHashCode();
    }

    public DCellCandidate(DCell tableElement) {
        this(tableElement.getColumn() != null ? tableElement.getColumn().getOriginMapping() : null, tableElement.getTarget(), tableElement.getLine(), tableElement.getColumn());
        this.element = tableElement;
    }

    public boolean comesFromTableElement() {
        return this.getOriginalElement() != null;
    }

    public DCell getOriginalElement() {
        return this.element;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        return KeyCache.DEFAULT.getKey(String.valueOf(this.mapping != null ? this.mapping.getName() : "") + this.semanticURI + this.lineURI + this.columnURI);
    }

    public boolean equals(Object obj) {
        Boolean result = null;
        if (this == obj) {
            result = true;
        }
        if (result == null && obj == null) {
            result = false;
        }
        if (result == null && !(obj instanceof DCellCandidate)) {
            result = false;
        }
        DCellCandidate other = (DCellCandidate)obj;
        if (result == null && this.mapping == null) {
            if (other.mapping != null) {
                result = false;
            }
        } else if (result == null && !this.mapping.getName().equals(other.mapping.getName())) {
            result = false;
        }
        if (result == null && this.semantic == null) {
            if (other.semantic != null) {
                result = false;
            }
        } else if (result == null && !this.semanticURI.equals((Object)other.semanticURI)) {
            result = false;
        }
        if (result == null && this.line == null) {
            if (other.line != null) {
                result = false;
            }
        } else if (result == null && !this.lineURI.equals((Object)other.lineURI)) {
            result = false;
        }
        if (result == null && this.column == null) {
            if (other.column != null) {
                result = false;
            }
        } else if (result == null && !this.columnURI.equals((Object)other.columnURI)) {
            result = false;
        }
        if (result == null) {
            result = true;
        }
        return result;
    }

    public ColumnMapping getMapping() {
        return this.mapping;
    }

    public EObject getSemantic() {
        return this.semantic;
    }

    public DColumn getColumn() {
        return this.column;
    }

    public DLine getLine() {
        return this.line;
    }
}

