/*******************************************************************************
 * Copyright (c) 2011 THALES GLOBAL SERVICES.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Obeo - initial API and implementation
 *******************************************************************************/
package org.eclipse.sirius.tree.business.api.command;

import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.business.api.interaction.DTreeItemUserInteraction;
import org.eclipse.sirius.tree.business.internal.dialect.common.viewpoint.GlobalContext;

/**
 * EMF Command to expand/collapse a {@link DTreeItem}.
 * 
 * @author <a href="mailto:esteban.dugueperoux@obeo.fr">Esteban Dugueperoux</a>
 */
public class DTreeItemExpansionChangeCommand extends RecordingCommand {

    private GlobalContext globalContext;

    private DTreeItem dTreeItem;

    private boolean expand;

    /**
     * Default constructor.
     * 
     * @param globalContext
     *            the {@link GlobalContext} to synchronize the model.
     * @param domain
     *            the {@link TransactionalEditingDomain} on which execute this
     *            command
     * @param dTreeItem
     *            the {@link DTreeItem} to expand/collapse
     * @param expand
     *            true to expand, false to collapse
     */
    public DTreeItemExpansionChangeCommand(GlobalContext globalContext, TransactionalEditingDomain domain, DTreeItem dTreeItem, boolean expand) {
        super(domain, (expand ? "Expand" : "Collapse") + " \"" + dTreeItem.getName() + "\" tree item");
        this.globalContext = globalContext;
        this.dTreeItem = dTreeItem;
        this.expand = expand;
    }

    @Override
    protected void doExecute() {
        if (expand) {
            new DTreeItemUserInteraction(dTreeItem, globalContext).expand();
        } else {
            new DTreeItemUserInteraction(dTreeItem, globalContext).collapse();
        }
    }
}
