/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.views;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.ecore.extender.business.api.permission.IAuthorityListener;
import org.eclipse.sirius.ui.tools.internal.views.RefreshLabelImageJob;
import org.eclipse.sirius.ui.tools.internal.views.modelexplorer.PermissionAuthoritySessionManagerListener;
import org.eclipse.ui.navigator.CommonNavigator;

public class LockDecorationUpdater
implements IAuthorityListener {
    private RefreshLabelImageJob refreshJob;
    private CommonNavigator commonNavigator;
    private PermissionAuthoritySessionManagerListener permissionAuthoritySessionManagerListener = new PermissionAuthoritySessionManagerListener();

    public void register(CommonNavigator commonNavigatorToRefresh) {
        this.commonNavigator = commonNavigatorToRefresh;
        this.permissionAuthoritySessionManagerListener.register(this);
    }

    public void unregister() {
        this.permissionAuthoritySessionManagerListener.unregister();
        this.commonNavigator = null;
        this.refreshJob = null;
    }

    public void notifyIsLocked(EObject instance) {
        this.launchRefreshModelExplorerViewJob(Lists.newArrayList((Object[])new EObject[]{instance}));
    }

    public void notifyIsReleased(EObject instance) {
        this.launchRefreshModelExplorerViewJob(Lists.newArrayList((Object[])new EObject[]{instance}));
    }

    public void notifyIsLocked(Collection<EObject> instances) {
        this.launchRefreshModelExplorerViewJob(instances);
    }

    public void notifyIsReleased(Collection<EObject> instances) {
        this.launchRefreshModelExplorerViewJob(instances);
    }

    protected void launchRefreshModelExplorerViewJob(Collection<EObject> elements) {
        LinkedHashSet toRefresh = Sets.newLinkedHashSet();
        toRefresh.addAll(elements);
        if (this.refreshJob != null) {
            toRefresh.addAll(this.refreshJob.getElementsToRefresh());
            this.refreshJob.cancel();
        }
        this.refreshJob = new RefreshLabelImageJob(this.commonNavigator, toRefresh);
        this.refreshJob.schedule(200L);
    }
}

