/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session.danalysis;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.query.URIQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSession;
import org.eclipse.sirius.ecore.extender.tool.api.ModelUtils;
import org.eclipse.sirius.ext.emf.EReferencePredicate;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.ViewpointPackage;

public class DAnalysisRefresher
extends ResourceSetListenerImpl
implements ResourceSetListener {
    private Session session;

    public DAnalysisRefresher(Session session) {
        this.session = session;
    }

    public void init() {
        this.session.getTransactionalEditingDomain().addResourceSetListener((ResourceSetListener)this);
    }

    public NotificationFilter getFilter() {
        return NotificationFilter.createEventTypeFilter((int)3);
    }

    public boolean isPrecommitOnly() {
        return true;
    }

    public boolean isAggregatePrecommitListener() {
        return true;
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        CompoundCommand refreshDAnalysisCmds = new CompoundCommand();
        Map<DAnalysis, Set<EObject>> rootSemanticResourceEltsPerRepresentationsResource = this.getRootSemanticResourceEltsPerRepresentationsResource(event.getNotifications());
        for (Map.Entry<DAnalysis, Set<EObject>> entry : rootSemanticResourceEltsPerRepresentationsResource.entrySet()) {
            DAnalysis dAnalysis = entry.getKey();
            Set<EObject> rootSemanticResourceElts = entry.getValue();
            if (dAnalysis.getModels().containsAll(rootSemanticResourceElts)) continue;
            rootSemanticResourceElts.removeAll((Collection<?>)dAnalysis.getModels());
            Command refreshDAnalysisCmd = AddCommand.create((EditingDomain)event.getEditingDomain(), (Object)dAnalysis, (Object)ViewpointPackage.Literals.DANALYSIS__MODELS, rootSemanticResourceElts);
            refreshDAnalysisCmds.append(refreshDAnalysisCmd);
        }
        return refreshDAnalysisCmds;
    }

    public void manageAutomaticallyLoadedResources(List<Resource> knownResources) {
        TransactionalEditingDomain domain = this.session.getTransactionalEditingDomain();
        ArrayList resourcesAfterLoadOfSession = Lists.newArrayList((Iterable)domain.getResourceSet().getResources());
        Iterators.removeAll(resourcesAfterLoadOfSession.iterator(), knownResources);
        if (resourcesAfterLoadOfSession.isEmpty()) {
            return;
        }
        Set<Resource> referencedSessionResources = this.session.getReferencedSessionResources();
        ArrayList newReferencedSessionResources = Lists.newArrayList((Iterable)Iterables.filter((Iterable)resourcesAfterLoadOfSession, (Predicate)Predicates.in(referencedSessionResources)));
        if (!newReferencedSessionResources.isEmpty() && this.session instanceof DAnalysisSession) {
            for (Resource newReferencedSessionResource : newReferencedSessionResources) {
                this.registerResourceInCrossReferencer(newReferencedSessionResource);
                for (DAnalysis refAnalysis : Iterables.filter((Iterable)newReferencedSessionResource.getContents(), DAnalysis.class)) {
                    ((DAnalysisSession)this.session).addAdaptersOnAnalysis(refAnalysis);
                }
            }
        }
        Iterators.removeAll(resourcesAfterLoadOfSession.iterator(), this.session.getSemanticResources());
        Iterators.removeAll(resourcesAfterLoadOfSession.iterator(), referencedSessionResources);
        final Iterable newSemanticResourcesIterator = Iterables.filter((Iterable)resourcesAfterLoadOfSession, (Predicate)new Predicate<Resource>(){

            public boolean apply(Resource resource) {
                return !new URIQuery(resource.getURI()).isEnvironmentURI();
            }
        });
        if (!Iterables.isEmpty((Iterable)newSemanticResourcesIterator)) {
            domain.getCommandStack().execute((Command)new RecordingCommand(domain, "Add referenced semantic resources"){

                protected void doExecute() {
                    for (Resource resource : newSemanticResourcesIterator) {
                        DAnalysisRefresher.this.session.addSemanticResource(resource.getURI(), (IProgressMonitor)new NullProgressMonitor());
                    }
                }
            });
        }
    }

    public void forceLoadingOfEveryLinkedResource() {
        ModelUtils.resolveAll((ResourceSet)this.session.getTransactionalEditingDomain().getResourceSet(), (EReferencePredicate)new EReferencePredicate(){

            public boolean apply(EReference input) {
                return !input.isDerived() && !input.isContainer() && !input.isContainment();
            }
        });
    }

    public void resolveAllVSMResources(Collection<DAnalysis> allAnalysis) {
        ArrayList resolvedResources = Lists.newArrayList();
        for (DAnalysis dAnalysis : allAnalysis) {
            for (DView dView : dAnalysis.getOwnedViews()) {
                Resource vsmResource;
                if (dView.getViewpoint() == null || (vsmResource = dView.getViewpoint().eResource()) == null || resolvedResources.contains(vsmResource)) continue;
                ModelUtils.resolveAll((Resource)vsmResource, (boolean)true);
                resolvedResources.add(vsmResource);
            }
        }
    }

    private Map<DAnalysis, Set<EObject>> getRootSemanticResourceEltsPerRepresentationsResource(Collection<Notification> notifications) {
        HashMap<DAnalysis, Set<EObject>> rootSemanticResourceEltsPerRepresentationsResource = new HashMap<DAnalysis, Set<EObject>>();
        for (Notification notification : notifications) {
            DSemanticDecorator dSemanticDecorator;
            Resource representationsResource;
            Object newValue;
            if (3 != notification.getEventType() || !((newValue = notification.getNewValue()) instanceof DSemanticDecorator) || (representationsResource = (dSemanticDecorator = (DSemanticDecorator)newValue).eResource()) == null || dSemanticDecorator.getTarget() == null) continue;
            EObject representationsResourceRoot = (EObject)representationsResource.getContents().get(0);
            assert (representationsResourceRoot instanceof DAnalysis);
            DAnalysis dAnalysis = (DAnalysis)representationsResourceRoot;
            Resource targetResource = dSemanticDecorator.getTarget().eResource();
            this.updateMap(rootSemanticResourceEltsPerRepresentationsResource, targetResource, dAnalysis);
        }
        return rootSemanticResourceEltsPerRepresentationsResource;
    }

    private void updateMap(Map<DAnalysis, Set<EObject>> rootSemanticResourceEltsPerRepresentationsResource, Resource targetResource, DAnalysis dAnalysis) {
        if (targetResource != null) {
            EObject rootSemanticResourceElement = (EObject)targetResource.getContents().get(0);
            Set<EObject> rootSemanticResourceElts = rootSemanticResourceEltsPerRepresentationsResource.get(dAnalysis);
            if (rootSemanticResourceElts == null) {
                rootSemanticResourceElts = new HashSet<EObject>();
                rootSemanticResourceEltsPerRepresentationsResource.put(dAnalysis, rootSemanticResourceElts);
            }
            rootSemanticResourceElts.add(rootSemanticResourceElement);
        }
    }

    public void dispose() {
        this.session.getTransactionalEditingDomain().removeResourceSetListener((ResourceSetListener)this);
        this.session = null;
    }

    private void registerResourceInCrossReferencer(Resource newResource) {
        ECrossReferenceAdapter crossReferencer = this.session.getSemanticCrossReferencer();
        if (crossReferencer != null && !newResource.eAdapters().contains((Object)crossReferencer)) {
            newResource.eAdapters().add((Object)crossReferencer);
        }
    }
}

