/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.internal.resource;

import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.sirius.common.tools.api.resource.AbstractResourceSyncBackend;
import org.eclipse.sirius.common.tools.api.resource.ResourceSetSync;
import org.eclipse.sirius.common.tools.api.resource.ResourceSyncClient;
import org.eclipse.sirius.common.tools.internal.resource.EditingSessionWorkspaceListener;

public class WorkspaceBackend
extends AbstractResourceSyncBackend {
    private EditingSessionWorkspaceListener listener;

    public WorkspaceBackend(ResourceSyncClient client) {
        super(client);
    }

    boolean isChanged(ResourceSetSync.ResourceStatus oldStatus) {
        return oldStatus == ResourceSetSync.ResourceStatus.CHANGED || oldStatus == ResourceSetSync.ResourceStatus.CONFLICTING_CHANGED || oldStatus == ResourceSetSync.ResourceStatus.CONFLICTING_DELETED;
    }

    @Override
    public void install() {
        if (this.listener == null) {
            this.listener = new EditingSessionWorkspaceListener(this);
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            workspace.addResourceChangeListener((IResourceChangeListener)this.listener);
        }
    }

    @Override
    public void uninstall() {
        if (this.listener != null) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            workspace.removeResourceChangeListener((IResourceChangeListener)this.listener);
            this.listener = null;
        }
    }

    public ResourceSet getObservedSet() {
        return this.observedSet;
    }

    public ResourceSyncClient getClient() {
        return this.client;
    }
}

