/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.AbstractBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.tools.DragEditPartsTrackerEx;
import org.eclipse.gmf.runtime.draw2d.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.BorderedStyle;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElementAccessor;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.description.EndOfLifeMapping;
import org.eclipse.sirius.diagram.sequence.description.ExecutionMapping;
import org.eclipse.sirius.diagram.sequence.description.StateMapping;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.operation.SequenceEditPartsOperations;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.AbstractSequenceBorderedEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.InstanceRoleEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.figure.ExecutionItemLocator;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.figure.LifelineNodeFigure;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.figure.SouthCenteredBorderItemLocator;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.layout.LayoutEditPartConstants;
import org.eclipse.sirius.diagram.ui.tools.api.figure.anchor.AnchorProvider;
import org.eclipse.sirius.diagram.ui.tools.api.figure.locator.DBorderItemLocator;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.IStyleConfigurationRegistry;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.StyleConfiguration;
import org.eclipse.sirius.ui.tools.api.color.VisualBindingManager;
import org.eclipse.sirius.viewpoint.DStylizable;
import org.eclipse.sirius.viewpoint.Style;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;

public class LifelineEditPart
extends AbstractSequenceBorderedEditPart {
    private static final boolean ENABLE_LIFELINE_SELECTION = false;

    public LifelineEditPart(View view) {
        super(view);
    }

    public void refreshVisuals() {
        this.updateLifelineWidthAndColor();
        super.refreshVisuals();
        SequenceEditPartsOperations.setBorderItemLocation((AbstractBorderItemEditPart)this, 4, LayoutEditPartConstants.ROOT_EXECUTION_BORDER_ITEM_OFFSET);
    }

    private void updateLifelineWidthAndColor() {
        DDiagramElement dde = this.resolveDiagramElement();
        Style style = dde.getStyle();
        if (style instanceof BorderedStyle) {
            BorderedStyle borderedStyle = (BorderedStyle)style;
            int borderSize = borderedStyle.getBorderSize();
            Color fg = VisualBindingManager.getDefault().getColorFromRGBValues(borderedStyle.getBorderColor());
            this.nodePlate.setLineWidth(borderSize);
            if (fg != null) {
                this.nodePlate.setForegroundColor(fg);
            }
            if (this.nodePlate.getBorder() instanceof LineBorder) {
                LineBorder lineBorder = (LineBorder)this.nodePlate.getBorder();
                lineBorder.setWidth(borderSize);
                if (fg != null) {
                    lineBorder.setColor(fg);
                }
            }
        }
    }

    public void setSelected(int value) {
        this.getParent().setSelected(value);
    }

    public DragTracker getDragTracker(Request request) {
        if (request instanceof SelectionRequest) {
            return new LifeLineSelectionDragEditPartsTrackerEx((EditPart)this);
        }
        return super.getDragTracker(request);
    }

    public IBorderItemLocator createBorderItemLocator(IFigure figure, DDiagramElement vpElementBorderItem) {
        DBorderItemLocator result = vpElementBorderItem.getMapping() instanceof EndOfLifeMapping ? new SouthCenteredBorderItemLocator(figure, LayoutEditPartConstants.EOL_BORDER_ITEM_OFFSET) : (vpElementBorderItem.getMapping() instanceof ExecutionMapping || vpElementBorderItem.getMapping() instanceof StateMapping ? new ExecutionItemLocator((IGraphicalEditPart)this, figure) : super.createBorderItemLocator(figure, vpElementBorderItem));
        return result;
    }

    protected NodeFigure createNodePlate() {
        LifelineNodeFigure result = null;
        EObject eObj = this.resolveSemanticElement();
        if (eObj instanceof DStylizable && eObj instanceof DDiagramElement) {
            DStylizable viewNode = (DStylizable)eObj;
            StyleConfiguration styleConfiguration = IStyleConfigurationRegistry.INSTANCE.getStyleConfiguration(((DDiagramElement)eObj).getDiagramElementMapping(), viewNode.getStyle());
            AnchorProvider anchorProvider = styleConfiguration.getAnchorProvider();
            result = new LifelineNodeFigure(this.getMapMode().DPtoLP(5), this.getMapMode().DPtoLP(5), anchorProvider);
            this.nodePlate = result;
        }
        return result;
    }

    @Override
    public ISequenceEvent getISequenceEvent() {
        return (ISequenceEvent)ISequenceElementAccessor.getLifeline((View)this.getNotationView()).get();
    }

    private final class LifeLineSelectionDragEditPartsTrackerEx
    extends DragEditPartsTrackerEx {
        public LifeLineSelectionDragEditPartsTrackerEx(EditPart sourceEditPart) {
            super(sourceEditPart);
        }

        protected List createOperationSet() {
            List createOperationSet = super.createOperationSet();
            if (createOperationSet.contains(LifelineEditPart.this) && LifelineEditPart.this.getParent() instanceof InstanceRoleEditPart) {
                createOperationSet.add(LifelineEditPart.this.getParent());
            }
            return createOperationSet;
        }

        protected void performSelection() {
            if (this.hasSelectionOccurred()) {
                return;
            }
            this.setFlag(64, true);
            EditPartViewer viewer = this.getCurrentViewer();
            List selectedObjects = viewer.getSelectedEditParts();
            if (this.getCurrentInput().isModKeyDown(SWT.MOD1)) {
                if (selectedObjects.contains(this.getSourceEditPart().getParent())) {
                    viewer.deselect(this.getSourceEditPart());
                } else {
                    viewer.appendSelection(this.getSourceEditPart().getParent());
                }
            } else if (this.getCurrentInput().isShiftKeyDown()) {
                viewer.appendSelection(this.getSourceEditPart().getParent());
            } else {
                viewer.select(this.getSourceEditPart().getParent());
            }
        }

        protected void setCloneActive(boolean cloneActive) {
            super.setCloneActive(false);
        }
    }
}

