/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.edit.helpers;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.description.tool.ReconnectionKind;

public class EdgeReconnectionHelper {
    private List<Edge> reconnectionTargetEdges;
    private View reconnectionTarget;
    private ReconnectionKind reconnectionKind;

    public EdgeReconnectionHelper(View reconnectionTarget, List<Edge> reconnectionTargetEdges, ReconnectionKind reconnectionKind) {
        this.reconnectionTarget = reconnectionTarget;
        this.reconnectionTargetEdges = new ArrayList<Edge>(reconnectionTargetEdges);
        assert (reconnectionKind == ReconnectionKind.RECONNECT_SOURCE_LITERAL || reconnectionKind == ReconnectionKind.RECONNECT_TARGET_LITERAL) : "reconnectionKind must be ReconnectionKind.RECONNECT_SOURCE or ReconnectionKind.RECONNECT_TARGET";
        this.reconnectionKind = reconnectionKind;
    }

    public Edge getReconnectedEdge() {
        Edge edge = null;
        if (this.reconnectionKind == ReconnectionKind.RECONNECT_SOURCE_LITERAL) {
            final ArrayList sourceEdges = new ArrayList(this.reconnectionTarget.getSourceEdges());
            Iterables.removeAll(sourceEdges, this.reconnectionTargetEdges);
            Predicate<Edge> notToReconnectingEdge = new Predicate<Edge>(){

                public boolean apply(Edge input) {
                    return !sourceEdges.contains(input.getTarget());
                }
            };
            if (sourceEdges.isEmpty() && this.reconnectionTarget.getElement() instanceof AbstractDNode) {
                AbstractDNode abstractDNode = (AbstractDNode)this.reconnectionTarget.getElement();
                EList borderedNodes = abstractDNode.getOwnedBorderedNodes();
                if (!borderedNodes.isEmpty()) {
                    DNode borderedNode = (DNode)borderedNodes.get(borderedNodes.size() - 1);
                    Collection inverseReferences = new EObjectQuery((EObject)borderedNode).getInverseReferences(NotationPackage.eINSTANCE.getView_Element());
                    Node nodeSource = (Node)Iterables.getOnlyElement((Iterable)Iterables.filter((Iterable)inverseReferences, Node.class));
                    ArrayList sourceEdgesOfBorderedNode = new ArrayList(nodeSource.getSourceEdges());
                    edge = (Edge)Iterables.getOnlyElement((Iterable)Iterables.filter(sourceEdgesOfBorderedNode, (Predicate)notToReconnectingEdge));
                }
            } else {
                edge = (Edge)Iterables.getOnlyElement((Iterable)Iterables.filter(sourceEdges, (Predicate)notToReconnectingEdge));
            }
        } else {
            final ArrayList targetEdges = new ArrayList(this.reconnectionTarget.getTargetEdges());
            Iterables.removeAll(targetEdges, this.reconnectionTargetEdges);
            Predicate<Edge> notFromReconnectingEdge = new Predicate<Edge>(){

                public boolean apply(Edge input) {
                    return !targetEdges.contains(input.getSource());
                }
            };
            if (targetEdges.isEmpty() && this.reconnectionTarget.getElement() instanceof AbstractDNode) {
                AbstractDNode abstractDNode = (AbstractDNode)this.reconnectionTarget.getElement();
                EList borderedNodes = abstractDNode.getOwnedBorderedNodes();
                if (!borderedNodes.isEmpty()) {
                    DNode borderedNode = (DNode)borderedNodes.get(borderedNodes.size() - 1);
                    Collection inverseReferences = new EObjectQuery((EObject)borderedNode).getInverseReferences(NotationPackage.eINSTANCE.getView_Element());
                    Node nodeTarget = (Node)Iterables.getOnlyElement((Iterable)Iterables.filter((Iterable)inverseReferences, Node.class));
                    ArrayList targetEdgesOfBorderedNode = new ArrayList(nodeTarget.getTargetEdges());
                    edge = (Edge)Iterables.getOnlyElement((Iterable)Iterables.filter(targetEdgesOfBorderedNode, (Predicate)notFromReconnectingEdge));
                }
            } else {
                edge = (Edge)Iterables.getOnlyElement((Iterable)Iterables.filter(targetEdges, (Predicate)notFromReconnectingEdge));
            }
        }
        return edge;
    }
}

