/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.edit.internal.part;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationPreCommitListener;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.ContainerStyle;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeListElement;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.diagram.NodeStyle;
import org.eclipse.sirius.diagram.business.api.helper.display.DisplayServiceManager;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.business.internal.experimental.sync.DDiagramElementSynchronizer;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.ui.business.internal.query.StyleConfigurationQuery;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramBorderNodeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramNameEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramNodeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IStyleEditPart;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.tools.api.figure.SiriusWrapLabel;
import org.eclipse.sirius.diagram.ui.tools.api.figure.StyledFigure;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.IStyleConfigurationRegistry;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.StyleConfiguration;
import org.eclipse.sirius.diagram.ui.tools.api.part.IDiagramDialectGraphicalViewer;
import org.eclipse.sirius.diagram.ui.tools.internal.commands.SemanticChangedCommand;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.sirius.ui.tools.api.color.VisualBindingManager;
import org.eclipse.sirius.viewpoint.BasicLabelStyle;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.DStylizable;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.LabelStyle;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.Style;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public final class DiagramElementEditPartOperation {
    private DiagramElementEditPartOperation() {
    }

    public static DDiagramElement resolveDiagramElement(IDiagramElementEditPart self) {
        EObject semanticHost = self.resolveSemanticElement();
        if (semanticHost instanceof DDiagramElement) {
            return (DDiagramElement)semanticHost;
        }
        return null;
    }

    public static void registerModel(IDiagramElementEditPart self) {
        EObject semantic;
        EditPartViewer viewer = self.getViewer();
        if (viewer instanceof IDiagramDialectGraphicalViewer && (semantic = self.resolveTargetSemanticElement()) != null) {
            ((IDiagramDialectGraphicalViewer)viewer).registerEditPartForSemanticElement(semantic, (EditPart)self);
        }
    }

    public static void unregisterModel(IDiagramElementEditPart self) {
        EditPartViewer viewer = self.getViewer();
        if (viewer instanceof IDiagramDialectGraphicalViewer) {
            EObject semantic = self.resolveTargetSemanticElement();
            IDiagramDialectGraphicalViewer gViewer = (IDiagramDialectGraphicalViewer)viewer;
            if (semantic != null) {
                gViewer.unregisterEditPartForSemanticElement(semantic, (EditPart)self);
            } else {
                gViewer.unregisterEditPart((EditPart)self);
            }
        }
    }

    public static EObject resolveTargetSemanticElement(IDiagramElementEditPart self) {
        EObject semanticHost = self.resolveSemanticElement();
        if (semanticHost instanceof DSemanticDecorator) {
            return ((DSemanticDecorator)semanticHost).getTarget();
        }
        return null;
    }

    public static NotificationPreCommitListener createEAdpaterSemanticElements(final IDiagramElementEditPart self) {
        return new NotificationPreCommitListener(){

            public Command transactionAboutToCommit(Notification msg) {
                return new SemanticChangedCommand(self.getEditingDomain(), self, msg);
            }
        };
    }

    public static void semanticChanged(IDiagramElementEditPart self, Notification message) {
        IPermissionAuthority auth = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(self.getEditingDomain().getResourceSet());
        if (auth.canEditInstance(self.resolveSemanticElement())) {
            switch (message.getEventType()) {
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 7: {
                    DiagramElementEditPartOperation.refreshSemantic(self);
                    DiagramElementEditPartOperation.refreshLabelIcon(self);
                    break;
                }
            }
        }
    }

    private static void refreshLabelIcon(IDiagramElementEditPart self) {
        if (self instanceof IDiagramNodeEditPart && ((IDiagramNodeEditPart)self).getNodeLabel() != null && ((IDiagramNodeEditPart)self).getNodeLabel().getParent() != null) {
            DiagramElementEditPartOperation.refreshIcon(((IDiagramNodeEditPart)self).getNodeLabel(), self.getLabelIcon());
        } else if (self instanceof IDiagramBorderNodeEditPart && ((IDiagramBorderNodeEditPart)self).getNodeLabel() != null && ((IDiagramBorderNodeEditPart)self).getNodeLabel().getParent() != null) {
            DiagramElementEditPartOperation.refreshIcon(((IDiagramBorderNodeEditPart)self).getNodeLabel(), self.getLabelIcon());
        } else if (self instanceof IDiagramNameEditPart) {
            DiagramElementEditPartOperation.refreshIcon((IDiagramNameEditPart)self);
        } else {
            for (IDiagramNameEditPart nameEditPart : Iterables.filter((Iterable)self.getChildren(), IDiagramNameEditPart.class)) {
                DiagramElementEditPartOperation.refreshIcon(nameEditPart);
            }
        }
    }

    private static void refreshIcon(SiriusWrapLabel figure, Image icon) {
        if (figure != null) {
            figure.setIcon(icon);
        }
    }

    private static void refreshIcon(IDiagramNameEditPart self) {
        IFigure figure = self.getFigure();
        if (figure != null) {
            if (figure instanceof SiriusWrapLabel) {
                ((SiriusWrapLabel)figure).setIcon(self.getLabelIcon());
            } else {
                ((Label)figure).setIcon(self.getLabelIcon());
            }
        }
    }

    private static void refreshSemantic(IDiagramElementEditPart self) {
        Session session;
        DSemanticDiagram semDiag;
        DDiagram diagram;
        DDiagramElement dde = self.resolveDiagramElement();
        DDiagram dDiagram = diagram = dde == null ? null : dde.getParentDiagram();
        if (dde != null && diagram instanceof DSemanticDiagram && (semDiag = (DSemanticDiagram)diagram).getTarget() != null && (session = SessionManager.INSTANCE.getSession(semDiag.getTarget())) != null) {
            DDiagramElementSynchronizer sync = new DDiagramElementSynchronizer(semDiag, session.getInterpreter(), SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(semDiag.getTarget()));
            sync.refresh(dde);
        }
    }

    public static NotificationListener createEApdaterDiagramElement(final IDiagramElementEditPart self) {
        return new NotificationListener(){

            public void notifyChanged(Notification msg) {
                DiagramElementEditPartOperation.diagramElementChanged(self, msg);
            }
        };
    }

    private static void diagramElementChanged(IDiagramElementEditPart self, Notification notification) {
        if (!self.isActive() || !(self instanceof NotificationListener) || DiagramElementEditPartOperation.hasDanglingNotationView(self)) {
            return;
        }
        DiagramEventBroker broker = DiagramElementEditPartOperation.getDiagramEventBroker(self);
        if (DiagramPackage.eINSTANCE.getDNode_OwnedStyle().equals(notification.getFeature())) {
            if (notification.getOldValue() instanceof NodeStyle) {
                NodeStyle oldNodeStyle = (NodeStyle)notification.getOldValue();
                broker.removeNotificationListener((EObject)oldNodeStyle, (NotificationListener)self);
            }
            if (notification.getNewValue() instanceof NodeStyle) {
                NodeStyle newNodeStyle = (NodeStyle)notification.getNewValue();
                broker.addNotificationListener((EObject)newNodeStyle, (NotificationListener)self);
            }
            self.refresh();
        } else if (DiagramPackage.eINSTANCE.getDDiagramElementContainer_OwnedStyle().equals(notification.getFeature())) {
            if (notification.getOldValue() instanceof ContainerStyle) {
                ContainerStyle oldContainerStyle = (ContainerStyle)notification.getOldValue();
                broker.removeNotificationListener((EObject)oldContainerStyle, (NotificationListener)self);
            }
            if (notification.getNewValue() instanceof ContainerStyle) {
                ContainerStyle newContainerStyle = (ContainerStyle)notification.getNewValue();
                broker.addNotificationListener((EObject)newContainerStyle, (NotificationListener)self);
            }
            self.refresh();
        } else if (DiagramPackage.eINSTANCE.getDEdge_OwnedStyle().equals(notification.getFeature())) {
            if (notification.getOldValue() instanceof EdgeStyle) {
                EdgeStyle oldEdgeStyle = (EdgeStyle)notification.getOldValue();
                broker.removeNotificationListener((EObject)oldEdgeStyle, (NotificationListener)self);
            }
            if (notification.getNewValue() instanceof EdgeStyle) {
                EdgeStyle newEdgeStyle = (EdgeStyle)notification.getNewValue();
                broker.addNotificationListener((EObject)newEdgeStyle, (NotificationListener)self);
            }
            self.refresh();
        }
    }

    private static boolean hasDanglingNotationView(IDiagramElementEditPart self) {
        boolean danglingView = false;
        View notationView = self.getNotationView();
        boolean bl = danglingView = notationView == null || notationView.eContainer() == null;
        if (!danglingView && notationView instanceof Edge) {
            Edge edge = (Edge)notationView;
            danglingView = edge.getSource() == null || edge.getTarget() == null;
        }
        return danglingView;
    }

    public static List<EObject> resolveAllSemanticElements(IDiagramElementEditPart self) {
        DDiagramElement diagramElement = self.resolveDiagramElement();
        if (diagramElement != null) {
            return diagramElement.getSemanticElements();
        }
        return Collections.emptyList();
    }

    public static IStyleEditPart getStyleEditPart(IDiagramElementEditPart self) {
        IStyleEditPart result = null;
        Iterator iterChildren = self.getChildren().iterator();
        while (iterChildren.hasNext() && result == null) {
            EditPart nextChild = (EditPart)iterChildren.next();
            if (!(nextChild instanceof IStyleEditPart)) continue;
            result = (IStyleEditPart)nextChild;
        }
        return result;
    }

    public static void activate(IDiagramElementEditPart self) {
        Iterator<EObject> iterSemanticElements = self.resolveAllSemanticElements().iterator();
        DiagramEventBroker broker = DiagramElementEditPartOperation.getDiagramEventBroker(self);
        DiagramElementEditPartOperation.addNavigateDecoratorRefresher(self, broker);
        while (iterSemanticElements.hasNext()) {
            EObject semantic = iterSemanticElements.next();
            if (self.getEAdapterSemanticElements() != null) {
                broker.addNotificationListener(semantic, self.getEAdapterSemanticElements());
            }
            if (self.getEditModeListener() != null) {
                broker.addNotificationListener(semantic, self.getEditModeListener());
            }
            if (semantic.eContainer() == null || self.getEditModeListener() == null) continue;
            broker.addNotificationListener(semantic.eContainer(), self.getEditModeListener());
        }
        DDiagramElement element = self.resolveDiagramElement();
        if (element != null && self.getEAdapterDiagramElement() != null) {
            broker.addNotificationListener((EObject)element, self.getEAdapterDiagramElement());
        }
        if (element instanceof DNode) {
            DNode viewNode = (DNode)element;
            if (viewNode.getOwnedStyle() != null && self instanceof NotificationListener) {
                broker.addNotificationListener((EObject)viewNode.getOwnedStyle(), (NotificationListener)self);
            }
        } else if (element instanceof DDiagramElementContainer && self instanceof NotificationListener) {
            DDiagramElementContainer viewPointElementContainer = (DDiagramElementContainer)element;
            if (viewPointElementContainer.getOwnedStyle() != null) {
                broker.addNotificationListener((EObject)viewPointElementContainer.getOwnedStyle(), (NotificationListener)self);
            }
        } else if (element instanceof DEdge) {
            DEdge viewEdge = (DEdge)element;
            if (viewEdge.getOwnedStyle() != null && self instanceof NotificationListener) {
                broker.addNotificationListener((EObject)viewEdge.getOwnedStyle(), (NotificationListener)self);
            }
        } else if (element instanceof DNodeListElement) {
            DNodeListElement dNodeListElement = (DNodeListElement)element;
            if (self instanceof NotificationListener) {
                broker.addNotificationListener((EObject)dNodeListElement.getOwnedStyle(), (NotificationListener)self);
            }
        }
    }

    private static void addNavigateDecoratorRefresher(IDiagramElementEditPart self, DiagramEventBroker broker) {
        EObject semanticElement = self.resolveSemanticElement();
        Session session = new EObjectQuery(semanticElement).getSession();
        if (session != null && self instanceof NotificationListener) {
            for (DView dView : session.getSelectedViews()) {
                broker.addNotificationListener((EObject)dView, (EStructuralFeature)ViewpointPackage.Literals.DVIEW__OWNED_REPRESENTATIONS, (NotificationListener)self);
            }
        }
    }

    private static void removeNavigateDecoratorRefresher(IDiagramElementEditPart self, DiagramEventBroker broker) {
        EObject semanticElement = self.resolveSemanticElement();
        Session session = new EObjectQuery(semanticElement).getSession();
        if (session != null && self instanceof NotificationListener) {
            for (DView dView : session.getSelectedViews()) {
                broker.removeNotificationListener((EObject)dView, (Object)ViewpointPackage.Literals.DVIEW__OWNED_REPRESENTATIONS, (NotificationListener)self);
            }
        }
    }

    private static DiagramEventBroker getDiagramEventBroker(IDiagramElementEditPart self) {
        TransactionalEditingDomain theEditingDomain = self.getEditingDomain();
        if (theEditingDomain != null) {
            return DiagramEventBroker.getInstance((TransactionalEditingDomain)theEditingDomain);
        }
        return null;
    }

    public static void deactivate(IDiagramElementEditPart self) {
        if (self.isActive()) {
            DiagramEventBroker broker = DiagramElementEditPartOperation.getDiagramEventBroker(self);
            List<EObject> resolveAllSemanticElements = self.resolveAllSemanticElements();
            if (resolveAllSemanticElements != null) {
                Iterator<EObject> iterSemanticElements = resolveAllSemanticElements.iterator();
                DiagramElementEditPartOperation.removeNavigateDecoratorRefresher(self, broker);
                while (iterSemanticElements.hasNext()) {
                    EObject semantic = iterSemanticElements.next();
                    DiagramElementEditPartOperation.removeListener(broker, semantic, self.getEAdapterSemanticElements());
                    DiagramElementEditPartOperation.removeListener(broker, semantic, self.getEditModeListener());
                    try {
                        if (semantic.eContainer() == null) continue;
                        DiagramElementEditPartOperation.removeListener(broker, semantic.eContainer(), self.getEditModeListener());
                    }
                    catch (IllegalStateException illegalStateException) {
                        if (!DiagramUIPlugin.getPlugin().isDebugging()) continue;
                        DiagramUIPlugin.getPlugin().getLog().log((IStatus)new Status(2, "org.eclipse.sirius.diagram.ui", "Error while connecting to remote CDO server"));
                    }
                }
                DDiagramElement stylizable = self.resolveDiagramElement();
                if (stylizable != null && stylizable.getStyle() != null && self instanceof NotificationListener) {
                    DiagramElementEditPartOperation.removeListener(broker, (EObject)stylizable.getStyle(), (NotificationListener)self);
                }
                if (stylizable != null) {
                    DiagramElementEditPartOperation.removeListener(broker, (EObject)stylizable, self.getEAdapterDiagramElement());
                }
            }
        }
    }

    private static void removeListener(DiagramEventBroker broker, EObject listened, NotificationPreCommitListener listener) {
        boolean oldDeliver = listened.eDeliver();
        listened.eSetDeliver(true);
        broker.removeNotificationListener(listened, listener);
        listened.eSetDeliver(oldDeliver);
    }

    private static void removeListener(DiagramEventBroker broker, EObject listened, NotificationListener listener) {
        boolean oldDeliver = listened.eDeliver();
        listened.eSetDeliver(true);
        broker.removeNotificationListener(listened, listener);
        listened.eSetDeliver(oldDeliver);
    }

    public static void removeInvisibleElements(List<?> modelChildren) {
        DDiagram parentDiagram = null;
        Iterator<?> iterModel = modelChildren.iterator();
        while (iterModel.hasNext()) {
            View view;
            EObject element;
            Object object = iterModel.next();
            if (!(object instanceof View) || !((element = (view = (View)object).getElement()) instanceof DDiagramElement)) continue;
            DDiagramElement diagramElement = (DDiagramElement)element;
            if (parentDiagram == null) {
                parentDiagram = diagramElement.getParentDiagram();
            }
            if (!DiagramElementEditPartOperation.isHidden(diagramElement, parentDiagram)) continue;
            iterModel.remove();
        }
    }

    private static boolean isHidden(DDiagramElement diagramElement, DDiagram parentDiagram) {
        EObject diagramElementContainer = diagramElement.eContainer();
        return diagramElementContainer != null && !DisplayServiceManager.INSTANCE.getDisplayService().isDisplayed(parentDiagram, diagramElement);
    }

    public static Image getLabelIcon(IDiagramElementEditPart self) {
        if (self.getMetamodelType().isInstance(self.resolveSemanticElement())) {
            DDiagramElement element = self.resolveDiagramElement();
            DiagramElementMapping mapping = element.getDiagramElementMapping();
            Style style = element.getStyle();
            StyleConfiguration styleConfiguration = IStyleConfigurationRegistry.INSTANCE.getStyleConfiguration(mapping, style);
            Image image = new StyleConfigurationQuery(styleConfiguration).getLabelIcon(element, self);
            return image;
        }
        return null;
    }

    public static StyledFigure getStyledFigure(IFigure figure) {
        StyledFigure styledFigure = null;
        if (figure instanceof StyledFigure) {
            styledFigure = (StyledFigure)figure;
        } else {
            for (IFigure childFigure : Iterables.filter((Iterable)figure.getChildren(), IFigure.class)) {
                styledFigure = DiagramElementEditPartOperation.getStyledFigure(childFigure);
                if (styledFigure != null) break;
            }
        }
        return styledFigure;
    }

    public static void refreshFont(IDiagramElementEditPart self, EObject eObj, IFigure figure) {
        Style style;
        if (eObj instanceof DStylizable && (style = ((DStylizable)eObj).getStyle()) instanceof LabelStyle) {
            LabelStyle lStyle = (LabelStyle)style;
            figure.setFont(VisualBindingManager.getDefault().getFontFromLabelStyle((BasicLabelStyle)lStyle, DiagramElementEditPartOperation.getFontName(self)));
            FontStyle fontStyle = (FontStyle)self.getNotationView().getStyle(NotationPackage.eINSTANCE.getFontStyle());
            if (fontStyle != null && figure instanceof SiriusWrapLabel) {
                SiriusWrapLabel wrap = (SiriusWrapLabel)figure;
                wrap.setTextUnderline(fontStyle.isUnderline());
                wrap.setTextStrikeThrough(fontStyle.isStrikeThrough());
            }
            RGBValues labelRGBColor = lStyle.getLabelColor();
            Color labelColor = VisualBindingManager.getDefault().getLabelColorFromRGBValues(labelRGBColor);
            if (!figure.getForegroundColor().equals((Object)labelColor)) {
                figure.setForegroundColor(labelColor);
            }
        }
    }

    private static String getFontName(IDiagramElementEditPart self) {
        FontStyle fontStyle = DiagramElementEditPartOperation.getFontStyle(self);
        if (fontStyle != null) {
            return fontStyle.getFontName();
        }
        return null;
    }

    private static FontStyle getFontStyle(IDiagramElementEditPart self) {
        FontStyle fontStyle = (FontStyle)self.getNotationView().getStyle(NotationPackage.eINSTANCE.getFontStyle());
        if (fontStyle == null && self.getParent() instanceof IDiagramElementEditPart) {
            IDiagramElementEditPart parent = (IDiagramElementEditPart)self.getParent();
            fontStyle = (FontStyle)parent.getNotationView().getStyle(NotationPackage.eINSTANCE.getFontStyle());
        }
        return fontStyle;
    }
}

