/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.figure.locator;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderItemLocator;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public class DBorderItemLocator
extends BorderItemLocator {
    private static final int NB_SIDES = 4;
    private Dimension leftTopOffset;
    private Dimension rightBottomOffset;
    private boolean located;
    private boolean borderItemHasMoved;
    private List<IFigure> figuresToIgnoreDuringNextRelocate = Lists.newArrayList();

    public DBorderItemLocator(IFigure parentFigure) {
        super(parentFigure);
    }

    public DBorderItemLocator(IFigure borderItem, IFigure parentFigure, Rectangle constraint) {
        super(borderItem, parentFigure, constraint);
    }

    public DBorderItemLocator(IFigure parentFigure, int preferredSide) {
        super(parentFigure, preferredSide);
    }

    public void setRightBottomOffset(Dimension rightBottomOffset) {
        this.rightBottomOffset = rightBottomOffset;
    }

    public Dimension getRightBottomOffset() {
        if (this.rightBottomOffset != null) {
            return this.rightBottomOffset;
        }
        return this.getBorderItemOffset();
    }

    public void setLeftTopOffset(Dimension leftTopOffset) {
        this.leftTopOffset = leftTopOffset;
    }

    public Dimension getLeftTopOffset() {
        if (this.leftTopOffset != null) {
            return this.leftTopOffset;
        }
        return this.getBorderItemOffset();
    }

    protected Point getPreferredLocation(IFigure borderItem) {
        Point constraintLocation = this.getConstraint().getLocation();
        Point ptAbsoluteLocation = this.getAbsoluteToBorder(constraintLocation);
        return ptAbsoluteLocation;
    }

    public void relocate(IFigure borderItem) {
        Rectangle parentBounds = this.getParentFigure().getBounds().getCopy();
        if (parentBounds.x != 0 || parentBounds.y != 0 || parentBounds.width > 0 || parentBounds.height > 0) {
            Dimension size = this.getSize(borderItem);
            Rectangle rectSuggested = new Rectangle(this.getPreferredLocation(borderItem), size);
            if (this.borderItemHasMoved) {
                int closestSide = DBorderItemLocator.findClosestSideOfParent(rectSuggested, this.getParentBorder());
                this.setPreferredSideOfParent(closestSide);
                this.setCurrentSideOfParent(closestSide);
                this.borderItemHasMoved = false;
            } else {
                this.figuresToIgnoreDuringNextRelocate.clear();
            }
            Point ptNewLocation = this.locateOnBorder(rectSuggested.getLocation(), this.getCurrentSideOfParent(), 0, borderItem, this.figuresToIgnoreDuringNextRelocate, new ArrayList<IFigure>());
            borderItem.setLocation(ptNewLocation);
            this.figuresToIgnoreDuringNextRelocate.clear();
            borderItem.setSize(size);
            this.located = true;
        }
    }

    protected Point locateOnBorder(Point suggestedLocation, int suggestedSide, int circuitCount, IFigure borderItem) {
        ArrayList figuresToIgnore = Lists.newArrayList();
        figuresToIgnore.add(borderItem);
        return this.locateOnBorder(suggestedLocation, suggestedSide, circuitCount, borderItem, figuresToIgnore, new ArrayList<IFigure>());
    }

    protected Point locateOnBorder(Point suggestedLocation, int suggestedSide, int circuitCount, IFigure borderItem, Collection<IFigure> portsFiguresToIgnore, List<IFigure> additionalFiguresForConflictDetection) {
        Point recommendedLocation = this.locateOnParent(suggestedLocation, suggestedSide, borderItem);
        if (circuitCount < 4 && this.conflicts(recommendedLocation, borderItem, portsFiguresToIgnore, additionalFiguresForConflictDetection).some()) {
            recommendedLocation = suggestedSide == 8 ? this.locateOnWestBorder(recommendedLocation, circuitCount, borderItem, portsFiguresToIgnore, additionalFiguresForConflictDetection) : (suggestedSide == 4 ? this.locateOnSouthBorder(recommendedLocation, circuitCount, borderItem, portsFiguresToIgnore, additionalFiguresForConflictDetection) : (suggestedSide == 16 ? this.locateOnEastBorder(recommendedLocation, circuitCount, borderItem, portsFiguresToIgnore, additionalFiguresForConflictDetection) : this.locateOnNorthBorder(recommendedLocation, circuitCount, borderItem, portsFiguresToIgnore, additionalFiguresForConflictDetection)));
        }
        return recommendedLocation;
    }

    protected Point locateOnSouthBorder(Point recommendedLocation, int circuitCount, IFigure borderItem, Collection<IFigure> portsFiguresToIgnore, List<IFigure> additionalFiguresForConflictDetection) {
        Dimension borderItemSize = this.getSize(borderItem);
        Point resultLocation = null;
        Point rightTestPoint = new Point(recommendedLocation);
        Point leftTestPoint = new Point(recommendedLocation);
        boolean isStillFreeSpaceToTheRight = true;
        boolean isStillFreeSpaceToTheLeft = true;
        int rightVerticalGap = 0;
        int leftVerticalGap = 0;
        Point recommendedLocationForEast = recommendedLocation;
        while (resultLocation == null && (isStillFreeSpaceToTheRight || isStillFreeSpaceToTheLeft)) {
            Option<Rectangle> optionalConflictingRectangle;
            if (isStillFreeSpaceToTheRight) {
                rightTestPoint.x += rightVerticalGap;
                optionalConflictingRectangle = this.conflicts(rightTestPoint, borderItem, portsFiguresToIgnore, additionalFiguresForConflictDetection);
                if (optionalConflictingRectangle.some()) {
                    rightVerticalGap = ((Rectangle)optionalConflictingRectangle.get()).x + ((Rectangle)optionalConflictingRectangle.get()).width + 1 - rightTestPoint.x;
                    if (rightTestPoint.x + rightVerticalGap + borderItemSize.width > this.getParentBorder().getBottomRight().x) {
                        isStillFreeSpaceToTheRight = false;
                        if (circuitCount == 3) {
                            resultLocation = ((Rectangle)optionalConflictingRectangle.get()).getTopLeft();
                        } else {
                            recommendedLocationForEast = new Point(rightTestPoint.x + rightVerticalGap, ((Rectangle)optionalConflictingRectangle.get()).y - borderItemSize.height - 1);
                        }
                    }
                } else {
                    resultLocation = rightTestPoint;
                }
            }
            if (!isStillFreeSpaceToTheLeft || resultLocation != null) continue;
            leftTestPoint.x -= leftVerticalGap;
            optionalConflictingRectangle = this.conflicts(leftTestPoint, borderItem, portsFiguresToIgnore, additionalFiguresForConflictDetection);
            if (optionalConflictingRectangle.some()) {
                leftVerticalGap = leftTestPoint.x - (((Rectangle)optionalConflictingRectangle.get()).x - borderItemSize.width - 1);
                if (leftTestPoint.x - leftVerticalGap >= this.getParentBorder().getTopLeft().x) continue;
                isStillFreeSpaceToTheLeft = false;
                continue;
            }
            resultLocation = leftTestPoint;
        }
        if (resultLocation == null) {
            resultLocation = this.locateOnBorder(recommendedLocationForEast, 16, circuitCount + 1, borderItem, portsFiguresToIgnore, additionalFiguresForConflictDetection);
        }
        return resultLocation;
    }

    protected Point locateOnNorthBorder(Point recommendedLocation, int circuitCount, IFigure borderItem, Collection<IFigure> portsFiguresToIgnore, List<IFigure> additionalFiguresForConflictDetection) {
        Dimension borderItemSize = this.getSize(borderItem);
        Point resultLocation = null;
        Point rightTestPoint = new Point(recommendedLocation);
        Point leftTestPoint = new Point(recommendedLocation);
        boolean isStillFreeSpaceToTheRight = true;
        boolean isStillFreeSpaceToTheLeft = true;
        int rightVerticalGap = 0;
        int leftVerticalGap = 0;
        Point recommendedLocationForWest = recommendedLocation;
        while (resultLocation == null && (isStillFreeSpaceToTheRight || isStillFreeSpaceToTheLeft)) {
            Option<Rectangle> optionalConflictingRectangle;
            if (isStillFreeSpaceToTheRight) {
                rightTestPoint.x += rightVerticalGap;
                optionalConflictingRectangle = this.conflicts(rightTestPoint, borderItem, portsFiguresToIgnore, additionalFiguresForConflictDetection);
                if (optionalConflictingRectangle.some()) {
                    rightVerticalGap = ((Rectangle)optionalConflictingRectangle.get()).x + ((Rectangle)optionalConflictingRectangle.get()).width + 1 - rightTestPoint.x;
                    if (rightTestPoint.x + rightVerticalGap + borderItemSize.width > this.getParentBorder().getBottomRight().x) {
                        isStillFreeSpaceToTheRight = false;
                    }
                } else {
                    resultLocation = rightTestPoint;
                }
            }
            if (!isStillFreeSpaceToTheLeft || resultLocation != null) continue;
            leftTestPoint.x -= leftVerticalGap;
            optionalConflictingRectangle = this.conflicts(leftTestPoint, borderItem, portsFiguresToIgnore, additionalFiguresForConflictDetection);
            if (optionalConflictingRectangle.some()) {
                leftVerticalGap = leftTestPoint.x - (((Rectangle)optionalConflictingRectangle.get()).x - borderItemSize.width - 1);
                if (leftTestPoint.x - leftVerticalGap >= this.getParentBorder().getTopLeft().x) continue;
                isStillFreeSpaceToTheLeft = false;
                if (circuitCount == 3) {
                    resultLocation = ((Rectangle)optionalConflictingRectangle.get()).getTopLeft();
                    continue;
                }
                recommendedLocationForWest = new Point(leftTestPoint.x - leftVerticalGap, ((Rectangle)optionalConflictingRectangle.get()).y + ((Rectangle)optionalConflictingRectangle.get()).height + 1);
                continue;
            }
            resultLocation = leftTestPoint;
        }
        if (resultLocation == null) {
            resultLocation = this.locateOnBorder(recommendedLocationForWest, 8, circuitCount + 1, borderItem, portsFiguresToIgnore, additionalFiguresForConflictDetection);
        }
        return resultLocation;
    }

    protected Point locateOnWestBorder(Point recommendedLocation, int circuitCount, IFigure borderItem, Collection<IFigure> portsFiguresToIgnore, List<IFigure> additionalFiguresForConflictDetection) {
        Dimension borderItemSize = this.getSize(borderItem);
        Point resultLocation = null;
        Point belowTestPoint = new Point(recommendedLocation);
        Point aboveTestPoint = new Point(recommendedLocation);
        boolean isStillFreeSpaceAbove = true;
        boolean isStillFreeSpaceBelow = true;
        int belowVerticalGap = 0;
        int aboveVerticalGap = 0;
        Point recommendedLocationForSouth = recommendedLocation;
        while (resultLocation == null && (isStillFreeSpaceAbove || isStillFreeSpaceBelow)) {
            Option<Rectangle> optionalConflictingRectangle;
            if (isStillFreeSpaceBelow) {
                belowTestPoint.y += belowVerticalGap;
                optionalConflictingRectangle = this.conflicts(belowTestPoint, borderItem, portsFiguresToIgnore, additionalFiguresForConflictDetection);
                if (optionalConflictingRectangle.some()) {
                    belowVerticalGap = ((Rectangle)optionalConflictingRectangle.get()).y + ((Rectangle)optionalConflictingRectangle.get()).height - belowTestPoint.y + 1;
                    if (belowTestPoint.y + belowVerticalGap + borderItemSize.height > this.getParentBorder().getBottomLeft().y) {
                        isStillFreeSpaceBelow = false;
                        if (circuitCount == 3) {
                            resultLocation = ((Rectangle)optionalConflictingRectangle.get()).getTopLeft();
                        } else {
                            recommendedLocationForSouth = new Point(belowTestPoint.x + ((Rectangle)optionalConflictingRectangle.get()).width + 1, belowTestPoint.y + belowVerticalGap);
                        }
                    }
                } else {
                    resultLocation = belowTestPoint;
                }
            }
            if (!isStillFreeSpaceAbove || resultLocation != null) continue;
            aboveTestPoint.y -= aboveVerticalGap;
            optionalConflictingRectangle = this.conflicts(aboveTestPoint, borderItem, portsFiguresToIgnore, additionalFiguresForConflictDetection);
            if (optionalConflictingRectangle.some()) {
                aboveVerticalGap = aboveTestPoint.y - (((Rectangle)optionalConflictingRectangle.get()).y - borderItemSize.height - 1);
                if (aboveTestPoint.y - aboveVerticalGap >= this.getParentBorder().getTopRight().y) continue;
                isStillFreeSpaceAbove = false;
                continue;
            }
            resultLocation = aboveTestPoint;
        }
        if (resultLocation == null) {
            resultLocation = this.locateOnBorder(recommendedLocationForSouth, 4, circuitCount + 1, borderItem, portsFiguresToIgnore, additionalFiguresForConflictDetection);
        }
        return resultLocation;
    }

    protected Point locateOnEastBorder(Point recommendedLocation, int circuitCount, IFigure borderItem, Collection<IFigure> portsFiguresToIgnore, List<IFigure> additionalFiguresForConflictDetection) {
        Dimension borderItemSize = this.getSize(borderItem);
        Point resultLocation = null;
        Point belowTestPoint = new Point(recommendedLocation);
        Point aboveTestPoint = new Point(recommendedLocation);
        boolean isStillFreeSpaceAbove = true;
        boolean isStillFreeSpaceBelow = true;
        int belowVerticalGap = 0;
        int aboveVerticalGap = 0;
        Point recommendedLocationForNorth = recommendedLocation;
        while (resultLocation == null && (isStillFreeSpaceAbove || isStillFreeSpaceBelow)) {
            Option<Rectangle> optionalConflictingRectangle;
            if (isStillFreeSpaceBelow) {
                belowTestPoint.y += belowVerticalGap;
                optionalConflictingRectangle = this.conflicts(belowTestPoint, borderItem, portsFiguresToIgnore, additionalFiguresForConflictDetection);
                if (optionalConflictingRectangle.some()) {
                    belowVerticalGap = ((Rectangle)optionalConflictingRectangle.get()).y + ((Rectangle)optionalConflictingRectangle.get()).height - belowTestPoint.y + 1;
                    if (belowTestPoint.y + belowVerticalGap + borderItemSize.height > this.getParentBorder().getBottomLeft().y) {
                        isStillFreeSpaceBelow = false;
                    }
                } else {
                    resultLocation = belowTestPoint;
                }
            }
            if (!isStillFreeSpaceAbove || resultLocation != null) continue;
            aboveTestPoint.y -= aboveVerticalGap;
            optionalConflictingRectangle = this.conflicts(aboveTestPoint, borderItem, portsFiguresToIgnore, additionalFiguresForConflictDetection);
            if (optionalConflictingRectangle.some()) {
                aboveVerticalGap = aboveTestPoint.y - (((Rectangle)optionalConflictingRectangle.get()).y - borderItemSize.height - 1);
                if (aboveTestPoint.y - aboveVerticalGap >= this.getParentBorder().getTopRight().y) continue;
                isStillFreeSpaceAbove = false;
                if (circuitCount == 3) {
                    resultLocation = ((Rectangle)optionalConflictingRectangle.get()).getTopLeft();
                    continue;
                }
                recommendedLocationForNorth = new Point(((Rectangle)optionalConflictingRectangle.get()).x - borderItemSize.width - 1, aboveTestPoint.y - aboveVerticalGap);
                continue;
            }
            resultLocation = aboveTestPoint;
        }
        if (resultLocation == null) {
            resultLocation = this.locateOnBorder(recommendedLocationForNorth, 1, circuitCount + 1, borderItem, portsFiguresToIgnore, additionalFiguresForConflictDetection);
        }
        return resultLocation;
    }

    protected Point locateOnParent(Point suggestedLocation, int suggestedSide, IFigure borderItem) {
        Rectangle bounds = this.getParentBorder();
        int parentFigureWidth = bounds.width;
        int parentFigureHeight = bounds.height;
        int parentFigureX = bounds.x;
        int parentFigureY = bounds.y;
        Dimension borderItemSize = this.getSize(borderItem);
        int newX = suggestedLocation.x;
        int newY = suggestedLocation.y;
        int westX = parentFigureX - borderItemSize.width + this.getBorderItemOffset().width;
        int eastX = parentFigureX + parentFigureWidth - this.getBorderItemOffset().width;
        int southY = parentFigureY + parentFigureHeight - this.getBorderItemOffset().height;
        int northY = parentFigureY - borderItemSize.height + this.getBorderItemOffset().height;
        if (suggestedSide == 8) {
            if (suggestedLocation.x != westX) {
                newX = westX;
            }
            if (suggestedLocation.y < parentFigureY) {
                newY = parentFigureY;
            } else if (suggestedLocation.y > bounds.getBottomLeft().y - borderItemSize.height) {
                newY = bounds.getBottomLeft().y - borderItemSize.height;
            }
        } else if (suggestedSide == 16) {
            if (suggestedLocation.x != eastX) {
                newX = eastX;
            }
            if (suggestedLocation.y < parentFigureY) {
                newY = parentFigureY;
            } else if (suggestedLocation.y > bounds.getBottomLeft().y - borderItemSize.height) {
                newY = bounds.getBottomLeft().y - borderItemSize.height;
            }
        } else if (suggestedSide == 4) {
            if (suggestedLocation.y != southY) {
                newY = southY;
            }
            if (borderItemSize.width > bounds.width) {
                newX = parentFigureX - (borderItemSize.width - bounds.width) / 2;
            } else if (suggestedLocation.x < parentFigureX) {
                newX = parentFigureX;
            } else if (suggestedLocation.x > bounds.getBottomRight().x - borderItemSize.width) {
                newX = bounds.getBottomRight().x - borderItemSize.width;
            }
        } else {
            if (suggestedLocation.y != northY) {
                newY = northY;
            }
            if (borderItemSize.width > bounds.width) {
                newX = parentFigureX - (borderItemSize.width - bounds.width) / 2;
            } else if (suggestedLocation.x < parentFigureX) {
                newX = parentFigureX;
            } else if (suggestedLocation.x > bounds.getBottomRight().x - borderItemSize.width) {
                newX = bounds.getBottomRight().x - borderItemSize.width;
            }
        }
        return new Point(newX, newY);
    }

    protected Option<Rectangle> conflicts(Point recommendedLocation, final IFigure targetBorderItem, Collection<IFigure> portsFiguresToIgnore, List<IFigure> additionalFiguresForConflictDetection) {
        Rectangle recommendedRect = new Rectangle(recommendedLocation, this.getSize(targetBorderItem));
        Option<Rectangle> conflictedRectangle = this.conflicts(recommendedRect, this.getBrotherFigures(targetBorderItem), portsFiguresToIgnore);
        if (!conflictedRectangle.some() && additionalFiguresForConflictDetection != null && additionalFiguresForConflictDetection.size() > 0) {
            Iterable feedbackFigures = Iterables.transform(additionalFiguresForConflictDetection, (Function)new Function<IFigure, IFigure>(){

                public IFigure apply(IFigure input) {
                    Rectangle newBounds = new Rectangle(input.getBounds());
                    input.translateToAbsolute((Translatable)newBounds);
                    targetBorderItem.translateToRelative((Translatable)newBounds);
                    input.setBounds(newBounds);
                    return input;
                }
            });
            conflictedRectangle = this.conflicts(recommendedRect, Lists.newArrayList((Iterable)feedbackFigures), portsFiguresToIgnore);
            for (IFigure figure : additionalFiguresForConflictDetection) {
                Rectangle newBounds = new Rectangle(figure.getBounds());
                targetBorderItem.translateToAbsolute((Translatable)newBounds);
                figure.translateToRelative((Translatable)newBounds);
                figure.setBounds(newBounds);
            }
        }
        return conflictedRectangle;
    }

    protected List<IFigure> getBrotherFigures(IFigure targetBorderItem) {
        Iterable brotherFigures = Iterables.filter((Iterable)targetBorderItem.getParent().getChildren(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(IFigure.class), (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)targetBorderItem))));
        return Lists.newArrayList((Iterable)brotherFigures);
    }

    protected Option<Rectangle> conflicts(Rectangle recommendedRect, List<IFigure> figuresToCheck, Collection<IFigure> portsFiguresToIgnore) {
        ListIterator<IFigure> iterator = figuresToCheck.listIterator();
        while (iterator.hasNext()) {
            IFigure borderItem = iterator.next();
            if (portsFiguresToIgnore.contains(borderItem)) continue;
            boolean takeIntoAccount = true;
            if (borderItem.getParent().getLayoutManager() == null) {
                if (!(borderItem.getParent() instanceof Layer)) {
                    takeIntoAccount = false;
                }
            } else if (borderItem.getParent().getLayoutManager().getConstraint(borderItem) instanceof DBorderItemLocator) {
                DBorderItemLocator airBorderItemLocator = (DBorderItemLocator)((Object)borderItem.getParent().getLayoutManager().getConstraint(borderItem));
                takeIntoAccount = airBorderItemLocator.located;
            }
            if (!borderItem.isVisible() || !takeIntoAccount) continue;
            Rectangle rect = new Rectangle(borderItem.getBounds());
            if (portsFiguresToIgnore.contains(borderItem) || !rect.intersects(recommendedRect)) continue;
            return Options.newSome((Object)rect);
        }
        return Options.newNone();
    }

    public void setConstraint(Rectangle theConstraint) {
        if (!theConstraint.equals((Object)this.getConstraint())) {
            this.borderItemHasMoved = true;
        }
        super.setConstraint(theConstraint);
    }

    public Rectangle getCurrentConstraint() {
        return super.getConstraint().getCopy();
    }

    public static int findClosestSideOfParent(Rectangle proposedLocation, Rectangle parentBorder) {
        int position;
        Point parentCenter = parentBorder.getCenter();
        Point childCenter = proposedLocation.getCenter();
        if (childCenter.x < parentCenter.x) {
            if (childCenter.y < parentCenter.y) {
                Point parentTopLeft = parentBorder.getTopLeft();
                position = childCenter.y < parentTopLeft.y ? 1 : (childCenter.x - parentTopLeft.x <= childCenter.y - parentTopLeft.y ? 8 : 1);
            } else {
                Point parentBottomLeft = parentBorder.getBottomLeft();
                position = childCenter.y > parentBottomLeft.y ? 4 : (childCenter.x - parentBottomLeft.x <= parentBottomLeft.y - childCenter.y ? 8 : 4);
            }
        } else if (childCenter.y < parentCenter.y) {
            Point parentTopRight = parentBorder.getTopRight();
            position = childCenter.y < parentTopRight.y ? 1 : (parentTopRight.x - childCenter.x <= childCenter.y - parentTopRight.y ? 16 : 1);
        } else {
            Point parentBottomRight = parentBorder.getBottomRight();
            position = childCenter.y > parentBottomRight.y ? 4 : (parentBottomRight.x - childCenter.x <= parentBottomRight.y - childCenter.y ? 16 : 4);
        }
        return position;
    }

    public Rectangle getValidLocation(Rectangle proposedLocation, IFigure borderItem) {
        Rectangle realLocation = new Rectangle(proposedLocation);
        int side = DBorderItemLocator.findClosestSideOfParent(proposedLocation, this.getParentBorder());
        Point newTopLeft = this.locateOnBorder(realLocation.getTopLeft(), side, 0, borderItem);
        realLocation.setLocation(newTopLeft);
        return realLocation;
    }

    public void unfix() {
        this.located = false;
    }

    public Rectangle getValidLocation(Rectangle proposedLocation, IFigure borderItem, Collection<IFigure> figuresToIgnore, List<IFigure> additionalFiguresForConflictDetection) {
        Rectangle realLocation = new Rectangle(proposedLocation);
        int side = DBorderItemLocator.findClosestSideOfParent(proposedLocation, this.getParentBorder());
        Point newTopLeft = this.locateOnBorder(realLocation.getTopLeft(), side, 0, borderItem, figuresToIgnore, additionalFiguresForConflictDetection);
        realLocation.setLocation(newTopLeft);
        return realLocation;
    }

    public void setFiguresToIgnoresDuringNextRelocate(List<IFigure> figuresToIgnore) {
        this.figuresToIgnoreDuringNextRelocate = figuresToIgnore;
    }
}

