/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.actions;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.api.helper.graphicalfilters.HideFilterHelper;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.ui.business.api.provider.AbstractDDiagramElementLabelItemProvider;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDDiagramEditPart;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.AbstractDiagramAction;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.visibility.HideDDiagramElementAction;
import org.eclipse.sirius.diagram.ui.tools.internal.dialogs.DiagramElementsSelectionDialog;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.DDiagramEditorImpl;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class SelectHiddenElementsAction
extends AbstractDiagramAction {
    private static final String TITLE = "Diagram elements visibility";
    private static final String MESSAGE = "Visible diagram elements are checked.";
    private static final String TOOLTIP = "Show/Hide";
    private static final String ICON_PATH = "icons/categoryWizard.gif";
    private static final ImageDescriptor DESC_HIDE = DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/categoryWizard.gif");
    private final Predicate<Object> isVisible = new Predicate<Object>(){

        public boolean apply(Object input) {
            Option<DDiagramElement> optionTarget;
            boolean result = false;
            if (input instanceof DDiagramElement) {
                result = !new DDiagramElementQuery((DDiagramElement)input).isHidden();
            } else if (input instanceof AbstractDDiagramElementLabelItemProvider && (optionTarget = ((AbstractDDiagramElementLabelItemProvider)((Object)input)).getDiagramElementTarget()).some()) {
                result = !new DDiagramElementQuery((DDiagramElement)optionTarget.get()).isLabelHidden();
            }
            return result;
        }
    };
    private final Function<Object, Void> hideElement = new Function<Object, Void>(){

        public Void apply(Object from) {
            Option<DDiagramElement> optionTarget;
            if (from instanceof DDiagramElement) {
                HideFilterHelper.INSTANCE.hide((DDiagramElement)from);
            } else if (from instanceof AbstractDDiagramElementLabelItemProvider && (optionTarget = ((AbstractDDiagramElementLabelItemProvider)((Object)from)).getDiagramElementTarget()).some()) {
                HideFilterHelper.INSTANCE.hideLabel((DDiagramElement)optionTarget.get());
            }
            return null;
        }
    };
    private final Function<Object, Void> revealElement = new Function<Object, Void>(){

        public Void apply(Object from) {
            if (from instanceof DDiagramElement) {
                HideFilterHelper.INSTANCE.reveal((DDiagramElement)from);
            } else if (from instanceof AbstractDDiagramElementLabelItemProvider) {
                HideFilterHelper.INSTANCE.revealLabel((DDiagramElement)((AbstractDDiagramElementLabelItemProvider)((Object)from)).getTarget());
            }
            return null;
        }
    };

    public SelectHiddenElementsAction(IWorkbenchPage workbenchPage) {
        super(workbenchPage);
        this.setText(TOOLTIP);
        this.setId("selectHiddenElementsAction");
        this.setToolTipText(TOOLTIP);
        this.setImageDescriptor(DESC_HIDE);
    }

    public SelectHiddenElementsAction(IWorkbenchPage workbenchPage, IDiagramWorkbenchPart part) {
        super(workbenchPage);
        this.setWorkbenchPart((IWorkbenchPart)part);
        this.setText(TOOLTIP);
        this.setId("selectHiddenElementsAction");
        this.setToolTipText(TOOLTIP);
        this.setImageDescriptor(this.getImage());
    }

    private ImageDescriptor getImage() {
        EObject diagram;
        Diagram gmfDiagram;
        if (this.getWorkbenchPart() instanceof DDiagramEditorImpl && (gmfDiagram = ((DDiagramEditorImpl)this.getWorkbenchPart()).getDiagram()) != null && (diagram = gmfDiagram.getElement()) instanceof DDiagram && !((DDiagram)diagram).getHiddenElements().isEmpty()) {
            return DiagramUIPlugin.Implementation.getDecoratedCheckedImageDescriptor(DESC_HIDE);
        }
        return DESC_HIDE;
    }

    protected Request createTargetRequest() {
        return null;
    }

    protected boolean isSelectionListener() {
        return false;
    }

    private Shell getShell() {
        return this.getWorkbenchPart().getSite().getShell();
    }

    protected Command getCommand() {
        DiagramEditPart diagramEditPart;
        UnexecutableCommand result = UnexecutableCommand.INSTANCE;
        if (this.getDiagramGraphicalViewer() != null && (diagramEditPart = this.getDiagramEditPart()) instanceof IDDiagramEditPart) {
            result = this.getElementsSelectionCommand((IDDiagramEditPart)diagramEditPart);
        }
        return result;
    }

    private Command getElementsSelectionCommand(IDDiagramEditPart diagramEditPart) {
        EObject semanticElement;
        UnexecutableCommand elementsSelectionCommand = UnexecutableCommand.INSTANCE;
        if (diagramEditPart.getEditingDomain() != null && diagramEditPart.getEditingDomain().getCommandStack() != null && (semanticElement = diagramEditPart.resolveSemanticElement()) instanceof DDiagram) {
            DDiagram diagram = (DDiagram)semanticElement;
            elementsSelectionCommand = new ICommandProxy((ICommand)new HiddenElementsSelectionCommand(diagramEditPart.getEditingDomain(), TOOLTIP, diagram));
        }
        return elementsSelectionCommand;
    }

    private final class HiddenElementsSelectionCommand
    extends AbstractTransactionalCommand {
        private final DDiagram diagram;

        private HiddenElementsSelectionCommand(TransactionalEditingDomain domain, String label, DDiagram diagram) {
            super(domain, label, null);
            this.diagram = diagram;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            DiagramElementsSelectionDialog dlg = new DiagramElementsSelectionDialog(SelectHiddenElementsAction.TITLE, SelectHiddenElementsAction.MESSAGE);
            dlg.setSelectionPredicate((Predicate<Object>)SelectHiddenElementsAction.this.isVisible);
            dlg.setSelectedAction((Function<Object, Void>)SelectHiddenElementsAction.this.revealElement);
            dlg.setDeselectedAction((Function<Object, Void>)SelectHiddenElementsAction.this.hideElement);
            dlg.setGrayedPredicate(this.getNonSelectablePredicate());
            boolean executed = dlg.open(SelectHiddenElementsAction.this.getShell(), this.diagram, true);
            if (executed) {
                return CommandResult.newOKCommandResult();
            }
            return CommandResult.newCancelledCommandResult();
        }

        private Predicate<Object> getNonSelectablePredicate() {
            final Predicate<DDiagramElement> allowsHideReveal = HideDDiagramElementAction.allowsHideReveal(this.diagram);
            if (Predicates.alwaysTrue().equals(allowsHideReveal)) {
                return Predicates.alwaysFalse();
            }
            return new Predicate<Object>(){

                public boolean apply(Object input) {
                    if (input instanceof DDiagramElement) {
                        return !allowsHideReveal.apply((Object)((DDiagramElement)input));
                    }
                    return false;
                }
            };
        }
    }
}

