/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.synchronizer;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.synchronizer.ChildCreationSupport;
import org.eclipse.sirius.synchronizer.CreatedOutput;
import org.eclipse.sirius.synchronizer.MappingHiearchyTable;
import org.eclipse.sirius.synchronizer.OutputDescriptor;
import org.eclipse.sirius.synchronizer.PreRefreshStatus;
import org.eclipse.sirius.synchronizer.RefreshPlan;
import org.eclipse.sirius.synchronizer.RefreshPlanner;
import org.eclipse.sirius.synchronizer.SemanticPartitionInvalidator;
import org.eclipse.sirius.synchronizer.SignatureProvider;

public class ModelToModelSynchronizer {
    private SemanticPartitionInvalidator evaluator;
    private MappingHiearchyTable table;
    private PreRefreshStatus pre;
    private SignatureProvider signatureProvider;

    public ModelToModelSynchronizer(SemanticPartitionInvalidator evaluator, MappingHiearchyTable table, PreRefreshStatus pre, SignatureProvider signProvider) {
        this.evaluator = evaluator;
        this.table = table;
        this.pre = pre;
        this.signatureProvider = signProvider;
    }

    public void update(CreatedOutput container, boolean fullRefresh) {
        EObject createdElement;
        RefreshPlan plan = new RefreshPlanner(this.table, this.evaluator, this.pre, this.signatureProvider).computePlan(container);
        Collection<CreatedOutput> descriptorsToDelete = plan.getDescriptorsToDelete();
        Collection<OutputDescriptor> descriptorsToCreate = plan.getDescriptorsToCreate();
        Collection<CreatedOutput> descriptorsToRefresh = plan.getDescriptorsToRefresh();
        Option<? extends ChildCreationSupport> childSupport = container.getChildSupport();
        if (container.synchronizeChildren() || fullRefresh) {
            if (childSupport.some()) {
                ChildCreationSupport containerChildSupport = (ChildCreationSupport)childSupport.get();
                for (CreatedOutput outDesc : descriptorsToDelete) {
                    containerChildSupport.deleteChild(outDesc);
                }
                ArrayList newlyCreated = Lists.newArrayList();
                for (OutputDescriptor outDesc : descriptorsToCreate) {
                    CreatedOutput newOne = containerChildSupport.createChild(outDesc);
                    newOne.refresh();
                    newlyCreated.add(newOne);
                }
                Iterable createdOrRefreshed = Iterables.concat(descriptorsToRefresh, (Iterable)newlyCreated);
                containerChildSupport.reorderChilds(createdOrRefreshed);
                for (CreatedOutput createdOutput : createdOrRefreshed) {
                    this.update(createdOutput, fullRefresh);
                }
            }
            for (CreatedOutput outDesc : plan.getDescriptorToUpdateMapping()) {
                outDesc.updateMapping();
                outDesc.refresh();
            }
            for (CreatedOutput outDesc : descriptorsToRefresh) {
                outDesc.refresh();
            }
        } else if (childSupport.some() && (createdElement = container.getCreatedElement()) != null && descriptorsToRefresh.isEmpty() && !descriptorsToCreate.isEmpty()) {
            ChildCreationSupport containerChildSupport = (ChildCreationSupport)childSupport.get();
            OutputDescriptor outDesc = descriptorsToCreate.iterator().next();
            containerChildSupport.createChild(outDesc);
        }
    }
}

