/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.editor;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.dialect.command.RefreshRepresentationsCommand;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionListener;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.sirius.table.business.internal.refresh.DTableElementSynchronizerSpec;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.metamodel.table.DTableElementSynchronizer;
import org.eclipse.sirius.table.metamodel.table.provider.TableUIPlugin;
import org.eclipse.sirius.table.tools.api.command.ITableCommandFactory;
import org.eclipse.sirius.table.tools.api.command.ITableCommandFactoryProvider;
import org.eclipse.sirius.table.tools.api.command.TableCommandFactoryService;
import org.eclipse.sirius.table.ui.tools.api.editor.DTableEditor;
import org.eclipse.sirius.table.ui.tools.internal.command.EMFCommandFactoryUI;
import org.eclipse.sirius.table.ui.tools.internal.editor.DTableViewerManager;
import org.eclipse.sirius.table.ui.tools.internal.editor.Messages;
import org.eclipse.sirius.table.ui.tools.internal.editor.RefreshAtOpeningActivator;
import org.eclipse.sirius.table.ui.tools.internal.editor.provider.DTableEditorUtil;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.sirius.tools.api.interpreter.InterpreterRegistry;
import org.eclipse.sirius.ui.business.api.descriptor.ComposedImageDescriptor;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.business.api.dialect.marker.TraceabilityMarkerNavigationProvider;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionEditorInput;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.ui.tools.internal.editor.AbstractDTreeEditor;
import org.eclipse.sirius.ui.tools.internal.editor.AbstractDTreeViewer;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorMatchingStrategy;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.FileEditorInput;

public abstract class AbstractDTableEditor
extends AbstractDTreeEditor
implements DTableEditor {
    private static final String CONTRIBUTOR_ID = "org.eclipse.sirius.table.ui.EditorID";
    private static final String CONTEXT_ID = "org.eclipse.sirius.table.ui.EditorID.tableContext";
    protected AdapterFactory adapterFactory;
    private DTable tableModel;
    private IPartListener refreshAtOpeningActivator;

    private IInterpreter getInterpreter() {
        return SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(this.getTableModel().getTarget());
    }

    public void doSave(IProgressMonitor progressMonitor) {
        if (this.isDeleted(this.getEditorInput())) {
            if (this.isSaveAsAllowed()) {
                this.performSaveAs(progressMonitor);
            } else {
                Shell shell = this.getSite().getShell();
                String title = Messages.dTableEditor_ErrorSaveDeletedTitle;
                String msg = Messages.dTableEditor_ErrorSaveDeletedMessage;
                MessageDialog.openError((Shell)shell, (String)title, (String)msg);
            }
        } else {
            this.performSave(false, progressMonitor);
        }
    }

    private void performSaveAs(IProgressMonitor progressMonitor) {
        IFile original;
        Shell shell = this.getSite().getShell();
        IEditorInput input = this.getEditorInput();
        SaveAsDialog dialog = new SaveAsDialog(shell);
        IFile iFile = original = input instanceof IFileEditorInput ? ((IFileEditorInput)input).getFile() : null;
        if (original != null) {
            dialog.setOriginalFile(original);
        }
        dialog.create();
        if (this.isDeleted(input) && original != null) {
            String message = NLS.bind((String)Messages.dTableEditor_SavingDeletedFile, (Object)original.getName());
            dialog.setErrorMessage(null);
            dialog.setMessage(message, 2);
        }
        if (dialog.open() == 1) {
            if (progressMonitor != null) {
                progressMonitor.setCanceled(true);
            }
        } else {
            IEditorReference[] editorRefs;
            IPath filePath = dialog.getResult();
            if (filePath == null) {
                if (progressMonitor != null) {
                    progressMonitor.setCanceled(true);
                }
                return;
            }
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IFile file = workspaceRoot.getFile(filePath);
            FileEditorInput newInput = new FileEditorInput(file);
            IEditorMatchingStrategy matchingStrategy = this.getEditorDescriptor().getEditorMatchingStrategy();
            IEditorReference[] iEditorReferenceArray = editorRefs = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
            int n = editorRefs.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference editorRef = iEditorReferenceArray[n2];
                if (matchingStrategy.matches(editorRef, (IEditorInput)newInput)) {
                    MessageDialog.openWarning((Shell)shell, (String)Messages.dTableEditor_SaveAsErrorTitle, (String)Messages.dTableEditor_SaveAsErrorMessage);
                    return;
                }
                ++n2;
            }
            if (progressMonitor != null) {
                progressMonitor.setCanceled(true);
            }
        }
    }

    public void doSaveAs() {
        if (this.isSaveAsAllowed()) {
            try {
                new ProgressMonitorDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell()).run(false, false, (IRunnableWithProgress)new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                        AbstractDTableEditor.this.performSaveAs(monitor);
                    }
                });
            }
            catch (InterruptedException e) {
                Status status = new Status(4, "org.eclipse.sirius.table.ui", e.getLocalizedMessage(), (Throwable)e);
                TableUIPlugin.getPlugin().getLog().log((IStatus)status);
            }
            catch (InvocationTargetException e) {
                Status status = new Status(4, "org.eclipse.sirius.table.ui", e.getLocalizedMessage(), e.getTargetException());
                TableUIPlugin.getPlugin().getLog().log((IStatus)status);
            }
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        Collection sessions = SessionManager.INSTANCE.getSessions();
        if (sessions.isEmpty() && !this.isClosing) {
            SessionManager.INSTANCE.addSessionsListener(this.sessionManagerListener);
        }
        this.isClosing = false;
        if (input instanceof SessionEditorInput) {
            SessionEditorInput sessionEditorInput = (SessionEditorInput)input;
            URI uri = sessionEditorInput.getURI();
            this.session = sessionEditorInput.getSession();
            this.setTableModel(this.getDTable(uri, false));
        }
        this.setInput(input);
        if (this.session != null) {
            this.session.addListener((SessionListener)this);
        }
        this.configureCommandFactoryProviders();
        IEditingSession uiSession = SessionUIManager.INSTANCE.getOrCreateUISession(this.session);
        uiSession.open();
        uiSession.attachEditor((DialectEditor)this);
        this.setAccessor(SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor((EObject)this.getTableModel()));
        if (this.getTableModel() != null) {
            DTableElementSynchronizerSpec sync = new DTableElementSynchronizerSpec(this.accessor, this.getInterpreter());
            this.getTableModel().activate((DTableElementSynchronizer)sync);
            this.notify(1);
            if (DialectUIManager.INSTANCE.isRefreshActivatedOnRepresentationOpening()) {
                this.launchRefresh();
            }
            this.initialTitleImage = this.getTitleImage();
            this.initCollaborativeIPermissionAuthority((DSemanticDecorator)this.getTableModel());
        }
    }

    private void configureCommandFactoryProviders() {
        this.emfCommandFactory = TableCommandFactoryService.getInstance().getNewProvider().getCommandFactory(this.getEditingDomain());
        this.emfCommandFactory.setUserInterfaceCallBack((UICallBack)new EMFCommandFactoryUI());
    }

    private DTable getDTable(URI uri, boolean loadOnDemand) {
        EObject rootElement;
        DTable result = null;
        Resource resource = this.getEditingDomain().getResourceSet().getResource(uri.trimFragment(), loadOnDemand);
        if (resource != null && resource.isLoaded() && uri.fragment() != null && (rootElement = resource.getEObject(uri.fragment())) instanceof DTable) {
            result = (DTable)rootElement;
        }
        return result;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        DslCommonPlugin.PROFILER.startWork("Create the SWT table");
        if (this.getTableModel() == null) {
            Label errorLabel = new Label(parent, 0x1000000);
            errorLabel.setText("This table was not saved. You can close the editor");
            return;
        }
        this.treeViewerManager = new DTableViewerManager(parent, this.getTableModel(), this.getEditingDomain(), this.accessor, (ITableCommandFactory)this.emfCommandFactory, this);
        DslCommonPlugin.PROFILER.stopWork("Create the SWT table");
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewerManager.getTreeViewer());
        EObject semantic = null;
        if (this.tableModel != null) {
            semantic = this.tableModel.getTarget();
        }
        if (semantic == null) {
            TreeIterator allContents = this.getEditingDomain().getResourceSet().getAllContents();
            while (allContents.hasNext() && semantic == null) {
                Object next = allContents.next();
                if (!(next instanceof DSemanticDecorator)) continue;
                semantic = ((DSemanticDecorator)next).getTarget();
            }
        }
        EObject anyEObject = semantic;
        Iterator iterResources = this.getEditingDomain().getResourceSet().getResources().iterator();
        while (iterResources.hasNext() && anyEObject == null) {
            Resource res = (Resource)iterResources.next();
            if (res.getContents().isEmpty()) continue;
            anyEObject = (EObject)res.getContents().get(0);
        }
        Resource resource = anyEObject.eResource();
        if (resource.getResourceSet() != this.getEditingDomain().getResourceSet()) {
            resource.unload();
        }
        if (anyEObject != null) {
            IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(anyEObject);
            InterpreterRegistry.prepareImportsFromSession((IInterpreter)interpreter, (Session)SessionManager.INSTANCE.getSession(anyEObject));
        }
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
        this.refreshAtOpeningActivator = new RefreshAtOpeningActivator(this.session, this);
        this.getSite().getPage().addPartListener(this.refreshAtOpeningActivator);
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        contextService.activateContext(CONTEXT_ID);
    }

    public void setInput(IEditorInput input) {
        super.setInput(input);
        if (this.treeViewerManager != null) {
            this.enablePropertiesUpdate(false);
            DTableEditorUtil.updateViewerColumns(this.treeViewerManager, this.getTableModel());
            this.enablePropertiesUpdate(true);
        }
    }

    public Image getFrozenRepresentationImage() {
        if (this.frozenRepresentationImage == null || this.frozenRepresentationImage.isDisposed()) {
            Image refreshImage = TableUIPlugin.Implementation.getImage(TableUIPlugin.Implementation.getBundledImageDescriptor("icons/table/refresh.gif"));
            ArrayList<Image> images = new ArrayList<Image>(2);
            images.add(refreshImage);
            Image lockByOtherOverlayIamge = SiriusEditPlugin.getPlugin().getImage(SiriusEditPlugin.Implementation.getBundledImageDescriptor((String)"icons/full/decorator/permission_denied_overlay.gif"));
            images.add(lockByOtherOverlayIamge);
            ComposedImageDescriptor composedImageDescriptor = new ComposedImageDescriptor(new ComposedImage(images));
            this.frozenRepresentationImage = SiriusEditPlugin.getPlugin().getImage((ImageDescriptor)composedImageDescriptor);
        }
        return this.frozenRepresentationImage;
    }

    @Override
    public Control getControl() {
        AbstractDTreeViewer treeViewer = this.getTableViewer().getTreeViewer();
        return treeViewer.getTree();
    }

    public void setFocus() {
        if (this.treeViewerManager != null) {
            IEditorInput editorInput;
            super.setFocus();
            if (this.tableModel != null && this.tableModel.eIsProxy() && this.session != null && (editorInput = this.getEditorInput()) instanceof URIEditorInput) {
                URIEditorInput sessionEditorInput = (URIEditorInput)editorInput;
                URI uri = sessionEditorInput.getURI();
                this.setTableModel(this.getDTable(uri, false));
                IEditingSession uiSession = SessionUIManager.INSTANCE.getUISession(this.session);
                if (uiSession != null && this.tableModel != null) {
                    uiSession.detachEditor((DialectEditor)this);
                    uiSession.attachEditor((DialectEditor)this);
                }
                if (this.dRepresentationLockStatusListener != null) {
                    IPermissionAuthority permissionAuthority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority((EObject)this.tableModel);
                    permissionAuthority.removeAuthorityListener(this.dRepresentationLockStatusListener);
                    this.initCollaborativeIPermissionAuthority((DSemanticDecorator)this.tableModel);
                }
            }
            this.checkSemanticAssociation();
        }
    }

    private void checkSemanticAssociation() {
        if (this.tableModel == null || this.tableModel.eResource() == null || this.tableModel.getTarget() == null || this.tableModel.getTarget().eResource() == null) {
            this.myDialogFactory.editorWillBeClosedInformationDialog(this.getSite().getShell());
            DialectUIManager.INSTANCE.closeEditor((IEditorPart)this, false);
        }
    }

    protected void launchRefresh() {
        this.getEditingDomain().getCommandStack().execute((Command)new RefreshRepresentationsCommand(this.getEditingDomain(), (IProgressMonitor)new NullProgressMonitor(), new DRepresentation[]{this.getTableModel()}));
    }

    public String getContributorId() {
        return CONTRIBUTOR_ID;
    }

    public DRepresentation getRepresentation() {
        return this.tableModel;
    }

    public DTable getTableModel() {
        return this.tableModel;
    }

    protected void setTableModel(DTable tableModel) {
        this.tableModel = tableModel;
    }

    public void validateRepresentation() {
    }

    private void setAccessor(ModelAccessor accessor) {
        this.accessor = accessor;
        ((ITableCommandFactory)this.emfCommandFactory).setModelAccessor(this.accessor);
    }

    public void gotoMarker(IMarker marker) {
        if (TraceabilityMarkerNavigationProvider.isTraceabilityMarker((IMarker)marker)) {
            new TraceabilityMarkerNavigationProvider((DialectEditor)this).gotoMarker(marker);
        } else {
            this.doGoToMarker(marker);
        }
    }

    protected void doGoToMarker(IMarker marker) {
        String tableURI = marker.getAttribute("REPRESENTATION_URI", null);
        String elementId = marker.getAttribute("REPRESENTATION_ELEMENT_ID", null);
        if (tableURI == null || elementId == null) {
            return;
        }
        URI markerTableURI = URI.createURI((String)tableURI);
        DTable markerTable = (DTable)this.getTableModel().eResource().getEObject(markerTableURI.fragment());
        if (markerTable != null) {
            EObject searchedElement = markerTable.eResource().getEObject(elementId);
            TreeItem contains = this.contains(this.getTableViewer().getTreeViewer().getTree().getItems(), searchedElement);
            if (contains != null) {
                TreeSelection selection = new TreeSelection(this.getTreePathFromItem(contains));
                this.getTableViewer().getTreeViewer().setSelection((ISelection)selection);
            }
        }
    }

    protected TreePath getTreePathFromItem(TreeItem item) {
        LinkedList<Object> segments = new LinkedList<Object>();
        TreeItem myItem = item;
        while (myItem != null) {
            Object segment = item.getData();
            Assert.isNotNull((Object)segment);
            segments.addFirst(segment);
            myItem = myItem.getParentItem();
        }
        return new TreePath(segments.toArray());
    }

    public Object getAdapter(Class type) {
        Object result = super.getAdapter(type);
        if (result == null && type == ITableCommandFactoryProvider.class) {
            result = this.emfCommandFactory;
        }
        return result;
    }

    @Override
    public AdapterFactory getAdapterFactory() {
        if (this.adapterFactory == null) {
            this.adapterFactory = TableUIPlugin.getPlugin().createAdapterFactory();
        }
        return this.adapterFactory;
    }

    public void dispose() {
        super.dispose();
        if (this.getAdapterFactory() instanceof IDisposable) {
            ((IDisposable)this.getAdapterFactory()).dispose();
        }
        if (this.refreshAtOpeningActivator != null) {
            this.getSite().getPage().removePartListener(this.refreshAtOpeningActivator);
            this.refreshAtOpeningActivator = null;
        }
    }
}

