/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.business.internal.dialect.description;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.dialect.description.AbstractInterpretedExpressionQuery;
import org.eclipse.sirius.business.api.dialect.description.DefaultInterpretedExpressionTargetSwitch;
import org.eclipse.sirius.business.api.dialect.description.IInterpretedExpressionTargetSwitch;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.table.business.internal.dialect.description.TableInterpretedTargetSwitch;
import org.eclipse.sirius.table.metamodel.table.TablePackage;
import org.eclipse.sirius.table.metamodel.table.description.CreateCellTool;
import org.eclipse.sirius.table.metamodel.table.description.DescriptionPackage;
import org.eclipse.sirius.table.metamodel.table.description.LabelEditTool;
import org.eclipse.sirius.viewpoint.description.tool.EditMaskVariables;

public class TableInterpretedExpressionQuery
extends AbstractInterpretedExpressionQuery {
    public TableInterpretedExpressionQuery(EObject target, EStructuralFeature feature) {
        super(target, feature);
    }

    public Collection<EPackage> getPackagesToImport() {
        Collection superResult = super.getPackagesToImport();
        superResult.add(TablePackage.eINSTANCE);
        superResult.add(DescriptionPackage.eINSTANCE);
        return superResult;
    }

    protected void initializeTargetSwitch() {
        this.targetSwitch = new TableGlobalInterpretedTargetSwitch();
    }

    protected void appendAllLocalVariableDefinitions(Map<String, Collection<String>> definitions, EObject context) {
        super.appendAllLocalVariableDefinitions(definitions, context);
        EditMaskVariables emv = null;
        if (context instanceof LabelEditTool) {
            emv = ((LabelEditTool)context).getMask();
        } else if (context instanceof CreateCellTool) {
            emv = ((CreateCellTool)context).getMask();
        }
        if (emv != null) {
            this.appendEditMaskVariables(emv, definitions);
        }
    }

    protected Option<EObject> getToolContext() {
        Option result = super.getToolContext();
        if (!result.some()) {
            result = new EObjectQuery(this.target).getFirstAncestorOfType(DescriptionPackage.eINSTANCE.getTableTool());
        }
        return result;
    }

    private class TableGlobalInterpretedTargetSwitch
    implements IInterpretedExpressionTargetSwitch {
        private final DefaultInterpretedExpressionTargetSwitch defaultSwitch;
        private final TableInterpretedTargetSwitch specificTableSwitch;

        private TableGlobalInterpretedTargetSwitch() {
            this.defaultSwitch = new DefaultInterpretedExpressionTargetSwitch(TableInterpretedExpressionQuery.this.feature, (IInterpretedExpressionTargetSwitch)this);
            this.specificTableSwitch = new TableInterpretedTargetSwitch(TableInterpretedExpressionQuery.this.feature, this);
        }

        public Option<Collection<String>> doSwitch(EObject target, boolean considerFeature) {
            LinkedHashSet targetTypes = Sets.newLinkedHashSet();
            Option expressionTarget = Options.newSome((Object)targetTypes);
            if (target != null) {
                String packageURI = target.eClass().getEPackage().getNsURI();
                if (DescriptionPackage.eINSTANCE.getNsURI().equals(packageURI)) {
                    this.specificTableSwitch.setConsiderFeature(considerFeature);
                    expressionTarget = this.specificTableSwitch.doSwitch(target);
                }
                if (expressionTarget.some() && ((Collection)expressionTarget.get()).isEmpty()) {
                    expressionTarget = this.defaultSwitch.doSwitch(target, considerFeature);
                }
            }
            return expressionTarget;
        }

        public EObject getFirstRelevantContainer(EObject obj) {
            return this.defaultSwitch != null ? this.defaultSwitch.getFirstRelevantContainer(obj) : null;
        }
    }
}

